/*
 * Decompiled with CFR 0.152.
 */
package de.feli490.feliutils.bdstudio;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.feli490.feliutils.bdstudio.BDComponent;
import de.feli490.feliutils.bdstudio.BDModel;
import de.feli490.feliutils.bdstudio.components.BDBlockDisplay;
import de.feli490.feliutils.bdstudio.components.BDCollection;
import de.feli490.feliutils.bdstudio.components.BDItemDisplay;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.joml.Matrix4f;

public class BDModelLoader {
    private final JavaPlugin plugin;
    private final NamespacedKey modelEntitiesKey;
    private final NamespacedKey modelRotationKey;
    private final NamespacedKey modelNameKey;

    public BDModelLoader(JavaPlugin plugin) {
        this.plugin = plugin;
        this.modelEntitiesKey = new NamespacedKey((Plugin)plugin, "model_entities");
        this.modelRotationKey = new NamespacedKey((Plugin)plugin, "model_rotation");
        this.modelNameKey = new NamespacedKey((Plugin)plugin, "model_name");
    }

    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public NamespacedKey getModelEntitiesKey() {
        return this.modelEntitiesKey;
    }

    public NamespacedKey getModelNameKey() {
        return this.modelNameKey;
    }

    public NamespacedKey getModelRotationKey() {
        return this.modelRotationKey;
    }

    public static String decompress(String compressedString) throws IOException {
        int len;
        byte[] compressedBytes = Base64.getDecoder().decode(compressedString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedBytes);
        GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = ((InputStream)gzipInputStream).read(buffer)) > 0) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        return byteArrayOutputStream.toString(StandardCharsets.UTF_8);
    }

    public static List<BDComponent> loadFromGZIP(String encodedGzippedData) throws IOException {
        String jsonData = BDModelLoader.decompress(encodedGzippedData);
        Type listType = new TypeToken<List<Map<String, Object>>>(){}.getType();
        Gson gson = new Gson();
        List data = (List)gson.fromJson(jsonData, listType);
        ArrayList<BDComponent> components = new ArrayList<BDComponent>();
        for (Map item : data) {
            components.add(BDModelLoader.loadComponent(item));
        }
        return components;
    }

    public static BDModel loadFromReader(Reader tmpReader, String modelName) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(tmpReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        List<BDComponent> components = BDModelLoader.loadFromGZIP(content.toString());
        if (components.size() == 1) {
            modelName = components.get(0).name();
        }
        return new BDModel(modelName, components);
    }

    public static BDModel loadFromFile(File file) throws IOException {
        try (FileReader fReader = new FileReader(file);){
            BDModel bDModel = BDModelLoader.loadFromReader(fReader, file.getName());
            return bDModel;
        }
    }

    public static BDModel loadFromInputStream(InputStream inputStream) throws IOException {
        return BDModelLoader.loadFromInputStream(inputStream, "");
    }

    public static BDModel loadFromInputStream(InputStream inputStream, String modelName) throws IOException {
        try (InputStreamReader streamReader = new InputStreamReader(inputStream);){
            BDModel bDModel = BDModelLoader.loadFromReader(streamReader, modelName);
            return bDModel;
        }
    }

    private static BDComponent loadComponent(Map<String, Object> item) {
        if (BDModelLoader.isCollection(item)) {
            return BDModelLoader.loadCollection(item);
        }
        if (BDModelLoader.isBlockDisplay(item)) {
            return BDModelLoader.loadBlockDisplay(item);
        }
        if (BDModelLoader.isItemDisplay(item)) {
            return BDModelLoader.loadItemDisplay(item);
        }
        return null;
    }

    private static <T extends BDComponent> T loadBase(Map<String, Object> item, BDComponentConstructor<T> constructor) {
        String name = (String)item.get("name");
        String nbt = (String)item.get("nbt");
        List transformValues = (List)item.get("transforms");
        Matrix4f transformMatrix = new Matrix4f(((Double)transformValues.get(0)).floatValue(), ((Double)transformValues.get(1)).floatValue(), ((Double)transformValues.get(2)).floatValue(), ((Double)transformValues.get(3)).floatValue(), ((Double)transformValues.get(4)).floatValue(), ((Double)transformValues.get(5)).floatValue(), ((Double)transformValues.get(6)).floatValue(), ((Double)transformValues.get(7)).floatValue(), ((Double)transformValues.get(8)).floatValue(), ((Double)transformValues.get(9)).floatValue(), ((Double)transformValues.get(10)).floatValue(), ((Double)transformValues.get(11)).floatValue(), ((Double)transformValues.get(12)).floatValue(), ((Double)transformValues.get(13)).floatValue(), ((Double)transformValues.get(14)).floatValue(), ((Double)transformValues.get(15)).floatValue()).transpose();
        return constructor.construct(name, nbt, transformMatrix);
    }

    private static boolean isCollection(Map<String, Object> item) {
        return item.containsKey("isCollection") && (Boolean)item.get("isCollection") != false;
    }

    private static BDCollection loadCollection(Map<String, Object> item) {
        BDCollection collection = BDModelLoader.loadBase(item, BDCollection::new);
        List children = (List)item.get("children");
        for (Map child : children) {
            collection.addChild(BDModelLoader.loadComponent(child));
        }
        return collection;
    }

    private static boolean isBlockDisplay(Map<String, Object> item) {
        return item.containsKey("isBlockDisplay") && (Boolean)item.get("isBlockDisplay") != false;
    }

    private static BDBlockDisplay loadBlockDisplay(Map<String, Object> item) {
        return BDModelLoader.loadBase(item, BDBlockDisplay::new);
    }

    private static boolean isItemDisplay(Map<String, Object> item) {
        return item.containsKey("isItemDisplay") && (Boolean)item.get("isItemDisplay") != false;
    }

    private static BDItemDisplay loadItemDisplay(Map<String, Object> item) {
        return BDModelLoader.loadBase(item, BDItemDisplay::new);
    }

    private static interface BDComponentConstructor<T extends BDComponent> {
        public T construct(String var1, String var2, Matrix4f var3);
    }
}

