/*
 * Decompiled with CFR 0.152.
 */
package de.feli490.feliutils.inventory.textinput;

import de.feli490.feliutils.inventory.ActionInventory;
import de.feli490.feliutils.inventory.textinput.TextInputInventory;
import de.feli490.feliutils.inventory.textinput.TextInputInventoryContainer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TextInputListener
implements Listener {
    private final JavaPlugin javaPlugin;
    private final TextInputInventoryContainer textInputInventoryContainer;

    public TextInputListener(JavaPlugin javaPlugin) {
        this.javaPlugin = javaPlugin;
        this.textInputInventoryContainer = TextInputInventoryContainer.getInstance();
    }

    @EventHandler
    public void closeInventory(InventoryCloseEvent e) {
        ActionInventory actionInventory;
        Inventory inventory = e.getInventory();
        if (!(inventory instanceof AnvilInventory)) {
            return;
        }
        AnvilInventory anvilInventory = (AnvilInventory)inventory;
        TextInputInventory textInputInventory = this.textInputInventoryContainer.getTextInputInventory(anvilInventory);
        if (textInputInventory == null) {
            return;
        }
        textInputInventory.clearInventory();
        HumanEntity player = e.getPlayer();
        if (e.getViewers().isEmpty()) {
            this.textInputInventoryContainer.removeTextInputInventory(textInputInventory);
        }
        if ((actionInventory = textInputInventory.getActionInventory()) != null && InventoryCloseEvent.Reason.PLAYER.equals((Object)e.getReason())) {
            this.javaPlugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.javaPlugin, () -> player.openInventory(actionInventory.getInventory()));
        }
    }

    @EventHandler
    public void prepareAnvil(PrepareAnvilEvent e) {
        ItemMeta itemMeta;
        TextInputInventory textInputInventory = this.textInputInventoryContainer.getTextInputInventory(e.getInventory());
        if (textInputInventory == null) {
            return;
        }
        ItemStack result = e.getResult();
        String renameText = result == null || !result.hasItemMeta() ? "" : (!(itemMeta = result.getItemMeta()).hasDisplayName() ? "" : itemMeta.getDisplayName());
        ItemStack resultItemStack = textInputInventory.getResultItemStack(renameText);
        e.setResult(resultItemStack);
    }

    @EventHandler
    public void clickInventory(InventoryClickEvent e) {
        InventoryView view = e.getView();
        Inventory inventory = view.getTopInventory();
        if (!(inventory instanceof AnvilInventory)) {
            return;
        }
        AnvilInventory anvilInventory = (AnvilInventory)inventory;
        TextInputInventory textInputInventory = this.textInputInventoryContainer.getTextInputInventory(anvilInventory);
        if (textInputInventory == null) {
            return;
        }
        e.setCancelled(true);
        if (e.getSlot() == 2) {
            textInputInventory.confirmClick();
        }
    }
}

