/*
 * Decompiled with CFR 0.152.
 */
package de.feli490.feliutils.search;

import java.util.Iterator;

public class StringIterator
implements Iterator<Character> {
    private final String text;
    private int index;

    public StringIterator(String text) {
        this.text = text;
        this.index = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.text.length();
    }

    @Override
    public Character next() {
        return Character.valueOf(this.text.charAt(this.index++));
    }

    public Character nextWithoutIncrease() {
        return this.index < this.text.length() ? Character.valueOf(this.text.charAt(this.index)) : null;
    }

    public boolean isAtEnd() {
        return this.index >= this.text.length();
    }

    public String nextUntil(char to) {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.hasNext()) {
            char c = this.next().charValue();
            if (c == to) {
                return stringBuilder.toString();
            }
            stringBuilder.append(c);
        }
        return null;
    }
}

