/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import com.destroystokyo.paper.event.inventory.PrepareResultEvent;
import de.iani.cubesideutils.bukkit.items.CustomHeads;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.plugin.OnlinePlayerDataImpl;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnvilGUI {
    private CubesideUtilsBukkit plugin;
    private Player player;
    private AnvilInventory inventory;
    private ItemStack firstItem;
    private ItemStack secondItem;
    private ItemStack resultItem;
    private AnvilView openInventory;
    private String searchForName;
    private boolean confirmed = false;
    private Function<AnvilGUI, Boolean> confirmHandler;
    private Consumer<AnvilGUI> cancelHandler;

    AnvilGUI(CubesideUtilsBukkit plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.firstItem = CustomHeads.QUARTZ_QUESTION_MARK.getHead((Component)Component.empty(), new Component[]{Component.text((String)"Suchen", (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}), Component.text((String)"Gib deine Suchanfrage ein.")});
        this.resultItem = CustomHeads.QUARTZ_ARROW_RIGHT.getHead((Component)Component.text((String)"Suche zur\u00fccksetzen!", (TextColor)NamedTextColor.GREEN));
    }

    public AnvilGUI setFirstItem(ItemStack stack) {
        ItemStack itemStack = this.firstItem = stack == null ? null : stack.clone();
        if (this.openInventory != null) {
            this.openInventory.getTopInventory().setFirstItem(this.firstItem);
        }
        return this;
    }

    public AnvilGUI setSecondItem(ItemStack stack) {
        ItemStack itemStack = this.secondItem = stack == null ? null : stack.clone();
        if (this.openInventory != null) {
            this.openInventory.getTopInventory().setSecondItem(this.secondItem);
        }
        return this;
    }

    public AnvilGUI setResultItem(ItemStack stack) {
        ItemStack itemStack = this.resultItem = stack == null ? null : stack.clone();
        if (this.openInventory != null) {
            this.openInventory.getTopInventory().setResult(this.resultItem);
        }
        return this;
    }

    AnvilView getOpenInventory() {
        return this.openInventory;
    }

    public boolean isOpen() {
        return this.openInventory != null;
    }

    public boolean open() {
        if (this.openInventory != null) {
            throw new IllegalStateException("this inventory is already open");
        }
        this.confirmed = false;
        InventoryView view = this.player.openAnvil(null, true);
        if (view == null) {
            return false;
        }
        if (!(view instanceof AnvilView)) {
            throw new RuntimeException("expected AnvilView");
        }
        AnvilView anvilView = (AnvilView)view;
        this.openInventory = anvilView;
        this.openInventory.setRepairCost(0);
        this.inventory = this.openInventory.getTopInventory();
        this.inventory.setFirstItem(this.firstItem);
        this.inventory.setSecondItem(this.secondItem);
        this.inventory.setResult(this.resultItem);
        OnlinePlayerDataImpl onlinePlayerData = this.plugin.getPlayerData(this.player);
        onlinePlayerData.setOpenAnvilGUI(this);
        return true;
    }

    public void close(boolean fromCloseEvent) {
        OnlinePlayerDataImpl onlinePlayerData = this.plugin.getPlayerData(this.player);
        if (onlinePlayerData.getOpenAnvilGUI() == this) {
            onlinePlayerData.setOpenAnvilGUI(null);
        }
        if (this.openInventory == null) {
            return;
        }
        this.openInventory.getTopInventory().clear();
        if (!fromCloseEvent && Objects.equals(this.player.getOpenInventory(), this.openInventory)) {
            this.openInventory.close();
        }
        this.openInventory = null;
        if (!this.confirmed && this.cancelHandler != null) {
            if (fromCloseEvent) {
                new BukkitRunnable(){

                    public void run() {
                        AnvilGUI.this.cancelHandler.accept(AnvilGUI.this);
                    }
                }.runTask((Plugin)this.plugin.getPlugin());
            } else {
                this.cancelHandler.accept(this);
            }
        }
    }

    public void setConfirmHandler(Function<AnvilGUI, Boolean> handler) {
        this.confirmHandler = handler;
    }

    public void setCancelHandler(Consumer<AnvilGUI> handler) {
        this.cancelHandler = handler;
    }

    public void setUpdateTextHandler(Consumer<AnvilGUI> handler) {
    }

    void onInventoryClick(int slot, ItemStack currentItem, boolean shiftClick) {
        this.openInventory.setRepairCost(0);
        if (slot == 2) {
            this.confirmed = true;
            if (this.confirmHandler == null || this.confirmHandler.apply(this) == Boolean.TRUE) {
                this.close(false);
            }
        }
    }

    void onUpdateAnvil(PrepareResultEvent event) {
        Component displayName;
        this.openInventory.setRepairCost(0);
        AnvilInventory inv = this.openInventory.getTopInventory();
        this.searchForName = null;
        if (inv.getResult() != null && inv.getResult().hasItemMeta() && (displayName = inv.getResult().getItemMeta().displayName()) != null) {
            this.searchForName = PlainTextComponentSerializer.plainText().serialize(displayName);
        }
        if (this.searchForName != null) {
            this.searchForName = this.searchForName.trim();
            if (this.searchForName.isEmpty()) {
                this.searchForName = null;
            }
        }
        if (this.searchForName == null) {
            event.setResult(CustomHeads.QUARTZ_ARROW_RIGHT.getHead((Component)Component.text((String)"Suche zur\u00fccksetzen!", (TextColor)NamedTextColor.GREEN)));
        } else {
            event.setResult(CustomHeads.QUARTZ_ARROW_RIGHT.getHead((Component)Component.text((String)("Nach '" + this.searchForName + "' suchen!"), (TextColor)NamedTextColor.GREEN)));
        }
    }

    void onInventoryClose() {
        this.close(true);
    }

    public String getInputString() {
        return this.searchForName;
    }
}

