/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin.api.events;

import de.iani.cubesideutils.Pair;
import java.util.Objects;
import java.util.TreeSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PlayerOptionsRetrievedEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private CommandSender sender;
    private OfflinePlayer player;
    private boolean cancelled;
    private TreeSet<Pair<Integer, Component>> options;

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public PlayerOptionsRetrievedEvent(CommandSender sender, OfflinePlayer playerData) {
        this.sender = Objects.requireNonNull(sender);
        this.player = Objects.requireNonNull(playerData);
        this.cancelled = false;
        this.options = new TreeSet((p1, p2) -> Integer.compare((Integer)p1.first, (Integer)p2.first));
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    public void addOptions(int priority, Component options) {
        this.options.add(new Pair<Integer, Component>(priority, options));
    }

    public Component getOptions() {
        TextComponent main = Component.empty();
        for (Pair<Integer, Component> option : this.options) {
            if (!main.children().isEmpty()) {
                main = main.append((Component)Component.space());
            }
            main = main.append((Component)option.second);
        }
        return main;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public HandlerList getHandlers() {
        return handlers;
    }
}

