/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.cubeside.connection.ConnectionAPI;
import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.plugin.PlayerData;
import de.iani.cubesideutils.plugin.UtilsPlugin;
import de.iani.cubesideutils.plugin.events.LocalAfkStateChangeEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class OnlinePlayerData
extends PlayerData {
    private long lastAction;
    private boolean locallyAfk;

    public OnlinePlayerData(UUID playerId, long firstJoin, long lastJoin, long lastSeen, boolean afk, long lastAction, String rank) {
        super(playerId, firstJoin, lastJoin, lastSeen, afk, rank);
        this.lastAction = lastAction;
    }

    public OnlinePlayerData(UUID playerId, long firstJoin, long lastJoin, long lastSeen, boolean afk, String rank) {
        this(playerId, firstJoin, lastJoin, lastSeen, afk, System.currentTimeMillis(), rank);
    }

    synchronized void quit() {
        this.setLocallyAfkInternal(true);
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.getPlayerId());
    }

    public synchronized long getLastAction() {
        return this.lastAction;
    }

    public synchronized void checkAfk() {
        if (this.isLocallyAfk()) {
            return;
        }
        if (System.currentTimeMillis() - this.lastAction < 120000L) {
            return;
        }
        if (Bukkit.isPrimaryThread()) {
            this.setLocallyAfk(true);
        } else {
            Bukkit.getScheduler().runTask((Plugin)UtilsPlugin.getInstance(), () -> this.setLocallyAfk(true));
        }
    }

    public synchronized boolean isLocallyAfk() {
        return this.locallyAfk;
    }

    public synchronized void setLocallyAfk(boolean afk) {
        if (!this.setLocallyAfkInternal(afk)) {
            return;
        }
        Bukkit.getPlayer((UUID)this.getPlayerId()).sendMessage(ChatColor.GRAY + "* Du bist nun" + (this.locallyAfk ? "" : " nicht mehr") + " abwesend.");
    }

    private synchronized boolean setLocallyAfkInternal(boolean afk) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("May only be invoked on the bukkit primary thread.");
        }
        if (this.locallyAfk == afk) {
            return false;
        }
        LocalAfkStateChangeEvent event = new LocalAfkStateChangeEvent(this, afk);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.locallyAfk = afk;
        try {
            UtilsPlugin.getInstance().getDatabase().setLocallyAfk(this.getPlayerId(), afk);
        }
        catch (SQLException e) {
            UtilsPlugin.getInstance().getLogger().log(Level.SEVERE, "Could not save AFK-status in database.", e);
        }
        this.checkGloballyAfk();
        return true;
    }

    private void checkGloballyAfk() {
        Set<String> afkServers;
        if (this.locallyAfk && this.isGloballyAfk()) {
            return;
        }
        if (!this.locallyAfk && !this.isGloballyAfk()) {
            return;
        }
        if (!this.locallyAfk) {
            this.setGloballyAfkInternal(false);
            return;
        }
        ConnectionAPI connectionApi = UtilsPlugin.getInstance().getConnectionAPI();
        List servers = connectionApi.getPlayer(this.getPlayerId()).getCurrentServers();
        assert (servers.contains(connectionApi.getThisServer()));
        if (servers.size() == 1) {
            this.setGloballyAfkInternal(true);
            return;
        }
        try {
            afkServers = UtilsPlugin.getInstance().getDatabase().getAfkServers(this.getPlayerId());
        }
        catch (SQLException e) {
            UtilsPlugin.getInstance().getLogger().log(Level.SEVERE, "Could not load AFK-status from database.", e);
            return;
        }
        for (GlobalServer server : servers) {
            if (afkServers.contains(server.getName())) continue;
            return;
        }
        this.setGloballyAfkInternal(true);
    }

    synchronized void madeAction() {
        this.lastAction = System.currentTimeMillis();
        if (this.isLocallyAfk()) {
            if (Bukkit.isPrimaryThread()) {
                this.setLocallyAfk(false);
            } else {
                Bukkit.getScheduler().runTask((Plugin)UtilsPlugin.getInstance(), () -> this.setLocallyAfk(false));
            }
        }
    }

    @Override
    void checkRank() {
        String rank = null;
        for (String possible : UtilsPlugin.getInstance().getRanks()) {
            String permission = UtilsPlugin.getInstance().getPermission(possible);
            if (permission != null && !this.getPlayer().hasPermission(permission)) continue;
            rank = possible;
            break;
        }
        this.setRank(rank);
    }
}

