/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.items;

import de.iani.cubesideutils.StringUtil;
import de.iani.cubesideutils.items.EnchantmentNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeMap;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;

public class ItemsAndStrings {
    public static final String LORE_COLOR = "" + ChatColor.ITALIC + ChatColor.DARK_PURPLE;

    public static String toNiceString(ItemStack[] items) {
        return ItemsAndStrings.toNiceString(items, "");
    }

    public static String toNiceString(ItemStack[] items, String colorPrefix) {
        TreeMap itemMap = new TreeMap((item1, item2) -> {
            if (item1.isSimilar(item2)) {
                return 0;
            }
            int result = item1.getType().compareTo((Enum)item2.getType());
            if (result != 0) {
                return result;
            }
            if (item1.getItemMeta().hasDisplayName()) {
                if (!item2.getItemMeta().hasDisplayName()) return 1;
                result = item1.getItemMeta().getDisplayName().compareTo(item2.getItemMeta().getDisplayName());
            } else if (item2.getItemMeta().hasDisplayName()) {
                return -1;
            }
            if (result == 0) return item1.getItemMeta().toString().compareTo(item2.getItemMeta().toString());
            return result;
        });
        Arrays.stream(items).filter(item -> item != null && item.getType() != Material.AIR && item.getAmount() > 0).forEach(item -> itemMap.put(item, item.getAmount() + (itemMap.containsKey(item) ? (Integer)itemMap.get(item) : 0)));
        StringBuilder builder = new StringBuilder();
        int index = 0;
        for (ItemStack item3 : itemMap.keySet()) {
            int amount = (Integer)itemMap.get(item3);
            builder.append(ItemsAndStrings.toNiceString(item3, amount, colorPrefix));
            if (index + 1 < itemMap.size()) {
                if (index + 2 < itemMap.size()) {
                    builder.append(", ");
                } else {
                    builder.append(" und ");
                }
            }
            ++index;
        }
        return builder.toString();
    }

    public static String toNiceString(ItemStack item) {
        return ItemsAndStrings.toNiceString(item, item.getAmount(), ChatColor.RESET.toString());
    }

    public static String toNiceString(ItemStack item, int amount) {
        return ItemsAndStrings.toNiceString(item, amount, ChatColor.RESET.toString());
    }

    public static String toNiceString(ItemStack item, String colorPrefix) {
        return ItemsAndStrings.toNiceString(item, item.getAmount(), colorPrefix);
    }

    public static String toNiceString(ItemStack item, int amount, String colorPrefix) {
        HashMap enchantments;
        Damageable damageableMeta;
        int index;
        LeatherArmorMeta armorMeta;
        Color color;
        StringBuilder builder = new StringBuilder(colorPrefix);
        builder.append(amount).append(" ");
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            // empty if block
        }
        if (meta instanceof LeatherArmorMeta && (color = (armorMeta = (LeatherArmorMeta)meta).getColor()).asRGB() != 10511680) {
            builder.append(StringUtil.toNiceString(color)).append(" ");
        }
        builder.append(StringUtil.capitalizeFirstLetter(item.getType().name(), true));
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            PotionData data = potionMeta.getBasePotionData();
            builder.append(" of ").append(StringUtil.capitalizeFirstLetter(data.getType().name(), true));
            builder.append(data.isUpgraded() ? " II" : " I");
            if (data.isExtended()) {
                builder.append(" (verl\u00e4ngert)");
            }
            index = 0;
            for (PotionEffect effect : potionMeta.getCustomEffects()) {
                builder.append(index + 1 < potionMeta.getCustomEffects().size() ? ", " : " and ");
                builder.append(StringUtil.capitalizeFirstLetter(effect.getType().getName(), true)).append(" ").append(StringUtil.toRomanNumber(effect.getAmplifier()));
                if (!effect.getType().isInstant()) {
                    builder.append(" (").append(StringUtil.formatTimespan(50 * effect.getDuration(), "", "", "", "", ":", ":", false, true)).append(")");
                }
                ++index;
            }
        }
        if (meta instanceof Damageable && (damageableMeta = (Damageable)meta).hasDamage()) {
            builder.append(':').append(damageableMeta.getDamage());
        }
        if (meta instanceof BookMeta) {
            BookMeta bookMeta = (BookMeta)meta;
            boolean appended = false;
            if (meta.hasDisplayName()) {
                builder.append(" (\"").append(meta.getDisplayName()).append(colorPrefix).append('\"');
                appended = true;
            } else if (bookMeta.hasTitle()) {
                builder.append(" (\"").append(bookMeta.getTitle()).append(colorPrefix).append('\"');
                appended = true;
            }
            if (appended && bookMeta.hasAuthor()) {
                builder.append(" von ").append(bookMeta.getAuthor()).append(colorPrefix);
            }
            if (appended) {
                builder.append(")");
            }
        } else if (meta != null && meta.hasDisplayName()) {
            builder.append(" (\"").append(meta.getDisplayName()).append(colorPrefix).append("\")");
        }
        HashMap hashMap = enchantments = meta == null ? Collections.emptyMap() : new HashMap(meta.getEnchants());
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchMeta = (EnchantmentStorageMeta)meta;
            enchantments.putAll(enchMeta.getStoredEnchants());
        }
        if (!enchantments.isEmpty()) {
            builder.append(", verzaubert mit ");
            ArrayList enchList = new ArrayList(enchantments.keySet());
            enchList.sort((e1, e2) -> EnchantmentNames.getName(e1).compareTo(EnchantmentNames.getName(e2)));
            index = 0;
            for (Enchantment ench : enchList) {
                builder.append(StringUtil.capitalizeFirstLetter(EnchantmentNames.getName(ench), true));
                if (ench.getMaxLevel() > 1 || (Integer)enchantments.get(ench) > 1) {
                    builder.append(" ").append(StringUtil.toRomanNumber((Integer)enchantments.get(ench)));
                }
                if (index + 1 < enchantments.size()) {
                    if (index + 2 < enchantments.size()) {
                        builder.append(", ");
                    } else {
                        builder.append(" und ");
                    }
                }
                ++index;
            }
        }
        return builder.toString();
    }

    public static String toNiceString(Material m) {
        return StringUtil.capitalizeFirstLetter(m.name(), true);
    }
}

