/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.velocity.plugin;

import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.cubeside.connection.ConnectionAPI;
import de.cubeside.connection.GlobalClientPlugin;
import de.iani.cubesideutils.plugin.CubesideUtils;
import de.iani.cubesideutils.plugin.PlayerDataImpl;
import de.iani.cubesideutils.velocity.plugin.PlayerDataCache;
import de.iani.cubesideutils.velocity.plugin.PlayerDataImplVelocity;
import de.iani.cubesideutils.velocity.plugin.UtilsDatabaseVelocity;
import de.iani.cubesideutils.velocity.plugin.UtilsGlobalDataHelperVelocity;
import de.iani.cubesideutils.velocity.plugin.UtilsPluginVelocity;
import de.iani.cubesideutils.velocity.plugin.api.UtilsApiVelocity;
import de.iani.cubesideutils.velocity.sql.SQLConfigVelocity;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class CubesideUtilsVelocity
extends CubesideUtils
implements UtilsApiVelocity {
    private static volatile CubesideUtilsVelocity instance = null;
    private UtilsPluginVelocity plugin;
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private CommentedConfigurationNode configuration;
    private UtilsDatabaseVelocity database;
    private PlayerDataCache playerDataCache;
    private GlobalClientPlugin globalClientPlugin;
    private UtilsGlobalDataHelperVelocity globalDataHelper;

    public static CubesideUtilsVelocity getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CubesideUtilsVelocity(UtilsPluginVelocity plugin, ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        Class<CubesideUtilsVelocity> clazz = CubesideUtilsVelocity.class;
        synchronized (CubesideUtilsVelocity.class) {
            if (instance != null) {
                throw new IllegalStateException("Only one instance permitted.");
            }
            instance = this;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.plugin = plugin;
            this.server = server;
            this.logger = logger;
            this.dataDirectory = dataDirectory;
            return;
        }
    }

    @Override
    protected void onEnableInternal() throws Throwable {
        try {
            Path configFile = this.dataDirectory.resolve("config.yml");
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectory(this.dataDirectory, new FileAttribute[0]);
                if (Files.notExists(configFile, new LinkOption[0])) {
                    try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("config.yml");){
                        Files.copy(stream, configFile, new CopyOption[0]);
                    }
                }
            }
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configFile)).build();
            this.configuration = (CommentedConfigurationNode)loader.load();
        }
        catch (IOException e) {
            this.logger.error("Error while loading config", (Throwable)e);
        }
        this.database = new UtilsDatabaseVelocity(new SQLConfigVelocity((CommentedConfigurationNode)this.configuration.node(new Object[]{"database"})));
        this.playerDataCache = new PlayerDataCache();
        this.globalClientPlugin = (GlobalClientPlugin)((PluginContainer)this.server.getPluginManager().getPlugin("globalconnectionvelocity").orElseThrow()).getInstance().orElseThrow();
        this.server.getScheduler().buildTask((Object)this.plugin, () -> {
            this.globalDataHelper = new UtilsGlobalDataHelperVelocity(this);
            this.updateRankInformation();
        }).delay(0L, TimeUnit.SECONDS);
    }

    @Override
    protected void shutdownServer() {
        this.server.shutdown();
    }

    public UtilsPluginVelocity getPlugin() {
        return this.plugin;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public GlobalClientPlugin getGlobalClientPlugin() {
        return this.globalClientPlugin;
    }

    @Override
    public ConnectionAPI getConnectionApi() {
        return this.globalClientPlugin.getConnectionAPI();
    }

    public UtilsDatabaseVelocity getDatabase() {
        return this.database;
    }

    @Override
    public java.util.logging.Logger getLogger() {
        return java.util.logging.Logger.getLogger("CubesideUtils");
    }

    @Override
    public File getDataFolder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMinecraftVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UtilsGlobalDataHelperVelocity getGlobalDataHelper() {
        return this.globalDataHelper;
    }

    public PlayerDataCache getPlayerDataCache() {
        return this.playerDataCache;
    }

    @Override
    public PlayerDataImplVelocity getPlayerData(Player player) {
        return this.getPlayerData(player.getUniqueId());
    }

    @Override
    public PlayerDataImplVelocity getPlayerData(UUID playerId) {
        return (PlayerDataImplVelocity)this.playerDataCache.get(playerId);
    }

    @Override
    protected Iterable<? extends PlayerDataImpl> getLoadedPlayerData() {
        return this.playerDataCache.loadedData();
    }

    @Override
    public ClassLoader getServerClassLoader() {
        return ProxyServer.class.getClassLoader();
    }
}

