/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.adventure.translations;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.iani.cubesideutils.adventure.translations.TranslationLoader;
import de.iani.cubesideutils.plugin.CubesideUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.translation.AbstractTranslationStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MojangJsonTranslationStore
extends AbstractTranslationStore<MessageFormat> {
    private static final MojangJsonTranslationStore INSTANCE = new MojangJsonTranslationStore();
    private final File langDir;
    private final ConcurrentHashMap<Locale, File> loadableLanguageFiles = new ConcurrentHashMap();
    private final Set<Locale> loadedLanguageFiles = ConcurrentHashMap.newKeySet();

    public static MojangJsonTranslationStore translationStore() {
        return INSTANCE;
    }

    private MojangJsonTranslationStore() {
        super(Key.key((String)"cubeside:mojangtranslations"));
        this.langDir = new File(CubesideUtils.getInstance().getDataFolder(), "minecraft_langs");
        TranslationLoader.checkAndDownloadLangs(this.langDir);
        File[] files = this.langDir.listFiles((dir, name) -> name.endsWith(".json") && !name.equals("langmeta.json"));
        if (files == null) {
            throw new RuntimeException("Fehler beim Lesen des Verzeichnisses");
        }
        for (File file : files) {
            String localeName = file.getName().replace(".json", "");
            Locale locale = MojangJsonTranslationStore.parseLocale(localeName);
            this.loadableLanguageFiles.put(locale, file);
        }
        CubesideUtils.getInstance().getLogger().info("Found " + this.loadableLanguageFiles.size() + " language files. ");
        this.loadLanguage(Locale.US);
    }

    private void loadLanguage(Locale locale) {
        if (this.loadedLanguageFiles.contains(locale)) {
            return;
        }
        if (!this.loadableLanguageFiles.containsKey(locale)) {
            CubesideUtils.getInstance().getLogger().warning("Language not found: " + String.valueOf(locale));
            return;
        }
        File file = this.loadableLanguageFiles.remove(locale);
        if (file != null && file.isFile()) {
            this.loadedLanguageFiles.add(locale);
            CubesideUtils.getInstance().getLogger().info("Loading locale " + String.valueOf(locale));
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                for (Map.Entry entry : json.entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                    String key = (String)entry.getKey();
                    String value = ((JsonElement)entry.getValue()).getAsString();
                    this.register(key, locale, new MessageFormat(value, locale));
                }
            }
            catch (IOException e) {
                CubesideUtils.getInstance().getLogger().log(Level.SEVERE, "Could not read language file " + file.getName(), e);
            }
        }
    }

    @Nullable
    public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
        this.loadLanguage(locale);
        return (MessageFormat)this.translationValue(key, locale);
    }

    private static Locale parseLocale(String mojangName) {
        String[] parts = mojangName.split("_");
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        return new Locale(parts[0], parts[1].toUpperCase());
    }
}

