/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.velocity;

import com.velocitypowered.api.command.CommandSource;
import de.iani.cubesideutils.ChatUtilAdventure;
import de.iani.cubesideutils.ComponentUtilAdventure;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;

public class ChatUtilVelocity {
    private ChatUtilVelocity() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static List<VelocitySendable> stringToSendableList(List<String> messages) {
        ArrayList<VelocitySendable> result = new ArrayList<VelocitySendable>(messages.size());
        for (String msg : messages) {
            result.add(new StringMsg(msg));
        }
        return result;
    }

    public static List<VelocitySendable> componentToSendableList(List<Component> messages) {
        ArrayList<VelocitySendable> result = new ArrayList<VelocitySendable>(messages.size());
        for (Component msg : messages) {
            result.add(new AdventureComponentMsg(msg));
        }
        return result;
    }

    private static List<ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver>> convertSendableList(final List<? extends VelocitySendable> messages) {
        return new AbstractList<ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver>>(){

            @Override
            public ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver> get(int index) {
                return ((VelocitySendable)messages.get(index)).toGenericSendable();
            }

            @Override
            public int size() {
                return messages.size();
            }
        };
    }

    public static void sendMessagesPaged(CommandSource recipient, List<? extends VelocitySendable> messages, int page, Component name, String openPageCommandPrefix) {
        ChatUtilVelocity.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, (Component)Component.empty());
    }

    public static void sendMessagesPaged(CommandSource recipient, List<? extends VelocitySendable> messages, int page, Component name, String openPageCommandPrefix, Component pluginPrefix) {
        ChatUtilVelocity.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, Style.style((TextColor)NamedTextColor.GREEN), Style.style((TextColor)NamedTextColor.GOLD));
    }

    public static void sendMessagesPaged(CommandSource recipient, List<? extends VelocitySendable> messages, int page, Component name, String openPageCommandPrefix, Component pluginPrefix, Style normalStyle, Style warningStyle) {
        ChatUtilAdventure.sendMessagesPaged(new CommandSourceWrapper(recipient), ChatUtilVelocity.convertSendableList(messages), page, name, openPageCommandPrefix, pluginPrefix, normalStyle, warningStyle);
    }

    public static void sendMessage(CommandSource receiver, Component pluginPrefix, Style style, Object ... messageParts) {
        ChatUtilAdventure.sendMessage(new CommandSourceWrapper(receiver), pluginPrefix, style, messageParts);
    }

    public static class StringMsg
    implements VelocitySendable {
        public final String message;

        public StringMsg(String message) {
            this.message = message;
        }

        @Override
        public void send(CommandSource recipient) {
            recipient.sendMessage((Component)ComponentUtilAdventure.getLegacyComponentSerializer().deserialize(this.message));
        }

        @Override
        public ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver> toGenericSendable() {
            return new ChatUtilAdventure.StringMsg(this.message);
        }
    }

    public static class AdventureComponentMsg
    implements VelocitySendable {
        public final Component message;

        public AdventureComponentMsg(Component message) {
            this.message = message;
        }

        @Override
        public void send(CommandSource recipient) {
            recipient.sendMessage(this.message);
        }

        @Override
        public ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver> toGenericSendable() {
            return new ChatUtilAdventure.AdventureComponentMsg(this.message);
        }
    }

    public static class CommandSourceWrapper
    implements ChatUtilAdventure.MessageReceiver {
        private final CommandSource original;

        public CommandSourceWrapper(CommandSource original) {
            this.original = original;
        }

        @Override
        public void sendMessage(String message) {
            this.original.sendMessage((Component)ComponentUtilAdventure.getLegacyComponentSerializer().deserialize(message));
        }

        @Override
        public void sendMessage(Component message) {
            this.sendMessage(message);
        }
    }

    public static interface VelocitySendable
    extends ChatUtilAdventure.Sendable<CommandSource> {
        public ChatUtilAdventure.Sendable<ChatUtilAdventure.MessageReceiver> toGenericSendable();
    }
}

