/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.items;

import de.iani.cubesideutils.plugin.CubesideUtils;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.inventory.meta.trim.TrimPattern;

public class SmithingTemplates {
    private static final Map<TrimPattern, Material> PATTERN_TEMPLATES;

    private SmithingTemplates() {
        throw new UnsupportedOperationException("No instances for you, Sir!");
    }

    public static Material getTemplateMaterial(TrimPattern pattern) {
        return PATTERN_TEMPLATES.get(pattern);
    }

    static {
        LinkedHashMap<TrimPattern, Material> patternTemplates = new LinkedHashMap<TrimPattern, Material>();
        Class<TrimPattern> patternClass = TrimPattern.class;
        for (Material mat : Material.values()) {
            if (!mat.name().endsWith("_SMITHING_TEMPLATE") || mat == Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE) continue;
            try {
                String patternName = mat.name().substring(0, mat.name().length() - "_ARMOR_TRIM_SMITHING_TEMPLATE".length());
                Field constantField = patternClass.getField(patternName);
                patternTemplates.put((TrimPattern)constantField.get(null), mat);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                CubesideUtils.getInstance().getLogger().log(Level.SEVERE, "Exception trying to map TrimPatterns to Materials, for Material " + String.valueOf(mat) + ".", e);
            }
        }
        PATTERN_TEMPLATES = Collections.unmodifiableMap(patternTemplates);
    }
}

