/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import de.iani.cubesideutils.ChatUtilAdventure;
import de.iani.cubesideutils.ComponentUtilAdventure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.chat.ComponentSerializer;

public class ChatUtil {
    private static final Map<ChatColor, Integer> CHATCOLOR_TO_RGB;

    protected ChatUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    @Deprecated
    public static Component convertBaseComponent(BaseComponent bc) {
        return GsonComponentSerializer.gson().deserialize((Object)ComponentSerializer.toString((BaseComponent)bc));
    }

    @Deprecated
    public static Component convertBaseComponents(BaseComponent ... bc) {
        return GsonComponentSerializer.gson().deserialize((Object)ComponentSerializer.toString((BaseComponent[])bc));
    }

    @Deprecated
    public static List<ChatUtilAdventure.Sendable<MessageReceiver>> bcToSendableList(List<BaseComponent[]> messages) {
        ArrayList<ChatUtilAdventure.Sendable<MessageReceiver>> result = new ArrayList<ChatUtilAdventure.Sendable<MessageReceiver>>(messages.size());
        for (BaseComponent[] msg : messages) {
            result.add(new BaseComponentMsg(msg));
        }
        return result;
    }

    @Deprecated
    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends ChatUtilAdventure.Sendable<? super T>> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, ChatColor.GREEN, ChatColor.GOLD);
    }

    @Deprecated
    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends ChatUtilAdventure.Sendable<? super T>> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix, ChatColor normalColor, ChatColor warningColor) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, new ComponentBuilder(name).create(), openPageCommandPrefix, pluginPrefix, normalColor, warningColor);
    }

    @Deprecated
    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends ChatUtilAdventure.Sendable<? super T>> messages, int page, BaseComponent[] name, String openPageCommandPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    @Deprecated
    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends ChatUtilAdventure.Sendable<? super T>> messages, int page, BaseComponent[] name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, ChatColor.GREEN, ChatColor.GOLD);
    }

    @Deprecated
    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends ChatUtilAdventure.Sendable<? super T>> messages, int page, BaseComponent[] name, String openPageCommandPrefix, String pluginPrefix, ChatColor normalColor, ChatColor warningColor) {
        ChatUtilAdventure.sendMessagesPaged(recipient, messages, page, ChatUtil.convertBaseComponents(name), openPageCommandPrefix, ChatUtilAdventure.convertLegacy(pluginPrefix), ChatUtilAdventure.convertStyle(normalColor.toString()), ChatUtilAdventure.convertStyle(warningColor.toString()));
    }

    @Deprecated
    public static void sendMessage(MessageReceiver receiver, String pluginPrefix, String colors, Object ... messageParts) {
        ChatUtil.sendMessage(receiver, ChatUtilAdventure.convertLegacy(pluginPrefix), ChatUtilAdventure.convertStyle(colors), messageParts);
    }

    public static void sendMessage(MessageReceiver receiver, Component pluginPrefix, Style style, Object ... messageParts) {
        TextComponent result = Component.empty();
        if (pluginPrefix != null) {
            result = result.append(pluginPrefix).append((Component)Component.space());
        }
        if (style != null) {
            result = result.style(style);
        }
        int outdated = 0;
        for (Object s : messageParts) {
            if (s instanceof BaseComponent[]) {
                BaseComponent[] bc = (BaseComponent[])s;
                result = result.append(ChatUtil.convertBaseComponents(bc));
                outdated |= 1;
                continue;
            }
            if (s instanceof BaseComponent) {
                BaseComponent bc = (BaseComponent)s;
                result = result.append(ChatUtil.convertBaseComponent(bc));
                outdated |= 2;
                continue;
            }
            if (s instanceof Component) {
                Component cmp = (Component)s;
                result = result.append(cmp);
                continue;
            }
            String stringObject = Objects.toString(s);
            if (stringObject.contains("\u00a7")) {
                outdated |= 4;
            }
            result = result.append((Component)ComponentUtilAdventure.getLegacyComponentSerializer().deserialize(stringObject));
        }
        if (outdated > 0) {
            // empty if block
        }
        receiver.sendMessage((Component)result);
    }

    @Deprecated
    public static Integer toRGB(ChatColor color) {
        String colorString = color.toString();
        if (colorString != null && colorString.length() > 2 && colorString.charAt(1) == 'x') {
            return Integer.parseInt(colorString.substring(2).replace(String.valueOf('\u00a7'), ""), 16);
        }
        return CHATCOLOR_TO_RGB.get(color);
    }

    static {
        HashMap<ChatColor, Integer> chatcolorToColor = new HashMap<ChatColor, Integer>();
        chatcolorToColor.put(ChatColor.BLACK, 0);
        chatcolorToColor.put(ChatColor.DARK_BLUE, 170);
        chatcolorToColor.put(ChatColor.DARK_GREEN, 43520);
        chatcolorToColor.put(ChatColor.DARK_AQUA, 43690);
        chatcolorToColor.put(ChatColor.DARK_RED, 0xAA0000);
        chatcolorToColor.put(ChatColor.DARK_PURPLE, 0xAA00AA);
        chatcolorToColor.put(ChatColor.GOLD, 0xFFAA00);
        chatcolorToColor.put(ChatColor.GRAY, 0xAAAAAA);
        chatcolorToColor.put(ChatColor.DARK_GRAY, 0x555555);
        chatcolorToColor.put(ChatColor.BLUE, 0x5555FF);
        chatcolorToColor.put(ChatColor.GREEN, 0x55FF55);
        chatcolorToColor.put(ChatColor.AQUA, 0x55FFFF);
        chatcolorToColor.put(ChatColor.RED, 0xFF5555);
        chatcolorToColor.put(ChatColor.LIGHT_PURPLE, 0xFF55FF);
        chatcolorToColor.put(ChatColor.YELLOW, 0xFFFF55);
        chatcolorToColor.put(ChatColor.WHITE, 0xFFFFFF);
        CHATCOLOR_TO_RGB = Collections.unmodifiableMap(chatcolorToColor);
    }

    @Deprecated
    public static class BaseComponentMsg
    implements ChatUtilAdventure.Sendable<MessageReceiver> {
        public final BaseComponent[] message;

        public BaseComponentMsg(BaseComponent ... message) {
            this.message = message;
        }

        public BaseComponentMsg(BaseComponent message) {
            this.message = new BaseComponent[]{message};
        }

        @Override
        public void send(MessageReceiver recipient) {
            recipient.sendMessage(this.message);
        }
    }

    public static interface MessageReceiver
    extends ChatUtilAdventure.MessageReceiver {
        @Deprecated
        default public void sendMessage(BaseComponent ... message) {
            this.sendMessage(ChatUtil.convertBaseComponents(message));
        }
    }
}

