/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.velocity.commands.exceptions;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import de.iani.cubesideutils.velocity.commands.CommandRouter;
import java.util.Objects;

public abstract class CommandRouterException
extends Exception {
    private static final long serialVersionUID = 3550234682652991485L;
    private CommandRouter router;
    private CommandSource sender;
    private Command command;
    private String alias;
    private String[] args;

    public CommandRouterException(CommandRouter router, CommandSource sender, Command command, String alias, String[] args, String message, Throwable cause) {
        super(message, cause);
        this.init(router, sender, command, alias, args);
    }

    public CommandRouterException(CommandRouter router, CommandSource sender, Command command, String alias, String[] args, String message) {
        super(message);
        this.init(router, sender, command, alias, args);
    }

    public CommandRouterException(CommandRouter router, CommandSource sender, Command command, String alias, String[] args, Throwable cause) {
        super(cause);
        this.init(router, sender, command, alias, args);
    }

    public CommandRouterException(CommandRouter router, CommandSource sender, Command command, String alias, String[] args) {
        this.init(router, sender, command, alias, args);
    }

    private void init(CommandRouter router, CommandSource sender, Command command, String alias, String[] args) {
        this.router = router;
        this.sender = Objects.requireNonNull(sender);
        this.command = Objects.requireNonNull(command);
        this.alias = Objects.requireNonNull(alias);
        this.args = (String[])args.clone();
    }

    public CommandRouter getRouter() {
        return this.router;
    }

    public CommandSource getSender() {
        return this.sender;
    }

    public Command getCommand() {
        return this.command;
    }

    public String getAlias() {
        return this.alias;
    }

    public String[] getArgs() {
        return (String[])this.args.clone();
    }
}

