/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.commands;

import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.bukkit.commands.CommandExceptionHandler;
import de.iani.cubesideutils.bukkit.commands.SubCommand;
import de.iani.cubesideutils.bukkit.commands.exceptions.DisallowsCommandBlockException;
import de.iani.cubesideutils.bukkit.commands.exceptions.IllegalSyntaxException;
import de.iani.cubesideutils.bukkit.commands.exceptions.InternalCommandException;
import de.iani.cubesideutils.bukkit.commands.exceptions.NoPermissionException;
import de.iani.cubesideutils.bukkit.commands.exceptions.NoPermissionForPathException;
import de.iani.cubesideutils.bukkit.commands.exceptions.RequiresPlayerException;
import de.iani.cubesideutils.commands.AbstractCommandRouter;
import de.iani.cubesideutils.commands.ArgsParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.util.StringUtil;

public class CommandRouter
extends AbstractCommandRouter<SubCommand, CommandSender>
implements CommandExecutor,
TabCompleter {
    public static final String UNKNOWN_COMMAND_MESSAGE = "Unknown command. Type \"/help\" for help.";
    private CommandExceptionHandler exceptionHandler;

    public CommandRouter(PluginCommand command) {
        this(command, true);
    }

    public CommandRouter(PluginCommand command, boolean caseInsensitive) {
        this(command, caseInsensitive, CommandExceptionHandler.DEFAULT_HANDLER);
    }

    public CommandRouter(PluginCommand command, CommandExceptionHandler exceptionHandler) {
        this(command, true, exceptionHandler);
    }

    public CommandRouter(PluginCommand command, boolean caseInsensitive, CommandExceptionHandler exceptionHandler) {
        super(caseInsensitive);
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
    }

    public CommandRouter() {
        this(true);
    }

    public CommandRouter(boolean caseInsensitive) {
        this(caseInsensitive, CommandExceptionHandler.DEFAULT_HANDLER);
    }

    public CommandRouter(CommandExceptionHandler exceptionHandler) {
        this(true, exceptionHandler);
    }

    public CommandRouter(boolean caseInsensitive, CommandExceptionHandler exceptionHandler) {
        super(caseInsensitive);
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
    }

    public void addPluginCommand(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    public SubCommand getSubCommand(String path) {
        String[] args = path.split(" ");
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(null, args);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        return nr == args.length ? (SubCommand)currentMap.executor : null;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(sender, args, 1);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        String partial = args.length > 0 ? args[args.length - 1] : "";
        Collection<Object> options = null;
        ArrayList optionsList = null;
        if (currentMap.executor != null) {
            options = Collections.emptyList();
            if (((SubCommand)currentMap.executor).isExecutable(sender)) {
                options = ((SubCommand)currentMap.executor).onTabComplete(sender, command, alias, new ArgsParser(args, nr));
            }
        } else {
            options = Collections.emptyList();
        }
        if (nr == args.length - 1 && currentMap.subCommands != null) {
            for (Map.Entry<String, AbstractCommandRouter.CommandMap> e : currentMap.subCommands.entrySet()) {
                AbstractCommandRouter.CommandMap subcmd;
                String key = e.getKey();
                if (!StringUtil.startsWithIgnoreCase((String)key, (String)partial) || !this.isAnySubCommandDisplayable(sender, subcmd = e.getValue()) || !(sender instanceof Player) && subcmd.executor != null && ((SubCommand)subcmd.executor).requiresPlayer()) continue;
                if (optionsList == null) {
                    optionsList = options == null ? new ArrayList() : new ArrayList(options);
                    options = optionsList;
                }
                optionsList.add(key);
            }
        }
        if (options != null) {
            optionsList = (ArrayList)StringUtil.copyPartialMatches((String)partial, options, new ArrayList());
            Collections.sort(optionsList);
        }
        return optionsList;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(sender, args);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        int nr = (Integer)commandMapAndArg.second;
        SubCommand toExecute = (SubCommand)currentMap.executor;
        if (toExecute != null) {
            try {
                if (!toExecute.allowsCommandBlock() && (sender instanceof BlockCommandSender || sender instanceof CommandMinecart)) {
                    throw new DisallowsCommandBlockException(this, sender, command, alias, toExecute, args);
                }
                if (toExecute.requiresPlayer() && !(sender instanceof Player)) {
                    throw new RequiresPlayerException(this, sender, command, alias, toExecute, args);
                }
                if (!toExecute.hasRequiredPermission(sender) || !toExecute.isAvailable(sender)) {
                    throw new NoPermissionException(this, sender, command, alias, toExecute, args, toExecute.getRequiredPermission());
                }
                if (toExecute.onCommand(sender, command, alias, this.getCommandString(alias, currentMap), new ArgsParser(args, nr))) {
                    return true;
                }
                throw new IllegalSyntaxException(this, sender, command, alias, toExecute, args);
            }
            catch (DisallowsCommandBlockException e) {
                return this.exceptionHandler.handleDisallowsCommandBlock(e);
            }
            catch (RequiresPlayerException e) {
                return this.exceptionHandler.handleRequiresPlayer(e);
            }
            catch (NoPermissionException e) {
                return this.exceptionHandler.handleNoPermission(e);
            }
            catch (IllegalSyntaxException e) {
                return this.exceptionHandler.handleIllegalSyntax(e);
            }
            catch (InternalCommandException e) {
                return this.exceptionHandler.handleInternalException(e);
            }
            catch (Throwable t) {
                return this.exceptionHandler.handleInternalException(new InternalCommandException(this, sender, command, alias, toExecute, args, t));
            }
        }
        if (!this.isAnySubCommandExecutable(sender, currentMap)) {
            return this.exceptionHandler.handleNoPermissionForPath(new NoPermissionForPathException(this, sender, command, alias, args));
        }
        this.showHelp(sender, alias, currentMap);
        return true;
    }

    private String getCommandString(String alias, AbstractCommandRouter.CommandMap currentMap) {
        StringBuilder prefixBuilder = new StringBuilder();
        prefixBuilder.append('/').append(alias).append(' ');
        ArrayList<AbstractCommandRouter.CommandMap> hierarchy = new ArrayList<AbstractCommandRouter.CommandMap>();
        AbstractCommandRouter.CommandMap map = currentMap;
        while (map != null) {
            hierarchy.add(map);
            map = map.parent;
        }
        for (int i = hierarchy.size() - 2; i >= 0; --i) {
            prefixBuilder.append(((AbstractCommandRouter.CommandMap)hierarchy.get((int)i)).name).append(' ');
        }
        return prefixBuilder.toString();
    }

    public void showHelp(CommandSender sender, String alias, String[] args) {
        Pair<AbstractCommandRouter.CommandMap, Integer> commandMapAndArg = this.matchCommandMap(sender, args);
        AbstractCommandRouter.CommandMap currentMap = (AbstractCommandRouter.CommandMap)commandMapAndArg.first;
        this.showHelp(sender, alias, currentMap);
    }

    private void showHelp(CommandSender sender, String alias, AbstractCommandRouter.CommandMap currentMap) {
        SubCommand executor;
        if (currentMap.subCommands != null) {
            String prefix = this.getCommandString(alias, currentMap);
            for (AbstractCommandRouter.CommandMap subcmd : currentMap.subcommandsOrdered) {
                String key = subcmd.name;
                if (subcmd.executor == null) {
                    if (!this.isAnySubCommandDisplayable(sender, subcmd)) continue;
                    sender.sendMessage(this.exceptionHandler.getHelpMessagePrefix() + prefix + key + " ...");
                    continue;
                }
                if (!((SubCommand)subcmd.executor).hasRequiredPermission(sender) || !((SubCommand)subcmd.executor).isAvailable(sender) || !(sender instanceof Player) && ((SubCommand)subcmd.executor).requiresPlayer()) continue;
                sender.sendMessage(this.exceptionHandler.getHelpMessagePrefix() + prefix + key + " " + ((SubCommand)subcmd.executor).getUsage(sender));
            }
        }
        if (currentMap.executor != null && (executor = (SubCommand)currentMap.executor).hasRequiredPermission(sender) && executor.isAvailable(sender)) {
            String prefix = this.getCommandString(alias, currentMap);
            if (sender instanceof Player || !executor.requiresPlayer()) {
                sender.sendMessage(this.exceptionHandler.getHelpMessagePrefix() + prefix + executor.getUsage(sender));
            }
        }
    }

    private boolean isAnySubCommandExecutable(CommandSender sender, AbstractCommandRouter.CommandMap cmd) {
        if (cmd.executor != null && ((SubCommand)cmd.executor).isExecutable(sender)) {
            return true;
        }
        if (cmd.subcommandsOrdered == null) {
            return false;
        }
        if (!this.hasAnyPermission(sender, cmd.requiredPermissions)) {
            return false;
        }
        for (AbstractCommandRouter.CommandMap subcommand : cmd.subcommandsOrdered) {
            if (!this.isAnySubCommandExecutable(sender, subcommand)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnySubCommandDisplayable(CommandSender sender, AbstractCommandRouter.CommandMap cmd) {
        if (cmd.executor != null && ((SubCommand)cmd.executor).isDisplayable(sender)) {
            return true;
        }
        if (cmd.subcommandsOrdered == null) {
            return false;
        }
        if (!this.hasAnyPermission(sender, cmd.requiredPermissions)) {
            return false;
        }
        for (AbstractCommandRouter.CommandMap subcommand : cmd.subcommandsOrdered) {
            if (!this.isAnySubCommandDisplayable(sender, subcommand)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyPermission(CommandSender handler, Set<String> permissions) {
        if (permissions == null) {
            return true;
        }
        for (String permission : permissions) {
            if (!handler.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }
}

