/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.nbt;

import de.iani.cubesideutils.nbt.BaseTag;
import de.iani.cubesideutils.nbt.ByteArrayTag;
import de.iani.cubesideutils.nbt.ByteTag;
import de.iani.cubesideutils.nbt.DoubleTag;
import de.iani.cubesideutils.nbt.FloatTag;
import de.iani.cubesideutils.nbt.IntArrayTag;
import de.iani.cubesideutils.nbt.IntTag;
import de.iani.cubesideutils.nbt.ListTag;
import de.iani.cubesideutils.nbt.LongArrayTag;
import de.iani.cubesideutils.nbt.LongTag;
import de.iani.cubesideutils.nbt.ShortTag;
import de.iani.cubesideutils.nbt.StringTag;
import de.iani.cubesideutils.nbt.TagType;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompoundTag
extends LinkedHashMap<String, BaseTag<?>>
implements BaseTag<CompoundTag> {
    private static final long serialVersionUID = -2661932464220266252L;

    @Override
    public TagType getType() {
        return TagType.COMPOUND;
    }

    public BaseTag<?> putByte(String name, byte value) {
        return this.put(name, new ByteTag(value));
    }

    public BaseTag<?> putShort(String name, short value) {
        return this.put(name, new ShortTag(value));
    }

    public BaseTag<?> putInt(String name, int value) {
        return this.put(name, new IntTag(value));
    }

    public BaseTag<?> putLong(String name, long value) {
        return this.put(name, new LongTag(value));
    }

    public BaseTag<?> putFloat(String name, float value) {
        return this.put(name, new FloatTag(value));
    }

    public BaseTag<?> putDouble(String name, double value) {
        return this.put(name, new DoubleTag(value));
    }

    public BaseTag<?> putString(String name, String value) {
        return this.put(name, new StringTag(value));
    }

    public BaseTag<?> putByteArray(String name, byte[] value) {
        return this.put(name, new ByteArrayTag(value));
    }

    public BaseTag<?> putIntArray(String name, int[] value) {
        return this.put(name, new IntArrayTag(value));
    }

    public BaseTag<?> putLongArray(String name, long[] value) {
        return this.put(name, new LongArrayTag(value));
    }

    public BaseTag<?> putCompound(String name, CompoundTag value) {
        return this.put(name, value);
    }

    public BaseTag<?> putBoolean(String string, boolean val) {
        return this.putByte(string, val ? (byte)1 : 0);
    }

    public byte getByte(String name, byte defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return ((ByteTag)this.get(name)).getData();
    }

    public short getShort(String name, short defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return ((ShortTag)this.get(name)).getData();
    }

    public int getInt(String name, int defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return ((IntTag)this.get(name)).getData();
    }

    public long getLong(String name, long defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return ((LongTag)this.get(name)).getData();
    }

    public float getFloat(String name, float defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return ((FloatTag)this.get(name)).getData();
    }

    public double getDouble(String name, double defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return ((DoubleTag)this.get(name)).getData();
    }

    public String getString(String name, String defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return ((StringTag)this.get(name)).getData();
    }

    public byte[] getByteArray(String name, byte[] defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return ((ByteArrayTag)this.get(name)).getData();
    }

    public int[] getIntArray(String name, int[] defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return ((IntArrayTag)this.get(name)).getData();
    }

    public long[] getLongArray(String name, long[] defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return ((LongArrayTag)this.get(name)).getData();
    }

    public CompoundTag getCompound(String name, CompoundTag defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return (CompoundTag)this.get(name);
    }

    public ListTag<? extends BaseTag<?>> getList(String name, ListTag<? extends BaseTag<?>> defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return (ListTag)this.get(name);
    }

    public boolean getBoolean(String string, boolean defaultValue) {
        return this.getByte(string, defaultValue ? (byte)1 : 0) != 0;
    }

    @Override
    public String toString() {
        return this.size() + " entries";
    }

    @Override
    public void print(String name, String prefix, PrintStream out) {
        BaseTag.super.print(name, (String)prefix, out);
        out.println((String)prefix + "{");
        String orgPrefix = prefix;
        prefix = (String)prefix + "   ";
        for (Map.Entry e : this.entrySet()) {
            ((BaseTag)e.getValue()).print((String)e.getKey(), (String)prefix, out);
        }
        out.println(orgPrefix + "}");
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CompoundTag && super.equals(obj);
    }

    @Override
    public CompoundTag clone() {
        CompoundTag clone = new CompoundTag();
        for (Map.Entry e : this.entrySet()) {
            clone.put((String)e.getKey(), ((BaseTag)e.getValue()).clone());
        }
        return clone;
    }
}

