/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.security.SecureRandom;
import java.util.List;
import java.util.Random;

public class RandomUtil {
    public static final Random SHARED_RANDOM = new Random();
    public static final Random SHARED_SECURE_RANDOM = new SecureRandom();

    private RandomUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static double pseudoGaussian(double bound, Random ran) {
        double result;
        if (bound <= 0.0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        while ((result = ran.nextGaussian()) <= -bound || result >= bound) {
        }
        return result;
    }

    public static double pseudoGaussian(double bound) {
        return RandomUtil.pseudoGaussian(bound, SHARED_RANDOM);
    }

    public static <T> T randomElement(List<T> list, Random ran) {
        return list.get(ran.nextInt(list.size()));
    }

    public static <T> T randomElement(List<T> list) {
        return RandomUtil.randomElement(list, SHARED_RANDOM);
    }

    public static int randomInt(int bound) {
        return SHARED_RANDOM.nextInt(bound);
    }

    @Deprecated
    public static String generateRandomPassword(int chars) {
        char[] charArray = new char[chars];
        for (int i = 0; i < chars; ++i) {
            int v = SHARED_SECURE_RANDOM.nextInt(36);
            charArray[i] = v < 10 ? (char)(48 + v) : (char)(97 + (v - 10));
        }
        return new String(charArray);
    }

    public static String generateRandomAlphaNumericalString(int chars) {
        char[] charArray = new char[chars];
        for (int i = 0; i < chars; ++i) {
            int v = SHARED_SECURE_RANDOM.nextInt(62);
            charArray[i] = v < 10 ? (char)(48 + v) : (v - 10 < 26 ? (char)(97 + (v - 10)) : (char)(65 + (v - 10 - 26)));
        }
        return new String(charArray);
    }
}

