/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.RandomUtil;
import de.iani.cubesideutils.plugin.CubesideUtils;
import de.iani.cubesideutils.plugin.GlobalDataHelperBaseImpl;
import de.iani.cubesideutils.plugin.OtpHandler;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class OtpHandlerImpl
implements OtpHandler {
    public static final int ITERATION_COUNT = 10000;
    public static final int HASH_LENGTH = 64;
    private static final SecretKeyFactory FACTORY;
    private String key;
    private Map<UUID, byte[]> currentOtps;

    public OtpHandlerImpl(String key) {
        if (key.length() > 64 || key.isEmpty()) {
            throw new IllegalArgumentException("key may neither be empty nor longer than 64");
        }
        this.key = key;
        this.currentOtps = new ConcurrentHashMap<UUID, byte[]>();
        CubesideUtils.getInstance().getGlobalDataHelper().registerHandler(UtilsGlobalDataHelper.MessageType.OTP_CHANGED, this::handleMessage);
    }

    private void handleMessage(GlobalServer source, DataInputStream data) {
        try {
            String messageKey = data.readUTF();
            if (!this.key.equals(messageKey)) {
                return;
            }
            boolean created = data.readBoolean();
            UUID holderId = GlobalDataHelperBaseImpl.readUUID(data);
            if (created) {
                this.currentOtps.put(holderId, data.readAllBytes());
            } else {
                this.currentOtps.remove(holderId);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean testAndReset(UUID holderId, String password) {
        byte[] otp = this.currentOtps.get(holderId);
        if (otp == null) {
            return false;
        }
        if (Arrays.equals(otp, this.hash(password))) {
            CubesideUtils.getInstance().getGlobalDataHelper().sendData(false, UtilsGlobalDataHelper.MessageType.OTP_CHANGED, (Object)this.key, (Object)false, (Object)holderId);
            this.currentOtps.remove(holderId);
            return true;
        }
        return false;
    }

    @Override
    public String generate(UUID holderId, int length) {
        String result = RandomUtil.generateRandomAlphaNumericalString(length);
        byte[] otp = this.hash(result);
        this.currentOtps.put(holderId, otp);
        CubesideUtils.getInstance().getGlobalDataHelper().sendData(false, UtilsGlobalDataHelper.MessageType.OTP_CHANGED, (Object)this.key, (Object)true, (Object)holderId, (Object[])otp);
        return result;
    }

    private byte[] hash(String password) {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), new byte[]{0}, 10000, 512);
        try {
            return FACTORY.generateSecret(spec).getEncoded();
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            FACTORY = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

