/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bungee.plugin.api;

import de.iani.cubesideutils.bungee.plugin.CubesideUtilsBungee;
import de.iani.cubesideutils.collections.AdvancedCacheMap;
import de.iani.cubesideutils.plugin.CubesideUtils;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public abstract class PlayerCacheMap<V, D>
extends AdvancedCacheMap<UUID, V, D>
implements Listener {
    public static final long BETWEEN_LOGIN_AND_JOIN_TIMEOUT = 6000L;
    private static final long serialVersionUID = 9162727527421482928L;
    private String valueLoggingName;

    protected PlayerCacheMap(int maxSoftCacheSize, D defaultData, String valueLoggingName) {
        super(maxSoftCacheSize, defaultData);
        this.valueLoggingName = Objects.requireNonNull(valueLoggingName);
        ProxyServer.getInstance().getPluginManager().registerListener((Plugin)CubesideUtilsBungee.getInstance().getPlugin(), (Listener)this);
    }

    @EventHandler(priority=-64)
    public void earlyOnLoginEvent(LoginEvent event) {
        V value;
        if (event.isCancelled()) {
            return;
        }
        UUID playerId = event.getConnection().getUniqueId();
        if (playerId == null) {
            event.setCancelled(true);
            event.setCancelReason(new ComponentBuilder("Account-ID unbekannt.\nAccount-ID unknown.").create());
            return;
        }
        this.playerStartsLoggingIn(playerId);
        try {
            value = this.loadOnLogin(playerId);
        }
        catch (LoadingPlayerDataFailedException e) {
            CubesideUtils.getInstance().getLogger().log(Level.SEVERE, "Could not load " + this.valueLoggingName + " for player " + String.valueOf(playerId) + ".", e);
            CubesideUtils.getInstance().getLogger().log(Level.SEVERE, "Denying join for player " + String.valueOf(playerId) + " because of an internal error.");
            event.setCancelled(true);
            event.setCancelReason(new BaseComponent[]{new TextComponent(e.getKickMessage())});
            return;
        }
        if (value != null) {
            this.addToHardCache(playerId, value);
        }
        this.playerDataLoadedOnLogin(playerId, value);
    }

    @EventHandler(priority=64)
    public void lateOnLoginEvent(LoginEvent event) {
        UUID playerId = event.getConnection().getUniqueId();
        this.playerFinishsLoggingIn(playerId);
        if (event.isCancelled()) {
            Object value = this.removeFromHardCache(playerId);
            this.playerDataUnloadedOnSuccesslessLogin(playerId, value);
            return;
        }
    }

    @EventHandler(priority=-64)
    public void lateOnPlayerQuitEvent(PlayerDisconnectEvent event) {
        ProxiedPlayer player = event.getPlayer();
        this.playerQuitting(player);
        UUID playerId = player.getUniqueId();
        Object value = this.removeFromHardCache(playerId);
        this.playerDataUnloadedOnQuit(player, value);
    }

    protected boolean checkKey(Object key) {
        return key instanceof UUID;
    }

    protected void playerStartsLoggingIn(UUID playerId) {
    }

    protected abstract V loadOnLogin(UUID var1) throws LoadingPlayerDataFailedException;

    protected void playerDataLoadedOnLogin(UUID playerId, V value) {
    }

    protected void playerFinishsLoggingIn(UUID playerId) {
    }

    protected void playerDataUnloadedOnSuccesslessLogin(UUID playerId, V value) {
    }

    protected void playerQuitting(ProxiedPlayer player) {
    }

    protected void playerDataUnloadedOnQuit(ProxiedPlayer player, V value) {
    }

    public static class LoadingPlayerDataFailedException
    extends Exception {
        private static final long serialVersionUID = 4824440510991755719L;
        private String kickMessage;

        public LoadingPlayerDataFailedException(String kickMessage) {
            this.kickMessage = Objects.requireNonNull(kickMessage);
        }

        public LoadingPlayerDataFailedException(String kickMessage, String message, Throwable cause) {
            super(message, cause);
            this.kickMessage = Objects.requireNonNull(kickMessage);
        }

        public LoadingPlayerDataFailedException(String kickMessage, String message) {
            super(message);
            this.kickMessage = Objects.requireNonNull(kickMessage);
        }

        public LoadingPlayerDataFailedException(String kickMessage, Throwable cause) {
            super(cause);
            this.kickMessage = Objects.requireNonNull(kickMessage);
        }

        public String getKickMessage() {
            return this.kickMessage;
        }
    }
}

