/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import de.cubeside.connection.GlobalServer;
import de.iani.cubesideutils.bukkit.ChatUtilBukkit;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.plugin.PlayerDataImplBukkit;
import de.iani.cubesideutils.bukkit.plugin.UtilsPluginBukkit;
import de.iani.cubesideutils.bukkit.plugin.api.GlobalDataHelperBukkit;
import de.iani.cubesideutils.bukkit.sound.SoundSequence;
import de.iani.cubesideutils.conditions.Condition;
import de.iani.cubesideutils.plugin.UtilsGlobalDataHelper;
import java.io.DataInputStream;
import java.io.IOException;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UtilsGlobalDataHelperBukkit
extends GlobalDataHelperBukkit<UtilsGlobalDataHelper.MessageType>
implements UtilsGlobalDataHelper {
    public UtilsGlobalDataHelperBukkit(UtilsPluginBukkit plugin) {
        super(UtilsGlobalDataHelper.MessageType.class, "UtilsPlugin", plugin);
    }

    protected void handleMessage(UtilsGlobalDataHelper.MessageType messageType, GlobalServer source, DataInputStream data) throws IOException {
        switch (messageType) {
            case RANK_INFORMATION_CHANGED: {
                CubesideUtilsBukkit.getInstance().updateRankInformation();
                break;
            }
            case GENERAL_DATA_CHANGED: {
                CubesideUtilsBukkit.getInstance().getGeneralDataCache().invalidate(data.readUTF());
                break;
            }
            case PLAYER_DATA_CHANGED: {
                CubesideUtilsBukkit.getInstance().getPlayerDataCache().invalidate(this.readUUID(data));
                break;
            }
            case CUSTOM_PLAYER_DATA_CHANGED: {
                PlayerDataImplBukkit pData = CubesideUtilsBukkit.getInstance().getPlayerDataCache().get(this.readUUID(data), false, false);
                if (pData == null) break;
                pData.customDataChanged();
                break;
            }
            case SEND_MESSAGE: {
                Condition seeMsgCondition = (Condition)this.readStringSerializable(data);
                boolean componentMsg = data.readBoolean();
                if (componentMsg) {
                    Component message = this.readAdventureComponent(data);
                    ChatUtilBukkit.sendMessageToPlayers((Condition<? super Player>)seeMsgCondition, message);
                    break;
                }
                String message = data.readUTF();
                ChatUtilBukkit.sendMessageToPlayers((Condition<? super Player>)seeMsgCondition, message);
                break;
            }
            case SOUND_SEQUENCE: {
                Condition hearSoundCondition = (Condition)this.readStringSerializable(data);
                SoundSequence sequence = (SoundSequence)this.readStringSerializable(data);
                sequence.playToAll((Condition<? super Player>)hearSoundCondition, (Plugin)this.plugin);
                break;
            }
        }
    }
}

