/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.inventory;

import de.iani.cubesideutils.bukkit.inventory.Window;
import de.iani.cubesideutils.bukkit.inventory.WindowManager;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;

public abstract class AbstractWindow
implements Window {
    private final Player player;
    private final Inventory inventory;
    private Window parentWindow;

    public AbstractWindow(Player player, Inventory inventory) {
        this.player = player;
        this.inventory = inventory;
    }

    public AbstractWindow(Window parentWindow, Inventory inventory) {
        this(parentWindow.getPlayer(), inventory);
        this.parentWindow = parentWindow;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public Window getParent() {
        return this.parentWindow;
    }

    @Override
    public void onItemClicked(InventoryClickEvent event) {
        if (this.mayAffectThisInventory(event)) {
            event.setCancelled(true);
        }
    }

    protected boolean mayAffectThisInventory(InventoryClickEvent event) {
        if (this.getInventory().equals((Object)event.getClickedInventory())) {
            return event.getAction() != InventoryAction.NOTHING;
        }
        return switch (event.getAction()) {
            case InventoryAction.COLLECT_TO_CURSOR, InventoryAction.MOVE_TO_OTHER_INVENTORY, InventoryAction.UNKNOWN -> true;
            default -> false;
        };
    }

    @Override
    public void onItemDraged(InventoryDragEvent event) {
        if (this.mayAffectThisInventory(event)) {
            event.setCancelled(true);
        }
    }

    protected boolean mayAffectThisInventory(InventoryDragEvent event) {
        for (Integer slot : event.getRawSlots()) {
            if (slot >= this.getInventory().getSize()) continue;
            return true;
        }
        return false;
    }

    protected boolean mayAffectThisInventory(InventoryCloseEvent event) {
        return this.getInventory().equals((Object)event.getInventory());
    }

    @Override
    public void open() {
        this.rebuildInventory();
        this.getPlayer().openInventory(this.getInventory());
        WindowManager.getInstance().registerOpenWindow(this);
    }

    protected abstract void rebuildInventory();
}

