/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.inventory;

import de.iani.cubesideutils.bukkit.inventory.Window;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.plugin.Plugin;

public class WindowManager
implements Listener {
    private static final WindowManager INSTANCE = new WindowManager();
    private final Map<UUID, Window> openWindows;
    private final CubesideUtilsBukkit core = CubesideUtilsBukkit.getInstance();

    public WindowManager() {
        this.openWindows = new HashMap<UUID, Window>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.core.getPlugin());
    }

    public void registerOpenWindow(Window window) {
        Window alreadyOpen = this.openWindows.put(window.getPlayer().getUniqueId(), window);
        if (alreadyOpen != null) {
            this.core.getPlugin().getLogger().log(Level.WARNING, "Window opened without the last one being closed.");
        }
    }

    @EventHandler
    public void onInventoryClickEvent(InventoryClickEvent event) {
        Window window = this.openWindows.get(event.getWhoClicked().getUniqueId());
        if (window == null) {
            return;
        }
        try {
            window.onItemClicked(event);
        }
        catch (Exception e) {
            event.setCancelled(true);
            throw e;
        }
    }

    @EventHandler
    public void onInventoryDragEvent(InventoryDragEvent event) {
        Window window = this.openWindows.get(event.getWhoClicked().getUniqueId());
        if (window == null) {
            return;
        }
        try {
            window.onItemDraged(event);
        }
        catch (Exception e) {
            event.setCancelled(true);
            throw e;
        }
    }

    @EventHandler
    public void onInventoryClosedEvent(InventoryCloseEvent event) {
        Window window = this.openWindows.get(event.getPlayer().getUniqueId());
        if (window == null) {
            return;
        }
        window.closed();
        this.openWindows.remove(event.getPlayer().getUniqueId());
    }

    public static WindowManager getInstance() {
        return INSTANCE;
    }
}

