/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import de.cubeside.connection.GlobalPlayer;
import de.iani.cubesideutils.ChatUtil;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.plugin.api.UtilsApiBukkit;
import de.iani.cubesideutils.conditions.Condition;
import de.iani.cubesideutils.plugin.CubesideUtils;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatUtilBukkit
extends ChatUtil {
    private ChatUtilBukkit() {
    }

    public static List<BukkitSendable> stringToBukkitSendableList(List<String> messages) {
        ArrayList<BukkitSendable> result = new ArrayList<BukkitSendable>(messages.size());
        for (String msg : messages) {
            result.add(new StringMsg(msg));
        }
        return result;
    }

    public static List<BukkitSendable> bcToBukkitSendableList(List<BaseComponent[]> messages) {
        ArrayList<BukkitSendable> result = new ArrayList<BukkitSendable>(messages.size());
        for (BaseComponent[] msg : messages) {
            result.add(new ComponentMsg(msg));
        }
        return result;
    }

    private static List<ChatUtil.Sendable<ChatUtil.MessageReceiver>> convertSendableList(final List<? extends BukkitSendable> messages) {
        return new AbstractList<ChatUtil.Sendable<ChatUtil.MessageReceiver>>(){

            @Override
            public ChatUtil.Sendable<ChatUtil.MessageReceiver> get(int index) {
                return ((BukkitSendable)messages.get(index)).toGenericSendable();
            }

            @Override
            public int size() {
                return messages.size();
            }
        };
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, String name, String openPageCommandPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, net.md_5.bungee.api.ChatColor.GREEN, net.md_5.bungee.api.ChatColor.GOLD);
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix, net.md_5.bungee.api.ChatColor normalColor, net.md_5.bungee.api.ChatColor warningColor) {
        ChatUtil.sendMessagesPaged((ChatUtil.MessageReceiver)new CommandSenderWrapper(recipient), ChatUtilBukkit.convertSendableList(messages), (int)page, (String)name, (String)openPageCommandPrefix, (String)pluginPrefix, (net.md_5.bungee.api.ChatColor)normalColor, (net.md_5.bungee.api.ChatColor)warningColor);
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent name, String openPageCommandPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, net.md_5.bungee.api.ChatColor.GREEN, net.md_5.bungee.api.ChatColor.GOLD);
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent name, String openPageCommandPrefix, String pluginPrefix, net.md_5.bungee.api.ChatColor normalColor, net.md_5.bungee.api.ChatColor warningColor) {
        ChatUtil.sendMessagesPaged((ChatUtil.MessageReceiver)new CommandSenderWrapper(recipient), ChatUtilBukkit.convertSendableList(messages), (int)page, (BaseComponent[])new BaseComponent[]{name}, (String)openPageCommandPrefix, (String)pluginPrefix, (net.md_5.bungee.api.ChatColor)normalColor, (net.md_5.bungee.api.ChatColor)warningColor);
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent[] name, String openPageCommandPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent[] name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtilBukkit.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, net.md_5.bungee.api.ChatColor.GREEN, net.md_5.bungee.api.ChatColor.GOLD);
    }

    public static void sendMessagesPaged(CommandSender recipient, List<? extends BukkitSendable> messages, int page, BaseComponent[] name, String openPageCommandPrefix, String pluginPrefix, net.md_5.bungee.api.ChatColor normalColor, net.md_5.bungee.api.ChatColor warningColor) {
        ChatUtil.sendMessagesPaged((ChatUtil.MessageReceiver)new CommandSenderWrapper(recipient), ChatUtilBukkit.convertSendableList(messages), (int)page, (BaseComponent[])name, (String)openPageCommandPrefix, (String)pluginPrefix, (net.md_5.bungee.api.ChatColor)normalColor, (net.md_5.bungee.api.ChatColor)warningColor);
    }

    public static void sendMessageToPlayers(Condition<? super Player> seeMsgCondition, String message) {
        ChatUtilBukkit.sendMessageToPlayers(seeMsgCondition, new StringMsg(message));
    }

    public static void sendMessageToPlayers(Condition<? super Player> seeMsgCondition, BaseComponent ... message) {
        ChatUtilBukkit.sendMessageToPlayers(seeMsgCondition, new ComponentMsg(message));
    }

    public static void sendMessageToPlayers(Condition<? super Player> seeMsgCondition, BukkitSendable message) {
        message.send(Bukkit.getConsoleSender());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (seeMsgCondition != null && !seeMsgCondition.test((Object)player)) continue;
            message.send(player);
        }
    }

    public static void sendMessage(CommandSender receiver, String pluginPrefix, String colors, Object ... messageParts) {
        ChatUtil.sendMessage((ChatUtil.MessageReceiver)new CommandSenderWrapper(receiver), (String)pluginPrefix, (String)colors, (Object[])messageParts);
    }

    public static void sendMessage(UUID playerId, String pluginPrefix, String colors, Object ... messageParts) {
        ChatUtil.sendMessage((ChatUtil.MessageReceiver)new GlobalPlayerWrapper(playerId), (String)pluginPrefix, (String)colors, (Object[])messageParts);
    }

    public static Integer toRGB(ChatColor color) {
        return ChatUtil.toRGB((net.md_5.bungee.api.ChatColor)color.asBungee());
    }

    public static class StringMsg
    implements BukkitSendable {
        public final String message;

        public StringMsg(String message) {
            this.message = message;
        }

        public void send(CommandSender recipient) {
            new CommandSenderWrapper(recipient).sendMessage(this.message);
        }

        @Override
        public ChatUtil.Sendable<ChatUtil.MessageReceiver> toGenericSendable() {
            return new ChatUtil.StringMsg(this.message);
        }
    }

    public static class ComponentMsg
    implements BukkitSendable {
        public final BaseComponent[] message;

        public ComponentMsg(BaseComponent[] message) {
            this.message = message;
        }

        public ComponentMsg(BaseComponent message) {
            this.message = new BaseComponent[]{message};
        }

        public void send(CommandSender recipient) {
            new CommandSenderWrapper(recipient).sendMessage(this.message);
        }

        @Override
        public ChatUtil.Sendable<ChatUtil.MessageReceiver> toGenericSendable() {
            return new ChatUtil.ComponentMsg(this.message);
        }
    }

    public static class CommandSenderWrapper
    implements ChatUtil.MessageReceiver {
        private final CommandSender original;

        public CommandSenderWrapper(CommandSender original) {
            this.original = original;
        }

        public void sendMessage(String message) {
            CommandSender commandSender = this.original;
            if (commandSender instanceof Player) {
                Player player = (Player)commandSender;
                UtilsApiBukkit.getInstance().doAfterReconfigurationPhase(player, p -> p.sendMessage(message));
            } else {
                this.original.sendMessage(message);
            }
        }

        public void sendMessage(BaseComponent ... message) {
            CommandSender commandSender = this.original;
            if (commandSender instanceof Player) {
                Player player = (Player)commandSender;
                UtilsApiBukkit.getInstance().doAfterReconfigurationPhase(player, p -> {
                    try {
                        player.sendMessage(message);
                    }
                    catch (NoSuchMethodError e) {
                        player.spigot().sendMessage(message);
                    }
                });
            } else {
                try {
                    this.original.sendMessage(message);
                }
                catch (NoSuchMethodError e) {
                    this.original.sendMessage(BaseComponent.toLegacyText((BaseComponent[])message));
                }
            }
        }
    }

    public static interface BukkitSendable
    extends ChatUtil.Sendable<CommandSender> {
        public ChatUtil.Sendable<ChatUtil.MessageReceiver> toGenericSendable();
    }

    public static class GlobalPlayerWrapper
    implements ChatUtil.MessageReceiver {
        private GlobalPlayer gPlayer;

        public GlobalPlayerWrapper(GlobalPlayer gPlayer) {
            this.gPlayer = Objects.requireNonNull(gPlayer);
        }

        public GlobalPlayerWrapper(UUID playerId) {
            this.gPlayer = CubesideUtils.getInstance().getGlobalDataHelper().getPlayer(playerId);
            if (this.gPlayer == null) {
                throw new IllegalArgumentException("player not found");
            }
        }

        public void sendMessage(String message) {
            CubesideUtilsBukkit.getInstance().getGlobalDataHelper().sendMessage(this.gPlayer, message);
        }

        public void sendMessage(BaseComponent ... message) {
            CubesideUtilsBukkit.getInstance().getGlobalDataHelper().sendMessage(this.gPlayer, message);
        }
    }
}

