/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class MinecraftDataInputStream
extends DataInputStream {
    public MinecraftDataInputStream(InputStream in) {
        super(in);
    }

    public String readString() throws IOException {
        int bytes = this.readVarInt();
        byte[] stringBytes = new byte[bytes];
        this.readFully(stringBytes);
        return new String(stringBytes, StandardCharsets.UTF_8);
    }

    public int readVarInt() throws IOException {
        byte b;
        int i = 0;
        int byteId = 0;
        do {
            b = this.readByte();
            i |= (b & 0x7F) << byteId++ * 7;
            if (byteId <= 5) continue;
            throw new RuntimeException("VarInt encoding error");
        } while ((b & 0x80) != 128);
        return i;
    }

    public long readVarLong() throws IOException {
        byte b;
        long i = 0L;
        int byteId = 0;
        do {
            b = this.readByte();
            i |= (long)(b & 0x7F) << byteId++ * 7;
            if (byteId <= 10) continue;
            throw new RuntimeException("VarLong encoding error");
        } while ((b & 0x80) != 128);
        return i;
    }

    public UUID readUuid() throws IOException {
        long msb = this.readLong();
        long lsb = this.readLong();
        return new UUID(msb, lsb);
    }

    public BaseComponent[] readText() throws IOException {
        return ComponentSerializer.parse((String)this.readString());
    }
}

