/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit.plugin;

import de.iani.cubesideutils.Pair;
import de.iani.cubesideutils.bukkit.plugin.CubesideUtilsBukkit;
import de.iani.cubesideutils.bukkit.plugin.OnlinePlayerDataImpl;
import de.iani.cubesideutils.bukkit.plugin.PlayerDataImplBukkit;
import de.iani.cubesideutils.bukkit.plugin.api.PlayerCacheMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class PlayerDataCache
extends PlayerCacheMap<PlayerDataImplBukkit, Pair<Boolean, Boolean>>
implements Listener {
    private static final long serialVersionUID = -8879364238741140063L;
    private static final int MAX_SOFT_CACHE_SIZE = 16;
    private Player currentlyLoggingInPlayer;

    public PlayerDataCache() {
        super(16, new Pair<Boolean, Boolean>(true, false), "PlayerData");
    }

    public Player getCurrentlyLoggingInPlayer() {
        return this.currentlyLoggingInPlayer;
    }

    public OnlinePlayerDataImpl getOnline(UUID key) {
        return (OnlinePlayerDataImpl)this.getFromHardCache(key);
    }

    public Collection<PlayerDataImplBukkit> loadedData() {
        return Collections.unmodifiableCollection(new ArrayList(this.values()));
    }

    public PlayerDataImplBukkit get(Object key, boolean queryDatabase, boolean createIfMissing) {
        return (PlayerDataImplBukkit)this.get(key, new Pair<Boolean, Boolean>(queryDatabase, createIfMissing));
    }

    @Override
    protected void checkData(Pair<Boolean, Boolean> data) {
        if (data == null || data.first == null || data.second == null) {
            throw new NullPointerException();
        }
        if (!((Boolean)data.first).booleanValue() && ((Boolean)data.second).booleanValue()) {
            throw new IllegalArgumentException("can only createIfMissing if queryDatabase");
        }
    }

    @Override
    protected boolean shouldLoadIntoCache(UUID key, Pair<Boolean, Boolean> data) {
        return (Boolean)data.first;
    }

    @Override
    protected PlayerDataImplBukkit load(UUID key, Pair<Boolean, Boolean> data) {
        try {
            return (PlayerDataImplBukkit)CubesideUtilsBukkit.getInstance().getDatabase().getPlayerData(key, (Boolean)data.second);
        }
        catch (SQLException e) {
            CubesideUtilsBukkit.getInstance().getLogger().log(Level.SEVERE, "Exception trying to query database for PlayerData.", e);
            return null;
        }
    }

    @Override
    public void invalidate(UUID key) {
        super.invalidate(key);
    }

    @Override
    protected PlayerDataImplBukkit getReplacement(UUID key, PlayerDataImplBukkit uncached) {
        OnlinePlayerDataImpl online = (OnlinePlayerDataImpl)uncached;
        long lastAction = online.getOnlineData().getLastAction();
        boolean manuallySetAfk = online.getOnlineData().isManuallySetAfk();
        try {
            return CubesideUtilsBukkit.getInstance().getDatabase().getOnlinePlayerData(key, true, lastAction, manuallySetAfk);
        }
        catch (SQLException e) {
            CubesideUtilsBukkit.getInstance().getLogger().log(Level.SEVERE, "Exception trying to load OnlinePlayerData for " + key + " from database.");
            return null;
        }
    }

    @Override
    protected void replaced(UUID key, PlayerDataImplBukkit uncached, PlayerDataImplBukkit replacement) {
        if (replacement != null) {
            ((OnlinePlayerDataImpl)replacement).checkAfk(false);
        }
    }

    @Override
    protected void playerStartsLoggingIn(Player player) {
        this.currentlyLoggingInPlayer = player;
    }

    @Override
    protected PlayerDataImplBukkit loadOnLogin(Player player) throws PlayerCacheMap.LoadingPlayerDataFailedException {
        try {
            return CubesideUtilsBukkit.getInstance().getDatabase().getOnlinePlayerData(player.getUniqueId(), true, System.currentTimeMillis(), false);
        }
        catch (SQLException e) {
            CubesideUtilsBukkit.getInstance().getLogger().log(Level.SEVERE, "Exception trying to load OnlinePlayerData for " + player.getUniqueId() + " from database.");
            return null;
        }
    }

    @Override
    protected void playerDataLoadedOnLogin(Player player, PlayerDataImplBukkit value) {
        ((OnlinePlayerDataImpl)value).setLocallyAfk(false, false);
    }

    @Override
    protected void playerFinishsLoggingIn(Player player) {
        this.currentlyLoggingInPlayer = null;
    }

    @Override
    protected void playerDataUnloadedOnSuccesslessLogin(Player player, PlayerDataImplBukkit value) {
        ((OnlinePlayerDataImpl)value).quit();
    }

    @Override
    protected void playerJoinedAfterTimeout(Player player) {
        try {
            this.addToHardCache(player.getUniqueId(), this.loadOnLogin(player));
        }
        catch (PlayerCacheMap.LoadingPlayerDataFailedException e) {
            player.kickPlayer(e.getKickMessage());
        }
    }

    @Override
    protected void playerDataUnloadedOnQuit(Player player, PlayerDataImplBukkit value) {
        ((OnlinePlayerDataImpl)value).quit();
    }
}

