/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import de.iani.cubesideutils.Triple;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class SerializableTriple<T, S, U>
extends Triple<T, S, U>
implements ConfigurationSerializable {
    public SerializableTriple(T first, S second, U third) {
        super(first, second, third);
    }

    public SerializableTriple(Triple<T, S, U> copyOf) {
        this(copyOf.first, copyOf.second, copyOf.third);
    }

    @Override
    public <X> SerializableTriple<X, S, U> setFirst(X first) {
        return new SerializableTriple<X, Object, Object>(first, this.second, this.third);
    }

    @Override
    public <X> SerializableTriple<T, X, U> setSecond(X second) {
        return new SerializableTriple<Object, X, Object>(this.first, second, this.third);
    }

    @Override
    public <X> SerializableTriple<T, S, X> setThird(X third) {
        return new SerializableTriple<Object, Object, X>(this.first, this.second, third);
    }

    public SerializableTriple(Map<String, Object> serialized) {
        this(serialized.get("first"), serialized.get("second"), serialized.get("third"));
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(3);
        result.put("first", this.first);
        result.put("second", this.second);
        result.put("third", this.third);
        return result;
    }

    static {
        ConfigurationSerialization.registerClass(SerializableTriple.class);
    }
}

