/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class ComponentUtilBukkit {
    private ComponentUtilBukkit() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static BaseComponent createTranslatableComponentFor(Material m) {
        String key = m.getKey().getKey();
        if (key.startsWith("music_disc_") || key.endsWith("_banner_pattern")) {
            return new TextComponent(new BaseComponent[]{new TranslatableComponent("item.minecraft." + key, new Object[0]), new TextComponent(": "), new TranslatableComponent("item.minecraft." + key + ".desc", new Object[0])});
        }
        return new TranslatableComponent((m.isBlock() ? "block.minecraft." : "item.minecraft.") + key, new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(ItemStack stack) {
        ItemMeta meta;
        Material m = stack.getType();
        if ((m == Material.TIPPED_ARROW || m == Material.POTION || m == Material.SPLASH_POTION || m == Material.LINGERING_POTION) && (meta = stack.getItemMeta()) instanceof PotionMeta) {
            String key = m.getKey().getKey();
            PotionType type = ((PotionMeta)meta).getBasePotionData().getType();
            return new TranslatableComponent("item.minecraft." + key + ".effect." + ComponentUtilBukkit.getInternalPotionName(type), new Object[0]);
        }
        String key = m.getKey().getKey();
        if (key.startsWith("music_disc_")) {
            return new TextComponent(new BaseComponent[]{new TranslatableComponent("item.minecraft." + key, new Object[0]), new TextComponent(": "), new TranslatableComponent("item.minecraft." + key + ".desc", new Object[0])});
        }
        return new TranslatableComponent((m.isBlock() ? "block.minecraft." : "item.minecraft.") + key, new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(EntityType t) {
        return new TranslatableComponent("entity.minecraft." + t.getKey().getKey(), new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(Entity e) {
        return ComponentUtilBukkit.createTranslatableComponentFor(e.getType());
    }

    private static String getInternalPotionName(PotionType t) {
        switch (t) {
            case UNCRAFTABLE: {
                return "empty";
            }
            case JUMP: {
                return "leaping";
            }
            case SPEED: {
                return "swiftness";
            }
            case INSTANT_HEAL: {
                return "healing";
            }
            case INSTANT_DAMAGE: {
                return "harming";
            }
            case REGEN: {
                return "regeneration";
            }
        }
        return t.name().toLowerCase();
    }
}

