/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import de.iani.cubesideutils.StringUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.ScoreComponent;
import net.md_5.bungee.api.chat.SelectorComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class ComponentUtil {
    private ComponentUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static BaseComponent createTranslatableComponentFor(Material m) {
        String key = m.getKey().getKey();
        if (key.startsWith("music_disc_") || key.endsWith("_banner_pattern")) {
            return new TextComponent(new BaseComponent[]{new TranslatableComponent("item.minecraft." + key, new Object[0]), new TextComponent(": "), new TranslatableComponent("item.minecraft." + key + ".desc", new Object[0])});
        }
        return new TranslatableComponent((m.isBlock() ? "block.minecraft." : "item.minecraft.") + key, new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(ItemStack stack) {
        ItemMeta meta;
        Material m = stack.getType();
        if ((m == Material.TIPPED_ARROW || m == Material.POTION || m == Material.SPLASH_POTION || m == Material.LINGERING_POTION) && (meta = stack.getItemMeta()) instanceof PotionMeta) {
            String key = m.getKey().getKey();
            PotionType type = ((PotionMeta)meta).getBasePotionData().getType();
            return new TranslatableComponent("item.minecraft." + key + ".effect." + ComponentUtil.getInternalPotionName(type), new Object[0]);
        }
        String key = m.getKey().getKey();
        if (key.startsWith("music_disc_")) {
            return new TextComponent(new BaseComponent[]{new TranslatableComponent("item.minecraft." + key, new Object[0]), new TextComponent(": "), new TranslatableComponent("item.minecraft." + key + ".desc", new Object[0])});
        }
        return new TranslatableComponent((m.isBlock() ? "block.minecraft." : "item.minecraft.") + key, new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(EntityType t) {
        return new TranslatableComponent("entity.minecraft." + t.getKey().getKey(), new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(org.bukkit.entity.Entity e) {
        return ComponentUtil.createTranslatableComponentFor(e.getType());
    }

    private static String getInternalPotionName(PotionType t) {
        switch (t) {
            case UNCRAFTABLE: {
                return "empty";
            }
            case JUMP: {
                return "leaping";
            }
            case SPEED: {
                return "swiftness";
            }
            case INSTANT_HEAL: {
                return "healing";
            }
            case INSTANT_DAMAGE: {
                return "harming";
            }
            case REGEN: {
                return "regeneration";
            }
        }
        return t.name().toLowerCase();
    }

    public static BaseComponent convertEscaped(String text) throws ParseException {
        return ComponentUtil.convertEscaped(text, 0, text.length());
    }

    public static BaseComponent convertEscaped(String text, int from, int to) throws ParseException {
        return new EscapedConverter(text, from, to).convert();
    }

    private static class EscapedConverter {
        private String text;
        private int to;
        private List<BaseComponent> components;
        private int index;
        private StringBuilder currentBuilder;
        private TextComponent currentComponent;

        EscapedConverter(String text, int from, int to) {
            this.text = Objects.requireNonNull(text);
            this.to = to;
            this.components = new ArrayList<BaseComponent>();
            this.index = from;
            this.currentBuilder = new StringBuilder();
            this.currentComponent = new TextComponent();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        BaseComponent convert() throws ParseException {
            while (this.index < this.to) {
                char next;
                char current = this.text.charAt(this.index);
                if (current == '&') {
                    next = this.charAtOrException(this.index + 1);
                    if (next == '&') {
                        this.currentBuilder.append('&');
                        ++this.index;
                    } else {
                        ChatColor color;
                        if (ChatColor.getByChar((char)next) == null && next != 'x') throw new ParseException("unknown color code &" + next, this.index);
                        if (next == 'x') {
                            if (this.index + 2 + 6 > this.to) {
                                throw new ParseException("illegal hex code", this.index);
                            }
                            color = StringUtil.parseHexColor((String)this.text, (int)(this.index + 2));
                            if (color == null) {
                                throw new ParseException("illegal hex code", this.index);
                            }
                            this.index += 7;
                        } else {
                            color = ChatColor.getByChar((char)next);
                            ++this.index;
                        }
                        this.finishComponent();
                        if (color == ChatColor.BOLD) {
                            this.currentComponent.setBold(Boolean.valueOf(true));
                        } else if (color == ChatColor.ITALIC) {
                            this.currentComponent.setItalic(Boolean.valueOf(true));
                        } else if (color == ChatColor.MAGIC) {
                            this.currentComponent.setObfuscated(Boolean.valueOf(true));
                        } else if (color == ChatColor.STRIKETHROUGH) {
                            this.currentComponent.setStrikethrough(Boolean.valueOf(true));
                        } else if (color == ChatColor.UNDERLINE) {
                            this.currentComponent.setUnderlined(Boolean.valueOf(true));
                        } else {
                            this.currentComponent.setColor(color);
                        }
                    }
                } else if (current == '\\') {
                    int contentEndIndex;
                    next = this.charAtOrException(this.index + 1);
                    if (next == '\\' || next == '&' || next == '{' || next == '}') {
                        this.currentBuilder.append(next);
                        ++this.index;
                    } else if (next == 'n') {
                        this.currentBuilder.append('\n');
                        ++this.index;
                    } else if (next == 'r') {
                        char resetType = this.charAtOrException(this.index + 2);
                        if (resetType != 'a' && resetType != 'e' && resetType != 'f') {
                            throw new ParseException("unknown reset type " + resetType, this.index + 2);
                        }
                        this.finishComponent(resetType == 'a' ? ComponentBuilder.FormatRetention.NONE : (resetType == 'e' ? ComponentBuilder.FormatRetention.FORMATTING : ComponentBuilder.FormatRetention.EVENTS));
                        this.index += 2;
                    } else if (next == 'h') {
                        Content[] content;
                        HoverEvent.Action action;
                        char actionType = this.charAtOrException(this.index + 2);
                        if (actionType != 't' && actionType != 'i' && actionType != 'e') {
                            throw new ParseException("unknown action type " + actionType, this.index + 2);
                        }
                        if (this.charAtOrException(this.index + 3) != '{') {
                            throw new ParseException("expected {", this.index + 3);
                        }
                        int contentStartIndex = this.index + 4;
                        int contentEndIndex2 = this.findMatchingRightBrace(this.index + 3, this.to);
                        if (actionType == 't') {
                            action = HoverEvent.Action.SHOW_TEXT;
                            content = new Content[]{new Text(new BaseComponent[]{ComponentUtil.convertEscaped(this.text, contentStartIndex, contentEndIndex2)})};
                        } else if (actionType == 'i') {
                            int itemCount;
                            action = HoverEvent.Action.SHOW_ITEM;
                            String[] itemStrings = this.text.substring(contentStartIndex, contentEndIndex2).split("\\,", 3);
                            String itemId = itemStrings[0];
                            try {
                                itemCount = itemStrings.length < 2 || itemStrings[1].isEmpty() ? 1 : Integer.parseInt(itemStrings[1]);
                            }
                            catch (NumberFormatException e) {
                                throw new ParseException("illegal item count " + itemStrings[1], this.index + 3 + itemStrings[0].length() + 1);
                            }
                            ItemTag tag = itemStrings.length < 3 || itemStrings[2].isEmpty() ? null : ItemTag.ofNbt((String)this.convertEscapedString(itemStrings[2]));
                            content = new Content[]{new Item(itemId, itemCount, tag)};
                        } else if (actionType == 'e') {
                            UUID entityId;
                            action = HoverEvent.Action.SHOW_ENTITY;
                            int nameStartIndex = this.text.substring(contentStartIndex, contentEndIndex2).indexOf(123) + contentStartIndex;
                            String[] entityStrings = this.text.substring(contentStartIndex, nameStartIndex < 0 ? contentEndIndex2 : nameStartIndex).split("\\,", 2);
                            String entityType = entityStrings[0];
                            try {
                                entityId = entityStrings.length < 2 || entityStrings[1].isEmpty() ? UUID.randomUUID() : UUID.fromString(entityStrings[1]);
                            }
                            catch (IllegalArgumentException e) {
                                throw new ParseException("illegal entity id " + entityStrings[1], this.index + 3 + entityStrings[0].length() + 1);
                            }
                            BaseComponent entityName = nameStartIndex < contentStartIndex ? null : ComponentUtil.convertEscaped(this.text, nameStartIndex + 1, this.findMatchingRightBrace(nameStartIndex, contentEndIndex2));
                            content = new Content[]{new Entity(entityType, entityId.toString(), entityName)};
                        } else {
                            if ($assertionsDisabled) throw new ParseException("unknown action type " + actionType, this.index + 2);
                            throw new AssertionError();
                        }
                        this.finishComponent();
                        this.currentComponent.setHoverEvent(new HoverEvent(action, content));
                        this.index = contentEndIndex2;
                    } else if (next == 'c') {
                        ClickEvent.Action action;
                        char actionType = this.charAtOrException(this.index + 2);
                        if (actionType == 'r') {
                            action = ClickEvent.Action.RUN_COMMAND;
                        } else if (actionType == 's') {
                            action = ClickEvent.Action.SUGGEST_COMMAND;
                        } else if (actionType == 'c') {
                            action = ClickEvent.Action.COPY_TO_CLIPBOARD;
                        } else if (actionType == 'p') {
                            action = ClickEvent.Action.CHANGE_PAGE;
                        } else if (actionType == 'u') {
                            action = ClickEvent.Action.OPEN_URL;
                        } else {
                            if (actionType != 'f') throw new ParseException("unknown action type " + actionType, this.index + 2);
                            throw new ParseException("action type f is rejected by clients", this.index + 2);
                        }
                        if (this.charAtOrException(this.index + 3) != '{') {
                            throw new ParseException("expected {", this.index + 3);
                        }
                        int contentStartIndex = this.index + 4;
                        int contentEndIndex3 = this.findMatchingRightBrace(this.index + 3, this.to);
                        String value = this.convertEscapedString(contentStartIndex, contentEndIndex3);
                        this.finishComponent();
                        this.currentComponent.setClickEvent(new ClickEvent(action, value));
                        this.index = contentEndIndex3;
                    } else if (next == 'i') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String insertion = this.convertEscapedString(contentStartIndex, contentEndIndex);
                        this.finishComponent();
                        this.currentComponent.setInsertion(insertion);
                        this.index = contentEndIndex;
                    } else if (next == 't') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        int translationKeyEndIndex = this.text.substring(contentStartIndex, contentEndIndex).indexOf(123);
                        translationKeyEndIndex = translationKeyEndIndex < 0 ? contentEndIndex : (translationKeyEndIndex += contentStartIndex);
                        String translationKey = this.text.substring(contentStartIndex, translationKeyEndIndex);
                        ArrayList<BaseComponent> translationExtras = new ArrayList<BaseComponent>();
                        int blockStartIndex = translationKeyEndIndex;
                        while (blockStartIndex < contentEndIndex) {
                            if (this.charAtOrException(blockStartIndex) != '{') {
                                throw new ParseException("expected {", blockStartIndex);
                            }
                            int blockEndIndex = this.findMatchingRightBrace(blockStartIndex, contentEndIndex);
                            assert (blockEndIndex >= 0);
                            translationExtras.add(ComponentUtil.convertEscaped(this.text, blockStartIndex + 1, blockEndIndex));
                            blockStartIndex = blockEndIndex + 1;
                        }
                        this.finishComponent();
                        this.currentComponent.addExtra((BaseComponent)new TranslatableComponent(translationKey, translationExtras.toArray(new Object[translationExtras.size()])));
                        this.index = contentEndIndex;
                    } else if (next == 's') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String[] scoreStrings = this.text.substring(contentStartIndex, contentEndIndex).split("\\,", 3);
                        if (scoreStrings.length < 2) {
                            throw new ParseException("missing objective name", contentEndIndex);
                        }
                        String name = scoreStrings[0];
                        String objective = scoreStrings[1];
                        String value = scoreStrings.length < 3 ? "" : scoreStrings[2];
                        this.finishComponent();
                        this.currentComponent.addExtra((BaseComponent)new ScoreComponent(name, objective, value));
                        this.index = contentEndIndex;
                    } else if (next == '@') {
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String selector = this.text.substring(contentStartIndex, contentEndIndex);
                        this.finishComponent();
                        this.currentComponent.addExtra((BaseComponent)new SelectorComponent(selector));
                        this.index = contentEndIndex;
                    } else {
                        if (next != 'k') throw new ParseException("unknown control sequence \\" + next, this.index);
                        if (this.charAtOrException(this.index + 2) != '{') {
                            throw new ParseException("expected {", this.index + 2);
                        }
                        int contentStartIndex = this.index + 3;
                        contentEndIndex = this.findMatchingRightBrace(this.index + 2, this.to);
                        String keybind = this.text.substring(contentStartIndex, contentEndIndex);
                        this.finishComponent();
                        this.currentComponent.addExtra((BaseComponent)new KeybindComponent(keybind));
                        this.index = contentEndIndex;
                    }
                } else if (current == '{') {
                    int closingIndex = this.findMatchingRightBrace(this.index, this.to);
                    this.finishComponent();
                    BaseComponent subComponent = ComponentUtil.convertEscaped(this.text, this.index + 1, closingIndex);
                    this.currentComponent.addExtra(subComponent);
                    this.index = closingIndex;
                } else {
                    if (current == '}') {
                        throw new ParseException("unmatched right brace", this.index);
                    }
                    this.currentBuilder.append(current);
                }
                ++this.index;
            }
            this.currentComponent.addExtra(this.currentBuilder.toString());
            this.components.add((BaseComponent)this.currentComponent);
            return new TextComponent(this.components.toArray(new BaseComponent[this.components.size()]));
        }

        private char charAtOrException(int i) throws ParseException {
            if (i >= this.to) {
                throw new ParseException("unexpected end of block", this.to);
            }
            return this.text.charAt(i);
        }

        private void finishComponent() {
            this.finishComponent(ComponentBuilder.FormatRetention.ALL);
        }

        private void finishComponent(ComponentBuilder.FormatRetention retention) {
            this.currentComponent.addExtra(this.currentBuilder.toString());
            this.components.add((BaseComponent)this.currentComponent);
            TextComponent newComponent = new TextComponent();
            newComponent.copyFormatting((BaseComponent)this.currentComponent, retention, true);
            this.currentComponent = newComponent;
            this.currentBuilder = new StringBuilder();
        }

        private int findMatchingRightBrace(int leftBraceIndex, int endIndex) throws ParseException {
            int depth = 0;
            block5: for (int i = leftBraceIndex; i < endIndex; ++i) {
                switch (this.text.charAt(i)) {
                    case '\\': {
                        ++i;
                        break;
                    }
                    case '{': {
                        ++depth;
                        break;
                    }
                    case '}': {
                        --depth;
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                if (depth != 0) continue;
                return i;
            }
            throw new ParseException("unmatched left brace", leftBraceIndex);
        }

        private String convertEscapedString(String text) throws ParseException {
            return this.convertEscapedString(text, 0, text.length());
        }

        private String convertEscapedString(int from, int to) throws ParseException {
            return this.convertEscapedString(this.text, from, to);
        }

        private String convertEscapedString(String text, int from, int to) throws ParseException {
            StringBuilder result = new StringBuilder();
            for (int i = from; i < to; ++i) {
                char next;
                char curr = text.charAt(i);
                if (curr == '\\') {
                    if (i + 1 >= to) {
                        throw new ParseException("unexpected end of block", to);
                    }
                    next = text.charAt(i + 1);
                    if (next == '\\' || next == '&' || next == '{' || next == '}') {
                        result.append(next);
                    } else if (next == 'n') {
                        result.append('\n');
                    } else {
                        throw new ParseException("unknown simple control sequence \\" + next, i);
                    }
                    ++i;
                    continue;
                }
                if (curr == '&') {
                    if (i + 1 >= to) {
                        result.append('\u00a7');
                        continue;
                    }
                    next = text.charAt(i + 1);
                    if (next == '&') {
                        result.append('&');
                        ++i;
                        continue;
                    }
                    result.append('\u00a7');
                    continue;
                }
                result.append(curr);
            }
            return result.toString();
        }
    }
}

