/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.bukkit;

import de.iani.cubesideutils.StringUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class ComponentUtils {
    private static final Pattern ESCAPED_LEFT_BRACE_PATTERN = Pattern.compile("\\\\\\{");
    private static final Pattern ESCAPED_RIGHT_BRACE_PATTERN = Pattern.compile("\\\\\\}");

    private ComponentUtils() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static BaseComponent createTranslatableComponentFor(Material m) {
        String key = m.getKey().getKey();
        if (key.startsWith("music_disc_") || key.endsWith("_banner_pattern")) {
            return new TextComponent(new BaseComponent[]{new TranslatableComponent("item.minecraft." + key, new Object[0]), new TextComponent(": "), new TranslatableComponent("item.minecraft." + key + ".desc", new Object[0])});
        }
        return new TranslatableComponent((m.isBlock() ? "block.minecraft." : "item.minecraft.") + key, new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(ItemStack stack) {
        ItemMeta meta;
        Material m = stack.getType();
        if ((m == Material.TIPPED_ARROW || m == Material.POTION || m == Material.SPLASH_POTION || m == Material.LINGERING_POTION) && (meta = stack.getItemMeta()) instanceof PotionMeta) {
            String key = m.getKey().getKey();
            PotionType type = ((PotionMeta)meta).getBasePotionData().getType();
            return new TranslatableComponent("item.minecraft." + key + ".effect." + ComponentUtils.getInternalPotionName(type), new Object[0]);
        }
        String key = m.getKey().getKey();
        if (key.startsWith("music_disc_")) {
            return new TextComponent(new BaseComponent[]{new TranslatableComponent("item.minecraft." + key, new Object[0]), new TextComponent(": "), new TranslatableComponent("item.minecraft." + key + ".desc", new Object[0])});
        }
        return new TranslatableComponent((m.isBlock() ? "block.minecraft." : "item.minecraft.") + key, new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(EntityType t) {
        return new TranslatableComponent("entity.minecraft." + t.getKey().getKey(), new Object[0]);
    }

    public static BaseComponent createTranslatableComponentFor(Entity e) {
        return ComponentUtils.createTranslatableComponentFor(e.getType());
    }

    private static String getInternalPotionName(PotionType t) {
        switch (t) {
            case UNCRAFTABLE: {
                return "empty";
            }
            case JUMP: {
                return "leaping";
            }
            case SPEED: {
                return "swiftness";
            }
            case INSTANT_HEAL: {
                return "healing";
            }
            case INSTANT_DAMAGE: {
                return "harming";
            }
            case REGEN: {
                return "regeneration";
            }
        }
        return t.name().toLowerCase();
    }

    public static BaseComponent convertEscaped(String text) throws ParseException {
        return ComponentUtils.convertEscaped(text, 0, text.length());
    }

    public static BaseComponent convertEscaped(String text, int from, int to) throws ParseException {
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        StringBuilder currentBuilder = new StringBuilder();
        TextComponent currentComponent = new TextComponent();
        block6: for (int i = from; i < to; ++i) {
            char current = text.charAt(i);
            switch (current) {
                case '&': {
                    if (i + 1 >= to) {
                        throw new ParseException("unexpected end of string", i + 1);
                    }
                    char next = text.charAt(i + 1);
                    if (next == '&') {
                        currentBuilder.append('&');
                        ++i;
                        continue block6;
                    }
                    if (ChatColor.getByChar((char)next) != null || next == 'x') {
                        ChatColor color;
                        if (next == 'x') {
                            if (i + 2 + 6 > to) {
                                throw new ParseException("illegal hex code", i);
                            }
                            color = StringUtil.parseHexColor(text, i + 2);
                            if (color == null) {
                                throw new ParseException("illegal hex code", i);
                            }
                            i += 7;
                        } else {
                            color = ChatColor.getByChar((char)next);
                            ++i;
                        }
                        currentComponent.addExtra(currentBuilder.toString());
                        components.add(currentComponent);
                        currentComponent = currentComponent.duplicate();
                        currentComponent.setExtra(Collections.emptyList());
                        currentBuilder = new StringBuilder();
                        if (color == ChatColor.BOLD) {
                            currentComponent.setBold(Boolean.valueOf(true));
                            continue block6;
                        }
                        if (color == ChatColor.ITALIC) {
                            currentComponent.setItalic(Boolean.valueOf(true));
                            continue block6;
                        }
                        if (color == ChatColor.MAGIC) {
                            currentComponent.setObfuscated(Boolean.valueOf(true));
                            continue block6;
                        }
                        if (color == ChatColor.STRIKETHROUGH) {
                            currentComponent.setStrikethrough(Boolean.valueOf(true));
                            continue block6;
                        }
                        if (color == ChatColor.UNDERLINE) {
                            currentComponent.setUnderlined(Boolean.valueOf(true));
                            continue block6;
                        }
                        currentComponent.setColor(color);
                        continue block6;
                    }
                    throw new ParseException("character after '&' was neither a color char nor '&' or 'x'", i);
                }
                case '\\': {
                    ClickEvent.Action action;
                    if (i + 1 >= to) {
                        throw new ParseException("unexpected end of string", i + 1);
                    }
                    char next = text.charAt(i + 1);
                    if (next == '\\' || next == '&' || next == '{' || next == '}') {
                        currentBuilder.append(next);
                        ++i;
                        continue block6;
                    }
                    if (next == 'n') {
                        currentBuilder.append('\n');
                        continue block6;
                    }
                    if (next == 't') {
                        currentBuilder.append('\t');
                        continue block6;
                    }
                    if (next == 'r') {
                        if (i + 2 >= to) {
                            throw new ParseException("unexpected end of string", to);
                        }
                        char resetType = text.charAt(i + 2);
                        if (resetType != 'a' && resetType != 'e' && resetType != 'f') {
                            throw new ParseException("unknown reset type " + resetType, i + 2);
                        }
                        currentComponent.addExtra(currentBuilder.toString());
                        components.add(currentComponent);
                        TextComponent newComponent = new TextComponent();
                        newComponent.copyFormatting((BaseComponent)currentComponent, resetType == 'a' ? ComponentBuilder.FormatRetention.NONE : (resetType == 'e' ? ComponentBuilder.FormatRetention.FORMATTING : ComponentBuilder.FormatRetention.EVENTS), true);
                        currentComponent = newComponent;
                        currentBuilder = new StringBuilder();
                        continue block6;
                    }
                    if (next == 'h') {
                        if (i + 3 >= to) {
                            throw new ParseException("unexpected end of string", to);
                        }
                        char actionType = text.charAt(i + 2);
                        if (actionType != 't' && actionType != 'i' && actionType != 'e') {
                            throw new ParseException("unknown action type " + actionType, i + 2);
                        }
                        if (text.charAt(i + 3) != '{') {
                            throw new ParseException("expected {", i + 3);
                        }
                        int contentStartIndex = i + 4;
                        int contentEndIndex = ComponentUtils.findMatchingRightBrace(text, i + 3, to);
                        if (contentEndIndex < 0) {
                            throw new ParseException("unmatched left brace", i + 3);
                        }
                        if (actionType != 't') {
                            throw new ParseException("action types i and e are currently not implemented", i + 2);
                        }
                        HoverEvent.Action action2 = HoverEvent.Action.SHOW_TEXT;
                        Content[] content = new Content[]{new Text(new BaseComponent[]{ComponentUtils.convertEscaped(text, contentStartIndex, contentEndIndex)})};
                        currentComponent.addExtra(currentBuilder.toString());
                        components.add(currentComponent);
                        currentComponent = currentComponent.duplicate();
                        currentComponent.setExtra(Collections.emptyList());
                        currentComponent.setHoverEvent(new HoverEvent(action2, content));
                        currentBuilder = new StringBuilder();
                    }
                    if (next != 'c') continue block6;
                    if (i + 3 >= to) {
                        throw new ParseException("unexpected end of string", to);
                    }
                    char actionType = text.charAt(i + 2);
                    if (actionType == 'r') {
                        action = ClickEvent.Action.RUN_COMMAND;
                    } else if (actionType == 's') {
                        action = ClickEvent.Action.SUGGEST_COMMAND;
                    } else if (actionType == 'c') {
                        action = ClickEvent.Action.COPY_TO_CLIPBOARD;
                    } else if (actionType == 'p') {
                        action = ClickEvent.Action.CHANGE_PAGE;
                    } else if (actionType == 'u') {
                        action = ClickEvent.Action.OPEN_URL;
                    } else {
                        if (actionType == 'f') {
                            throw new ParseException("action type f is rejected by clients", i + 2);
                        }
                        throw new ParseException("unknown action type " + actionType, i + 2);
                    }
                    if (text.charAt(i + 3) != '{') {
                        throw new ParseException("expected {", i + 3);
                    }
                    int contentStartIndex = i + 4;
                    int contentEndIndex = ComponentUtils.findMatchingRightBrace(text, i + 3, to);
                    if (contentEndIndex < 0) {
                        throw new ParseException("unmatched left brace", i + 3);
                    }
                    String value = text.substring(contentEndIndex, contentStartIndex);
                    value = ESCAPED_LEFT_BRACE_PATTERN.matcher(value).replaceAll("{");
                    value = ESCAPED_RIGHT_BRACE_PATTERN.matcher(value).replaceAll("}");
                    currentComponent.addExtra(currentBuilder.toString());
                    components.add(currentComponent);
                    currentComponent = currentComponent.duplicate();
                    currentComponent.setExtra(Collections.emptyList());
                    currentComponent.setClickEvent(new ClickEvent(action, value));
                    currentBuilder = new StringBuilder();
                    continue block6;
                }
                case '{': {
                    int closingIndex = ComponentUtils.findMatchingRightBrace(text, i + 1, to);
                    if (closingIndex < 0) {
                        throw new ParseException("unmatched left brace", i);
                    }
                    currentComponent.addExtra(currentBuilder.toString());
                    components.add(currentComponent);
                    currentComponent = currentComponent.duplicate();
                    currentComponent.setExtra(Collections.emptyList());
                    currentBuilder = new StringBuilder();
                    BaseComponent subComponent = ComponentUtils.convertEscaped(text, i + 2, closingIndex);
                    currentComponent.addExtra(subComponent);
                    i = closingIndex;
                    continue block6;
                }
                case '}': {
                    throw new ParseException("unmatched right brace", i);
                }
                default: {
                    currentBuilder.append(current);
                    continue block6;
                }
            }
        }
        currentComponent.addExtra(currentBuilder.toString());
        components.add(currentComponent);
        return new TextComponent(components.toArray(new BaseComponent[components.size()]));
    }

    private static int findMatchingRightBrace(String text, int leftBraceIndex, int endIndex) {
        return ComponentUtils.findMatchingRightBrace(text, leftBraceIndex, endIndex, false);
    }

    private static int findMatchingRightBrace(String text, int leftBraceIndex, int endIndex, boolean ignoreLeftBraces) {
        int depth = ignoreLeftBraces ? 1 : 0;
        block5: for (int i = leftBraceIndex; i < endIndex; ++i) {
            switch (text.charAt(i)) {
                case '\\': {
                    ++i;
                    break;
                }
                case '{': {
                    depth += ignoreLeftBraces ? 0 : 1;
                    break;
                }
                case '}': {
                    --depth;
                    break;
                }
                default: {
                    continue block5;
                }
            }
            if (depth != 0) continue;
            return i;
        }
        return -1;
    }
}

