/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;

public abstract class ChatUtil {
    private static final Map<ChatColor, Integer> CHATCOLOR_TO_RGB;
    public static final int PAGE_LENGTH = 10;

    protected ChatUtil() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    public static List<Sendable<MessageReceiver>> stringToSendableList(List<String> messages) {
        ArrayList<Sendable<MessageReceiver>> result = new ArrayList<Sendable<MessageReceiver>>(messages.size());
        for (String msg : messages) {
            result.add(new StringMsg(msg));
        }
        return result;
    }

    public static List<Sendable<MessageReceiver>> bcToSendableList(List<BaseComponent[]> messages) {
        ArrayList<Sendable<MessageReceiver>> result = new ArrayList<Sendable<MessageReceiver>>(messages.size());
        for (BaseComponent[] msg : messages) {
            result.add(new ComponentMsg(msg));
        }
        return result;
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, String name, String openPageCommandPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, ChatColor.GREEN, ChatColor.GOLD);
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, String name, String openPageCommandPrefix, String pluginPrefix, ChatColor normalColor, ChatColor warningColor) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, new ComponentBuilder(name).create(), openPageCommandPrefix, pluginPrefix, normalColor, warningColor);
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, BaseComponent[] name, String openPageCommandPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, "");
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, BaseComponent[] name, String openPageCommandPrefix, String pluginPrefix) {
        ChatUtil.sendMessagesPaged(recipient, messages, page, name, openPageCommandPrefix, pluginPrefix, ChatColor.GREEN, ChatColor.GOLD);
    }

    public static <T extends MessageReceiver> void sendMessagesPaged(T recipient, List<? extends Sendable<T>> messages, int page, BaseComponent[] name, String openPageCommandPrefix, String pluginPrefix, ChatColor normalColor, ChatColor warningColor) {
        ComponentBuilder builder;
        if (page < 0) {
            ChatUtil.sendMessage(recipient, pluginPrefix, warningColor.toString(), "Bitte gib die Seitenzahl als positive ganze Zahl an.", new Object[0]);
            return;
        }
        TextComponent prefixComponent = new TextComponent((String)(pluginPrefix.isEmpty() ? "" : pluginPrefix + " "));
        TextComponent nameComponent = new TextComponent(name);
        int listSize = messages.size();
        int numPages = (int)Math.ceil((double)listSize / 10.0);
        if (page >= numPages && page > 0) {
            ChatUtil.sendMessage(recipient, pluginPrefix, warningColor.toString(), nameComponent.getText(), " hat keine Seite ", page + 1);
            return;
        }
        if (!((String)openPageCommandPrefix).startsWith("/")) {
            openPageCommandPrefix = "/" + (String)openPageCommandPrefix;
        }
        if (numPages > 1) {
            builder = new ComponentBuilder((BaseComponent)prefixComponent);
            builder.append((BaseComponent)nameComponent).color(normalColor).append(" (Seite ").append(String.valueOf(page + 1)).append("/").append(String.valueOf(numPages)).append("):");
            recipient.sendMessage(builder.create());
        } else {
            builder = new ComponentBuilder((BaseComponent)prefixComponent);
            builder.append((BaseComponent)nameComponent).color(normalColor).append(":");
            recipient.sendMessage(builder.create());
        }
        if (listSize == 0) {
            recipient.sendMessage(ChatColor.GRAY + " -- keine --");
        }
        int index = page * 10;
        for (int i = 0; i < 10 && index < listSize; ++i, ++index) {
            messages.get(index).send(recipient);
        }
        if (numPages > 1) {
            ClickEvent ce;
            HoverEvent he;
            ChatUtil.sendMessage(recipient, pluginPrefix, normalColor.toString(), "Seite x anzeigen: ", openPageCommandPrefix, " x");
            ComponentBuilder builder2 = new ComponentBuilder(pluginPrefix).append(" << vorherige");
            if (page > 0) {
                builder2.color(ChatColor.BLUE);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Seite " + page + " anzeigen").create());
                ce = new ClickEvent(ClickEvent.Action.RUN_COMMAND, (String)openPageCommandPrefix + " " + page);
                builder2.event(he).event(ce);
            } else {
                builder2.color(ChatColor.GRAY);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Bereits auf Seite 1").create());
                builder2.event(he);
            }
            builder2.append("   ").reset().append("n\u00e4chste >>");
            if (page + 1 < numPages) {
                builder2.color(ChatColor.BLUE);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Seite " + (page + 2) + " anzeigen").create());
                ce = new ClickEvent(ClickEvent.Action.RUN_COMMAND, (String)openPageCommandPrefix + " " + (page + 2));
                builder2.event(he).event(ce);
            } else {
                builder2.color(ChatColor.GRAY);
                he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Bereits auf Seite " + numPages).create());
                builder2.event(he);
            }
            recipient.sendMessage(builder2.create());
        }
    }

    public static void sendMessage(MessageReceiver receiver, String pluginPrefix, String colors, Object message, Object ... messageParts) {
        if (messageParts.length == 0) {
            receiver.sendMessage(pluginPrefix + " " + (colors == null ? "" : colors) + message);
        } else {
            StringBuilder builder = new StringBuilder(pluginPrefix);
            if (!pluginPrefix.isEmpty()) {
                builder.append(" ");
            }
            builder.append(colors == null ? "" : colors).append(message);
            for (Object s : messageParts) {
                if (colors != null) {
                    builder.append(ChatColor.RESET).append(colors);
                }
                builder.append(Objects.toString(s));
            }
            receiver.sendMessage(builder.toString());
        }
    }

    public static Integer toRGB(ChatColor color) {
        String colorString = color.toString();
        if (colorString != null && colorString.length() > 2 && colorString.charAt(1) == 'x') {
            return Integer.parseInt(colorString.substring(2).replace(String.valueOf('\u00a7'), ""), 16);
        }
        return CHATCOLOR_TO_RGB.get(color);
    }

    static {
        HashMap<ChatColor, Integer> chatcolorToColor = new HashMap<ChatColor, Integer>();
        chatcolorToColor.put(ChatColor.BLACK, 0);
        chatcolorToColor.put(ChatColor.DARK_BLUE, 170);
        chatcolorToColor.put(ChatColor.DARK_GREEN, 43520);
        chatcolorToColor.put(ChatColor.DARK_AQUA, 43690);
        chatcolorToColor.put(ChatColor.DARK_RED, 0xAA0000);
        chatcolorToColor.put(ChatColor.DARK_PURPLE, 0xAA00AA);
        chatcolorToColor.put(ChatColor.GOLD, 0xFFAA00);
        chatcolorToColor.put(ChatColor.GRAY, 0xAAAAAA);
        chatcolorToColor.put(ChatColor.DARK_GRAY, 0x555555);
        chatcolorToColor.put(ChatColor.BLUE, 0x5555FF);
        chatcolorToColor.put(ChatColor.GREEN, 0x55FF55);
        chatcolorToColor.put(ChatColor.AQUA, 0x55FFFF);
        chatcolorToColor.put(ChatColor.RED, 0xFF5555);
        chatcolorToColor.put(ChatColor.LIGHT_PURPLE, 0xFF55FF);
        chatcolorToColor.put(ChatColor.YELLOW, 0xFFFF55);
        chatcolorToColor.put(ChatColor.WHITE, 0xFFFFFF);
        CHATCOLOR_TO_RGB = Collections.unmodifiableMap(chatcolorToColor);
    }

    public static class CachedSendableList<T extends Sendable<S>, S>
    extends AbstractList<T> {
        private IntSupplier sizeGetter;
        private BiFunction<Integer, Integer, List<T>> listFiller;
        private int cacheSize;
        private int cacheStartIndex;
        private List<T> cache;

        public CachedSendableList(IntSupplier sizeGetter, BiFunction<Integer, Integer, List<T>> listFiller, int cacheSize) {
            this.sizeGetter = sizeGetter;
            this.listFiller = listFiller;
            this.cacheSize = cacheSize;
        }

        public CachedSendableList(IntSupplier sizeGetter, BiFunction<Integer, Integer, List<T>> listFiller) {
            this(sizeGetter, listFiller, 10);
        }

        @Override
        public T get(int index) {
            int transformedIndex = index - this.cacheStartIndex;
            if (this.cache == null || transformedIndex < 0 || transformedIndex >= this.cacheSize) {
                this.cache = this.listFiller.apply(index, this.cacheSize);
                this.cacheStartIndex = index;
                transformedIndex = 0;
            }
            return (T)((Sendable)this.cache.get(transformedIndex));
        }

        @Override
        public int size() {
            return this.sizeGetter.getAsInt();
        }
    }

    public static class ComponentMsg
    implements Sendable<MessageReceiver> {
        public final BaseComponent[] message;

        public ComponentMsg(BaseComponent[] message) {
            this.message = message;
        }

        @Override
        public void send(MessageReceiver recipient) {
            recipient.sendMessage(this.message);
        }
    }

    public static class StringMsg
    implements Sendable<MessageReceiver> {
        public final String message;

        public StringMsg(String message) {
            this.message = message;
        }

        @Override
        public void send(MessageReceiver recipient) {
            recipient.sendMessage(this.message);
        }
    }

    public static interface Sendable<T> {
        public void send(T var1);
    }

    public static interface MessageReceiver {
        public void sendMessage(String var1);

        public void sendMessage(BaseComponent[] var1);
    }
}

