/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils.plugin;

import de.iani.cubesideutils.collections.IteratorUtil;
import de.iani.cubesideutils.plugin.OnlinePlayerData;
import de.iani.cubesideutils.plugin.PlayerData;
import de.iani.cubesideutils.plugin.UtilsPlugin;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

class PlayerDataCache
extends LinkedHashMap<UUID, PlayerData>
implements Listener {
    private static final long serialVersionUID = 2279901989917386890L;
    private static final int MAX_SIZE = 16;
    private Map<UUID, OnlinePlayerData> onlinePlayers;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Player currentlyLoggingInPlayer;

    public PlayerDataCache() {
        this.onlinePlayers = new HashMap<UUID, OnlinePlayerData>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)UtilsPlugin.getInstance());
    }

    Player getCurrentlyLoggingInPlayer() {
        return this.currentlyLoggingInPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(UUID playerId) {
        block8: {
            this.lock.writeLock().lock();
            try {
                boolean isOnline = false;
                long lastAction = 0L;
                boolean manuallySetAfk = false;
                PlayerData data = this.onlinePlayers.remove(playerId);
                if (data != null) {
                    isOnline = true;
                    lastAction = data.getOnlineData().getLastAction();
                    manuallySetAfk = data.getOnlineData().isManuallySetAfk();
                } else {
                    data = (PlayerData)super.remove(playerId);
                }
                if (!isOnline) break block8;
                try {
                    data = UtilsPlugin.getInstance().getDatabase().getOnlinePlayerData(playerId, true, lastAction, manuallySetAfk);
                }
                catch (SQLException e) {
                    UtilsPlugin.getInstance().getLogger().log(Level.SEVERE, "Exception trying to load OnlinePlayerData for " + playerId + " from database.");
                    this.lock.writeLock().unlock();
                    return;
                }
                this.onlinePlayers.put(playerId, (OnlinePlayerData)data);
                data.getOnlineData().checkAfk(false);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private void left(UUID playerId) {
        this.lock.writeLock().lock();
        OnlinePlayerData data = this.onlinePlayers.remove(playerId);
        data.quit();
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.LOWEST)
    public void earlyOnPlayerLoginEvent(PlayerLoginEvent event) {
        this.currentlyLoggingInPlayer = event.getPlayer();
        UUID playerId = event.getPlayer().getUniqueId();
        this.lock.writeLock().lock();
        try {
            OnlinePlayerData data;
            this.invalidate(playerId);
            try {
                data = UtilsPlugin.getInstance().getDatabase().getOnlinePlayerData(playerId, true, System.currentTimeMillis(), false);
            }
            catch (SQLException e) {
                UtilsPlugin.getInstance().getLogger().log(Level.SEVERE, "Exception trying to load OnlinePlayerData for " + playerId + " from database.");
                this.lock.writeLock().unlock();
                return;
            }
            this.onlinePlayers.put(playerId, data);
            data.setLocallyAfk(false, false);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void lateOnPlayerLoginEvent(PlayerLoginEvent event) {
        this.currentlyLoggingInPlayer = null;
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            this.left(event.getPlayer().getUniqueId());
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void lateOnPlayerQuitEvent(PlayerQuitEvent event) {
        PlayerData data = this.get(event.getPlayer().getUniqueId());
        data.setLastSeen(System.currentTimeMillis());
        this.left(event.getPlayer().getUniqueId());
    }

    @Override
    public PlayerData get(Object key) {
        return this.get(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerData get(Object key, boolean createIfMissing) {
        if (!(key instanceof UUID)) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            block13: {
                PlayerData result = this.onlinePlayers.get(key);
                if (result != null) {
                    PlayerData playerData = result;
                    return playerData;
                }
                result = (PlayerData)super.get(key);
                if (result != null) {
                    PlayerData playerData = result;
                    return playerData;
                }
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    this.lock.readLock().lock();
                    result = this.onlinePlayers.get(key);
                    if (result == null) break block13;
                    PlayerData playerData = result;
                    this.lock.writeLock().unlock();
                    return playerData;
                }
                catch (Throwable throwable) {
                    this.lock.writeLock().unlock();
                    throw throwable;
                }
            }
            PlayerData playerData = super.computeIfAbsent((UUID)key, k -> {
                PlayerData data;
                try {
                    data = UtilsPlugin.getInstance().getDatabase().getPlayerData((UUID)k, createIfMissing);
                }
                catch (SQLException e) {
                    UtilsPlugin.getInstance().getLogger().log(Level.SEVERE, "Exception trying to query database for PlayerData.", e);
                    return null;
                }
                return data;
            });
            this.lock.writeLock().unlock();
            return playerData;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public OnlinePlayerData getOnline(UUID key) {
        return this.onlinePlayers.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        this.lock.readLock().lock();
        try {
            boolean bl = super.containsKey(key) || this.onlinePlayers.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public PlayerData put(UUID key, PlayerData value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PlayerData remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<UUID, PlayerData> eldest) {
        return this.size() >= 16;
    }

    Iterable<PlayerData> loadedData() {
        return IteratorUtil.concatUnmodifiable(this.onlinePlayers.values(), this.values());
    }
}

