/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesideutils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class Pair<T, S>
implements ConfigurationSerializable {
    public final T first;
    public final S second;

    public Pair(T first, S second) {
        this.first = first;
        this.second = second;
    }

    public Pair(Map<String, Object> serialized) {
        this.first = serialized.get("first");
        this.second = serialized.get("second");
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        result.put("first", this.first);
        result.put("second", this.second);
        return result;
    }

    public String toString() {
        return "(" + this.first + ";" + this.second + ")";
    }

    public int hashCode() {
        return Objects.hashCode(this.first) + 31 * Objects.hashCode(this.second);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Pair)) {
            return false;
        }
        Pair op = (Pair)other;
        return Objects.equals(this.first, op.first) && Objects.equals(this.second, op.second);
    }

    static {
        ConfigurationSerialization.registerClass(Pair.class);
    }
}

