/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.SQLConfig;
import de.iani.cubesidestats.StatisticKeyImplementation;
import de.iani.cubesidestats.api.StatisticKey;
import de.iani.settings.sql.MySQLConnection;
import de.iani.settings.sql.SQLConnection;
import de.iani.settings.sql.SQLRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;

public class StatisticsDatabase {
    private SQLConnection connection;
    private final CubesideStatisticsImplementation impl;
    private final String getConfigValue;
    private final String increaseConfigValue;
    private final String getPlayerId;
    private final String createPlayerId;
    private final String getAllStatsKeys;
    private final String createStatsKey;
    private final String updateStatsKey;
    private final String changeScore;
    private final String setScore;
    private final String maxScore;
    private final String minScore;
    private final String getScore;
    private final String configSettingSerial = "serial";

    public StatisticsDatabase(CubesideStatisticsImplementation impl, SQLConfig config) throws SQLException {
        this.impl = impl;
        this.connection = new MySQLConnection(config.getHost(), config.getDatabase(), config.getUser(), config.getPassword());
        String prefix = config.getTablePrefix();
        this.updateTables(prefix);
        this.getConfigValue = "SELECT value FROM " + prefix + "_config WHERE setting = ?";
        this.increaseConfigValue = "INSERT INTO " + prefix + "_config (setting, `value`) VALUE (?, 1) ON DUPLICATE KEY UPDATE `value` = `value` + 1";
        this.getPlayerId = "SELECT id FROM " + prefix + "_players WHERE uuid = ?";
        this.createPlayerId = "INSERT INTO " + prefix + "_players (uuid) VALUE (?)";
        this.getAllStatsKeys = "SELECT id, name, properties FROM " + prefix + "_stats";
        this.createStatsKey = "INSERT IGNORE INTO " + prefix + "_stats (name, properties) VALUE (?, ?)";
        this.updateStatsKey = "UPDATE " + prefix + "_stats SET properties = ? WHERE id = ?";
        this.changeScore = "INSERT INTO " + prefix + "_scores (playerid, statsid, month, score) VALUE (?, ?, ?, ?) ON DUPLICATE KEY UPDATE score = score + ?";
        this.setScore = "INSERT INTO " + prefix + "_scores (playerid, statsid, month, score) VALUE (?, ?, ?, ?) ON DUPLICATE KEY UPDATE score = ?";
        this.maxScore = "INSERT INTO " + prefix + "_scores (playerid, statsid, month, score) VALUE (?, ?, ?, ?) ON DUPLICATE KEY UPDATE score = GREATEST(score,?)";
        this.minScore = "INSERT INTO " + prefix + "_scores (playerid, statsid, month, score) VALUE (?, ?, ?, ?) ON DUPLICATE KEY UPDATE score = LEAST(score,?)";
        this.getScore = "SELECT score FROM " + prefix + "_scores WHERE playerid = ? AND statsid = ? AND month = ?";
    }

    private void updateTables(final String prefix) throws SQLException {
        this.connection.runCommands((SQLRunnable)new SQLRunnable<Void>(){

            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                Statement smt = connection.createStatement();
                if (!sqlConnection.hasTable(prefix + "_config")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_config` ( `setting` varchar(50), `value` int(11), PRIMARY KEY (`setting`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_players")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_players` ( `id` int(11) AUTO_INCREMENT, `uuid` char(36) NOT NULL, PRIMARY KEY (`id`), UNIQUE KEY (`uuid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_stats")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_stats` ( `id` int(11) AUTO_INCREMENT, `name` varchar(255) NOT NULL, `properties` text NOT NULL, PRIMARY KEY (`id`), UNIQUE KEY (`name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_scores")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_scores` ( `playerid` int(11) NOT NULL, `statsid` int(11) NOT NULL, `month` int(11) NOT NULL, `score` int(11) NOT NULL, PRIMARY KEY (`playerid`,`month`,`statsid`), KEY (`statsid`,`month`,`score`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                return null;
            }
        });
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public StatisticKeyImplementation createStatisticKey(final String name) throws SQLException {
        return (StatisticKeyImplementation)this.connection.runCommands((SQLRunnable)new SQLRunnable<StatisticKeyImplementation>(){

            public StatisticKeyImplementation execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.createStatsKey, 1);
                smt.setString(1, name);
                smt.setString(2, "");
                smt.executeUpdate();
                Integer id = null;
                ResultSet results = smt.getGeneratedKeys();
                if (results.next()) {
                    id = results.getInt(1);
                }
                results.close();
                if (id == null) {
                    return null;
                }
                StatisticsDatabase.this.internalIncreaseConfigSerial(connection, sqlConnection);
                return new StatisticKeyImplementation(id, name, null, StatisticsDatabase.this.impl);
            }
        });
    }

    public void updateStatisticKey(final StatisticKey key) throws SQLException {
        this.connection.runCommands((SQLRunnable)new SQLRunnable<Void>(){

            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                StatisticKeyImplementation impl = (StatisticKeyImplementation)key;
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.updateStatsKey);
                smt.setString(1, impl.getSerializedProperties());
                smt.setInt(2, impl.getId());
                smt.executeUpdate();
                StatisticsDatabase.this.internalIncreaseConfigSerial(connection, sqlConnection);
                return null;
            }
        });
    }

    protected void internalIncreaseConfigSerial(Connection connection, SQLConnection sqlConnection) throws SQLException {
        PreparedStatement smt = sqlConnection.getOrCreateStatement(this.increaseConfigValue);
        smt.setString(1, "serial");
        smt.executeUpdate();
    }

    public ConfigDTO loadConfig(final int oldSerial) throws SQLException {
        return (ConfigDTO)this.connection.runCommands((SQLRunnable)new SQLRunnable<ConfigDTO>(){

            public ConfigDTO execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getConfigValue);
                smt.setString(1, "serial");
                ResultSet results = smt.executeQuery();
                int configSerial = 0;
                if (results.next()) {
                    configSerial = results.getInt("value");
                }
                results.close();
                if (configSerial <= oldSerial) {
                    return null;
                }
                ArrayList<StatisticKeyImplementation> keys = new ArrayList<StatisticKeyImplementation>();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getAllStatsKeys);
                results = smt.executeQuery();
                while (results.next()) {
                    keys.add(new StatisticKeyImplementation(results.getInt("id"), results.getString("name"), results.getString("properties"), StatisticsDatabase.this.impl));
                }
                results.close();
                return new ConfigDTO(configSerial, keys);
            }
        });
    }

    public int getOrCreatePlayerId(final UUID player) throws SQLException {
        return (Integer)this.connection.runCommands((SQLRunnable)new SQLRunnable<Integer>(){

            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getPlayerId);
                smt.setString(1, player.toString());
                ResultSet results = smt.executeQuery();
                Integer rv = null;
                if (results.next()) {
                    rv = results.getInt("id");
                }
                results.close();
                if (rv == null) {
                    smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.createPlayerId, 1);
                    smt.setString(1, player.toString());
                    smt.executeUpdate();
                    results = smt.getGeneratedKeys();
                    if (results.next()) {
                        rv = results.getInt(1);
                    }
                    results.close();
                }
                if (rv == null) {
                    throw new SQLException("Could not generate player id");
                }
                return rv;
            }
        });
    }

    public void increaseScore(final int databaseId, final StatisticKeyImplementation key, final int month, final int amount) throws SQLException {
        this.connection.runCommands((SQLRunnable)new SQLRunnable<Void>(){

            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.changeScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, -1);
                smt.setInt(4, amount);
                smt.setInt(5, amount);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(3, month);
                    smt.executeUpdate();
                }
                return null;
            }
        });
    }

    public void setScore(final int databaseId, final StatisticKeyImplementation key, final int month, final int value) throws SQLException {
        this.connection.runCommands((SQLRunnable)new SQLRunnable<Void>(){

            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.setScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, -1);
                smt.setInt(4, value);
                smt.setInt(5, value);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(3, month);
                    smt.executeUpdate();
                }
                return null;
            }
        });
    }

    public boolean maxScore(final int databaseId, final StatisticKeyImplementation key, final int month, final int value) throws SQLException {
        return (Boolean)this.connection.runCommands((SQLRunnable)new SQLRunnable<Boolean>(){

            public Boolean execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, month);
                ResultSet results = smt.executeQuery();
                Integer old = null;
                if (results.next()) {
                    old = results.getInt("score");
                }
                results.close();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.maxScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, -1);
                smt.setInt(4, value);
                smt.setInt(5, value);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(3, month);
                    smt.executeUpdate();
                }
                return old == null || value > old;
            }
        });
    }

    public boolean minScore(final int databaseId, final StatisticKeyImplementation key, final int month, final int value) throws SQLException {
        return (Boolean)this.connection.runCommands((SQLRunnable)new SQLRunnable<Boolean>(){

            public Boolean execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, month);
                ResultSet results = smt.executeQuery();
                Integer old = null;
                if (results.next()) {
                    old = results.getInt("score");
                }
                results.close();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.minScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, -1);
                smt.setInt(4, value);
                smt.setInt(5, value);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(3, month);
                    smt.executeUpdate();
                }
                return old == null || value < old;
            }
        });
    }

    public Integer getScore(final int databaseId, final StatisticKeyImplementation key, final int month) throws SQLException {
        return (Integer)this.connection.runCommands((SQLRunnable)new SQLRunnable<Integer>(){

            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, month);
                ResultSet results = smt.executeQuery();
                Integer rv = null;
                if (results.next()) {
                    rv = results.getInt("score");
                }
                results.close();
                return rv == null ? 0 : rv;
            }
        });
    }

    public class ConfigDTO {
        private final int configSerial;
        private final Collection<StatisticKeyImplementation> statisticKeys;

        public ConfigDTO(int configSerial, Collection<StatisticKeyImplementation> statisticKeys) {
            this.configSerial = configSerial;
            this.statisticKeys = statisticKeys;
        }

        public int getConfigSerial() {
            return this.configSerial;
        }

        public Collection<StatisticKeyImplementation> getStatisticKeys() {
            return this.statisticKeys;
        }
    }
}

