/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.Callback;
import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.StatisticKeyImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.AchivementKey;
import de.iani.cubesidestats.api.PlayerStatistics;
import de.iani.cubesidestats.api.StatisticKey;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class PlayerStatisticsImplementation
implements PlayerStatistics {
    private CubesideStatisticsImplementation stats;
    private final UUID playerId;
    private int databaseId;
    private Calendar calender = Calendar.getInstance();

    public PlayerStatisticsImplementation(final CubesideStatisticsImplementation stats, final UUID player) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        if (stats == null) {
            throw new NullPointerException("stats");
        }
        this.stats = stats;
        this.playerId = player;
        this.databaseId = -1;
        stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    PlayerStatisticsImplementation.this.databaseId = database.getOrCreatePlayerId(player);
                }
                catch (SQLException e) {
                    stats.getPlugin().getLogger().log(Level.SEVERE, "Could not load database id for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    @Override
    public UUID getOwner() {
        return this.playerId;
    }

    @Override
    public void decreaseScore(StatisticKey key, int amount) {
        this.increaseScore(key, -amount);
    }

    @Override
    public void increaseScore(StatisticKey key, int amount) {
        this.increaseScoreInMonth(key, amount, this.getCurrentMonthKey());
    }

    @Override
    public void setScore(StatisticKey key, int value) {
        this.setScoreInMonth(key, value, this.getCurrentMonthKey());
    }

    @Override
    public void maxScore(StatisticKey key, int value) {
        this.maxScoreInMonth(key, value, this.getCurrentMonthKey());
    }

    @Override
    public void minScore(StatisticKey key, int value) {
        this.minScoreInMonth(key, value, this.getCurrentMonthKey());
    }

    @Override
    public void getScore(StatisticKey key, Callback<Integer> scoreCallback) {
        this.getScoreInMonth(key, -1, scoreCallback);
    }

    @Override
    public void getPosition(StatisticKey key, Callback<Integer> positionCallback) {
        this.getPositionInMonth(key, -1, positionCallback);
    }

    @Override
    public void getScoreThisMonth(StatisticKey key, Callback<Integer> scoreCallback) {
        this.getScoreInMonth(key, this.getCurrentMonthKey(), scoreCallback);
    }

    @Override
    public void getPositionThisMonth(StatisticKey key, Callback<Integer> positionCallback) {
        this.getPositionInMonth(key, this.getCurrentMonthKey(), positionCallback);
    }

    private void minScoreInMonth(final StatisticKey key, final int value, final int month) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    database.minScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, value);
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    private void maxScoreInMonth(final StatisticKey key, final int value, final int month) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    database.maxScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, value);
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    private void setScoreInMonth(final StatisticKey key, final int value, final int month) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    database.setScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, value);
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    private void increaseScoreInMonth(final StatisticKey key, final int amount, final int month) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    database.increaseScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month, amount);
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not increase score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    private void getScoreInMonth(final StatisticKey key, final int month, final Callback<Integer> scoreCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        if (scoreCallback == null) {
            throw new NullPointerException("scoreCallback");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final Integer score = database.getScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month);
                    PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            scoreCallback.call(score);
                        }
                    });
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    private void getPositionInMonth(final StatisticKey key, final int month, final Callback<Integer> scoreCallback) {
        if (!(key instanceof StatisticKeyImplementation)) {
            throw new IllegalArgumentException("key");
        }
        if (scoreCallback == null) {
            throw new NullPointerException("scoreCallback");
        }
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                if (PlayerStatisticsImplementation.this.databaseId < 0) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Invalid database id for " + PlayerStatisticsImplementation.this.playerId);
                    return;
                }
                try {
                    final Integer score = database.getScore(PlayerStatisticsImplementation.this.databaseId, (StatisticKeyImplementation)key, month);
                    PlayerStatisticsImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)PlayerStatisticsImplementation.this.stats.getPlugin(), new Runnable(){

                        @Override
                        public void run() {
                            scoreCallback.call(score);
                        }
                    });
                }
                catch (SQLException e) {
                    PlayerStatisticsImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get score for " + PlayerStatisticsImplementation.this.playerId, e);
                }
            }
        });
    }

    private int getCurrentMonthKey() {
        this.calender.setTimeInMillis(System.currentTimeMillis());
        return this.calender.get(1) * 100 + this.calender.get(2) + 1;
    }

    @Override
    public void grantAchivement(AchivementKey key) {
    }

    @Override
    public void revokeAchivement(AchivementKey key) {
    }

    @Override
    public void hasAchivement(AchivementKey key, Callback<Boolean> achivementCallback) {
    }
}

