/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatisticsImplementation;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class StatisticKeyImplementationBase {
    protected final int id;
    protected final String name;
    protected final CubesideStatisticsImplementation stats;
    protected String displayName;
    protected boolean isMonthly;
    protected boolean isDaily;

    public StatisticKeyImplementationBase(int id, String name, String properties, CubesideStatisticsImplementation impl) {
        this.id = id;
        this.name = name;
        this.stats = impl;
        YamlConfiguration conf = new YamlConfiguration();
        if (properties != null) {
            try {
                conf.loadFromString(properties);
            }
            catch (InvalidConfigurationException e) {
                impl.getPlugin().getLogger().log(Level.SEVERE, "Could not load properties for statistics key " + name + " (" + id + ")", e);
            }
        }
        this.displayName = conf.getString("displayName");
        this.isMonthly = conf.getBoolean("isMonthly");
        this.isDaily = conf.getBoolean("isDaily");
    }

    public String getSerializedProperties() {
        YamlConfiguration conf = new YamlConfiguration();
        conf.set("displayName", (Object)this.displayName);
        conf.set("isMonthly", (Object)this.isMonthly);
        conf.set("isDaily", (Object)this.isDaily);
        return conf.saveToString();
    }

    protected abstract void save();

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setDisplayName(String name) {
        if (!Objects.equals(this.displayName, name)) {
            this.displayName = name;
            this.save();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setIsMonthlyStats(boolean monthly) {
        if (this.isMonthly != monthly) {
            this.isMonthly = monthly;
            this.save();
        }
    }

    public boolean isMonthlyStats() {
        return this.isMonthly;
    }

    public void setIsDailyStats(boolean daily) {
        if (this.isDaily != daily) {
            this.isDaily = daily;
            this.save();
        }
    }

    public boolean isDailyStats() {
        return this.isDaily;
    }

    public void copyPropertiesFrom(StatisticKeyImplementationBase e) {
        this.displayName = e.displayName;
        this.isMonthly = e.isMonthly;
        this.isDaily = e.isDaily;
    }
}

