/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import com.google.common.base.Preconditions;
import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.InternalPlayerWithScore;
import de.iani.cubesidestats.StatisticKeyImplementationBase;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.Callback;
import de.iani.cubesidestats.api.Ordering;
import de.iani.cubesidestats.api.PlayerWithScore;
import de.iani.cubesidestats.api.StatisticKey;
import de.iani.cubesidestats.api.TimeFrame;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class StatisticKeyImplementation
extends StatisticKeyImplementationBase
implements StatisticKey {
    public StatisticKeyImplementation(int id, String name, String properties, CubesideStatisticsImplementation impl) {
        super(id, name, properties, impl);
    }

    @Override
    protected void save() {
        final StatisticKeyImplementation clone = new StatisticKeyImplementation(this.id, this.name, null, this.stats);
        clone.copyPropertiesFrom(this);
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    database.updateStatisticKey(clone);
                }
                catch (SQLException e) {
                    StatisticKeyImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not save statistic key " + StatisticKeyImplementation.this.name, e);
                }
            }
        });
    }

    @Override
    public Future<List<PlayerWithScore>> getTop(int count, TimeFrame timeFrame, Callback<List<PlayerWithScore>> resultCallback) {
        return this.getTop(0, count, Ordering.DESCENDING, timeFrame, resultCallback);
    }

    @Override
    public Future<List<PlayerWithScore>> getTop(int start, int count, Ordering order, TimeFrame timeFrame) {
        return this.getTop(start, count, order, timeFrame, null);
    }

    @Override
    public Future<List<PlayerWithScore>> getTop(final int start, final int count, final Ordering order, TimeFrame timeFrame, final Callback<List<PlayerWithScore>> resultCallback) {
        boolean daily;
        boolean monthly;
        boolean bl = monthly = timeFrame == TimeFrame.MONTH;
        if (monthly && !this.isMonthlyStats()) {
            throw new IllegalArgumentException("There are no monthly stats for this key");
        }
        boolean bl2 = daily = timeFrame == TimeFrame.DAY;
        if (daily && !this.isDailyStats()) {
            throw new IllegalArgumentException("There are no daily stats for this key");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count must be >= 0");
        }
        Preconditions.checkNotNull((Object)((Object)order), (Object)"order");
        int timekey = -1;
        if (monthly) {
            timekey = this.stats.getCurrentMonthKey();
        } else if (daily) {
            timekey = this.stats.getCurrentDayKey();
        }
        final int timekey2 = timekey;
        final CompletableFuture<List<PlayerWithScore>> future = new CompletableFuture<List<PlayerWithScore>>();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    ArrayList<PlayerWithScore> scoreList = new ArrayList<PlayerWithScore>();
                    List<InternalPlayerWithScore> scoreInternal = database.getTop(StatisticKeyImplementation.this, start, count, order, timekey2);
                    for (InternalPlayerWithScore ip : scoreInternal) {
                        scoreList.add(new PlayerWithScore(StatisticKeyImplementation.this.stats.getStatistics(ip.getPlayer()), ip.getScore(), ip.getPosition()));
                    }
                    final List unmodifiableScoreList = Collections.unmodifiableList(scoreList);
                    future.complete(unmodifiableScoreList);
                    if (resultCallback != null && StatisticKeyImplementation.this.stats.getPlugin().isEnabled()) {
                        StatisticKeyImplementation.this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)StatisticKeyImplementation.this.stats.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                resultCallback.call(unmodifiableScoreList);
                            }
                        });
                    }
                }
                catch (SQLException e) {
                    StatisticKeyImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get top scores for " + StatisticKeyImplementation.this.name, e);
                }
            }
        });
        return future;
    }

    @Override
    public Future<Integer> getEntriesCount(TimeFrame timeFrame) {
        boolean daily;
        boolean monthly;
        boolean bl = monthly = timeFrame == TimeFrame.MONTH;
        if (monthly && !this.isMonthlyStats()) {
            throw new IllegalArgumentException("There are no monthly stats for this key");
        }
        boolean bl2 = daily = timeFrame == TimeFrame.DAY;
        if (daily && !this.isDailyStats()) {
            throw new IllegalArgumentException("There are no daily stats for this key");
        }
        int timekey = -1;
        if (monthly) {
            timekey = this.stats.getCurrentMonthKey();
        } else if (daily) {
            timekey = this.stats.getCurrentDayKey();
        }
        final int timekey2 = timekey;
        final CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    int entries = database.getScoreEntries(StatisticKeyImplementation.this, timekey2);
                    future.complete(entries);
                }
                catch (SQLException e) {
                    StatisticKeyImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get top scores for " + StatisticKeyImplementation.this.name, e);
                }
            }
        });
        return future;
    }
}

