/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.AchivementKeyImplementation;
import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.GlobalStatisticKeyImplementation;
import de.iani.cubesidestats.InternalPlayerWithScore;
import de.iani.cubesidestats.SQLConfig;
import de.iani.cubesidestats.SettingKeyImplementation;
import de.iani.cubesidestats.StatisticKeyImplementation;
import de.iani.cubesidestats.api.Ordering;
import de.iani.cubesidestats.sql.MySQLConnection;
import de.iani.cubesidestats.sql.SQLConnection;
import de.iani.cubesidestats.sql.SQLRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class StatisticsDatabase {
    private SQLConnection connection;
    private final CubesideStatisticsImplementation impl;
    private final String getConfigValue;
    private final String increaseConfigValue;
    private final String getPlayerId;
    private final String createPlayerId;
    private final String getAllGlobalStatsKeys;
    private final String createGlobalStatsKey;
    private final String updateGlobalStatsKey;
    private final String changeGlobalStatsValue;
    private final String setGlobalStatsValue;
    private final String maxGlobalStatsValue;
    private final String minGlobalStatsValue;
    private final String getGlobalStatsValue;
    private final String getAllStatsKeys;
    private final String createStatsKey;
    private final String updateStatsKey;
    private final String changeScore;
    private final String setScore;
    private final String maxScore;
    private final String minScore;
    private final String getScore;
    private final String getPositionMax;
    private final String getPositionMin;
    private final String getTopScoresDesc;
    private final String getTopScoresAsc;
    private final String getAllAchivementKeys;
    private final String createAchivementKey;
    private final String updateAchivementKey;
    private final String setAchivementLevel;
    private final String getAchivementLevel;
    private final String maxAchivementLevel;
    private final String getAllSettingKeys;
    private final String createSettingKey;
    private final String updateSettingKey;
    private final String setSettingValue;
    private final String getSettingValue;
    private final String getSettingValuesPlayer;
    private final String deleteThisServersPlayers;
    private final String updateThisServerPlayers;
    private final String getAllServersPlayers;
    private final String configSettingSerial = "serial";

    public StatisticsDatabase(CubesideStatisticsImplementation impl, SQLConfig config) throws SQLException {
        this.impl = impl;
        this.connection = new MySQLConnection(config.getHost(), config.getDatabase(), config.getUser(), config.getPassword());
        String prefix = config.getTablePrefix();
        this.updateTables(prefix);
        this.getConfigValue = "SELECT value FROM " + prefix + "_config WHERE setting = ?";
        this.increaseConfigValue = "INSERT INTO " + prefix + "_config (setting, `value`) VALUE (?, 1) ON DUPLICATE KEY UPDATE `value` = `value` + 1";
        this.getPlayerId = "SELECT id FROM " + prefix + "_players WHERE uuid = ?";
        this.createPlayerId = "INSERT INTO " + prefix + "_players (uuid) VALUE (?)";
        this.getAllGlobalStatsKeys = "SELECT id, name, properties FROM " + prefix + "_globalstats";
        this.createGlobalStatsKey = "INSERT IGNORE INTO " + prefix + "_globalstats (name, properties) VALUE (?, ?)";
        this.updateGlobalStatsKey = "UPDATE " + prefix + "_globalstats SET properties = ? WHERE id = ?";
        this.changeGlobalStatsValue = "INSERT INTO " + prefix + "_globalstatsvalues (statsid, month, score) VALUE (?, ?, ?) ON DUPLICATE KEY UPDATE score = score + ?";
        this.setGlobalStatsValue = "INSERT INTO " + prefix + "_globalstatsvalues (statsid, month, score) VALUE (?, ?, ?) ON DUPLICATE KEY UPDATE score = ?";
        this.maxGlobalStatsValue = "INSERT INTO " + prefix + "_globalstatsvalues (statsid, month, score) VALUE (?, ?, ?) ON DUPLICATE KEY UPDATE score = GREATEST(score,?)";
        this.minGlobalStatsValue = "INSERT INTO " + prefix + "_globalstatsvalues (statsid, month, score) VALUE (?, ?, ?) ON DUPLICATE KEY UPDATE score = LEAST(score,?)";
        this.getGlobalStatsValue = "SELECT score FROM " + prefix + "_globalstatsvalues WHERE statsid = ? AND month = ?";
        this.getAllStatsKeys = "SELECT id, name, properties FROM " + prefix + "_stats";
        this.createStatsKey = "INSERT IGNORE INTO " + prefix + "_stats (name, properties) VALUE (?, ?)";
        this.updateStatsKey = "UPDATE " + prefix + "_stats SET properties = ? WHERE id = ?";
        this.changeScore = "INSERT INTO " + prefix + "_scores (playerid, statsid, month, score) VALUE (?, ?, ?, ?) ON DUPLICATE KEY UPDATE score = score + ?";
        this.setScore = "INSERT INTO " + prefix + "_scores (playerid, statsid, month, score) VALUE (?, ?, ?, ?) ON DUPLICATE KEY UPDATE score = ?";
        this.maxScore = "INSERT INTO " + prefix + "_scores (playerid, statsid, month, score) VALUE (?, ?, ?, ?) ON DUPLICATE KEY UPDATE score = GREATEST(score,?)";
        this.minScore = "INSERT INTO " + prefix + "_scores (playerid, statsid, month, score) VALUE (?, ?, ?, ?) ON DUPLICATE KEY UPDATE score = LEAST(score,?)";
        this.getScore = "SELECT score FROM " + prefix + "_scores WHERE playerid = ? AND statsid = ? AND month = ?";
        this.getPositionMax = "SELECT COUNT(*) as count FROM " + prefix + "_scores WHERE statsid = ? AND month = ? AND score > (SELECT MAX(score) as score FROM (SELECT score FROM " + prefix + "_scores WHERE playerid = ? AND statsid = ? AND month = ? UNION SELECT 0 as score) as t)";
        this.getPositionMin = "SELECT COUNT(*) as count FROM " + prefix + "_scores WHERE statsid = ? AND month = ? AND score < (SELECT MAX(score) as score FROM (SELECT score FROM " + prefix + "_scores WHERE playerid = ? AND statsid = ? AND month = ? UNION SELECT 2147483647 as score) as t)";
        this.getTopScoresDesc = "SELECT uuid, score FROM " + prefix + "_scores sc LEFT JOIN " + prefix + "_players st ON (sc.playerid = st.id) WHERE statsid = ? AND month = ? ORDER BY score DESC LIMIT ?, ?";
        this.getTopScoresAsc = "SELECT uuid, score FROM " + prefix + "_scores sc LEFT JOIN " + prefix + "_players st ON (sc.playerid = st.id) WHERE statsid = ? AND month = ? ORDER BY score ASC LIMIT ?, ?";
        this.getAllAchivementKeys = "SELECT id, name, properties FROM " + prefix + "_achivementkeys";
        this.createAchivementKey = "INSERT IGNORE INTO " + prefix + "_achivementkeys (name, properties) VALUE (?, ?)";
        this.updateAchivementKey = "UPDATE " + prefix + "_achivementkeys SET properties = ? WHERE id = ?";
        this.setAchivementLevel = "INSERT INTO " + prefix + "_achivements (playerid, achivmenentid, level) VALUE (?, ?, ?) ON DUPLICATE KEY UPDATE level = ?";
        this.maxAchivementLevel = "INSERT INTO " + prefix + "_achivements (playerid, achivmenentid, level) VALUE (?, ?, ?) ON DUPLICATE KEY UPDATE level = GREATEST(level,?)";
        this.getAchivementLevel = "SELECT level FROM " + prefix + "_achivements WHERE playerid = ? AND achivmenentid = ?";
        this.getAllSettingKeys = "SELECT id, name, properties FROM " + prefix + "_settingkeys";
        this.createSettingKey = "INSERT IGNORE INTO " + prefix + "_settingkeys (name, properties) VALUE (?, ?)";
        this.updateSettingKey = "UPDATE " + prefix + "_settingkeys SET properties = ? WHERE id = ?";
        this.setSettingValue = "INSERT INTO " + prefix + "_settings (playerid, settingid, value) VALUE (?, ?, ?) ON DUPLICATE KEY UPDATE value = ?";
        this.getSettingValue = "SELECT value FROM " + prefix + "_settings WHERE playerid = ? AND settingid = ?";
        this.getSettingValuesPlayer = "SELECT settingid, value FROM " + prefix + "_settings WHERE playerid = ?";
        this.deleteThisServersPlayers = "DELETE FROM " + prefix + "_current_players WHERE server = ?";
        this.updateThisServerPlayers = "INSERT INTO " + prefix + "_current_players (server, game, players) VALUE (?, ?, ?) ON DUPLICATE KEY UPDATE players = ?";
        this.getAllServersPlayers = "SELECT game, SUM(players) as playersum FROM " + prefix + "_current_players  WHERE server != ? GROUP BY game";
    }

    private void updateTables(final String prefix) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                Statement smt = connection.createStatement();
                if (!sqlConnection.hasTable(prefix + "_config")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_config` ( `setting` varchar(50), `value` int(11), PRIMARY KEY (`setting`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_players")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_players` ( `id` int(11) AUTO_INCREMENT, `uuid` char(36) NOT NULL, PRIMARY KEY (`id`), UNIQUE KEY (`uuid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_stats")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_stats` ( `id` int(11) AUTO_INCREMENT, `name` varchar(255) NOT NULL, `properties` text NOT NULL, PRIMARY KEY (`id`), UNIQUE KEY (`name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_scores")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_scores` ( `playerid` int(11) NOT NULL, `statsid` int(11) NOT NULL, `month` int(11) NOT NULL, `score` int(11) NOT NULL, PRIMARY KEY (`playerid`,`month`,`statsid`), KEY (`statsid`,`month`,`score`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_globalstats")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_globalstats` ( `id` int(11) AUTO_INCREMENT, `name` varchar(255) NOT NULL, `properties` text NOT NULL, PRIMARY KEY (`id`), UNIQUE KEY (`name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_globalstatsvalues")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_globalstatsvalues` ( `statsid` int(11) NOT NULL, `month` int(11) NOT NULL, `score` int(11) NOT NULL, PRIMARY KEY (`month`,`statsid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_current_players")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_current_players` ( `server` char(36) NOT NULL, `game` varchar(100) NOT NULL, `players` int(11) NOT NULL, PRIMARY KEY (`game`,`server`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_achivementkeys")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_achivementkeys` ( `id` int(11) AUTO_INCREMENT, `name` varchar(255) NOT NULL, `properties` text NOT NULL, PRIMARY KEY (`id`), UNIQUE KEY (`name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_achivements")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_achivements` ( `playerid` int(11) NOT NULL, `achivmenentid` int(11) NOT NULL, `level` int(11) NOT NULL, PRIMARY KEY (`playerid`,`achivmenentid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_settingkeys")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_settingkeys` ( `id` int(11) AUTO_INCREMENT, `name` varchar(255) NOT NULL, `properties` text NOT NULL, PRIMARY KEY (`id`), UNIQUE KEY (`name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasTable(prefix + "_settings")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_settings` ( `playerid` int(11) NOT NULL, `settingid` int(11) NOT NULL, `value` int(11) NOT NULL, PRIMARY KEY (`playerid`,`settingid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                return null;
            }
        });
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public StatisticKeyImplementation createStatisticKey(final String name) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<StatisticKeyImplementation>(){

            @Override
            public StatisticKeyImplementation execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.createStatsKey, 1);
                smt.setString(1, name);
                smt.setString(2, "");
                smt.executeUpdate();
                Integer id = null;
                ResultSet results = smt.getGeneratedKeys();
                if (results.next()) {
                    id = results.getInt(1);
                }
                results.close();
                if (id == null) {
                    return null;
                }
                StatisticsDatabase.this.internalIncreaseConfigSerial(connection, sqlConnection);
                return new StatisticKeyImplementation(id, name, null, StatisticsDatabase.this.impl);
            }
        });
    }

    public void updateStatisticKey(final StatisticKeyImplementation impl) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.updateStatsKey);
                smt.setString(1, impl.getSerializedProperties());
                smt.setInt(2, impl.getId());
                smt.executeUpdate();
                StatisticsDatabase.this.internalIncreaseConfigSerial(connection, sqlConnection);
                return null;
            }
        });
    }

    public GlobalStatisticKeyImplementation createGlobalStatisticKey(final String name) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<GlobalStatisticKeyImplementation>(){

            @Override
            public GlobalStatisticKeyImplementation execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.createGlobalStatsKey, 1);
                smt.setString(1, name);
                smt.setString(2, "");
                smt.executeUpdate();
                Integer id = null;
                ResultSet results = smt.getGeneratedKeys();
                if (results.next()) {
                    id = results.getInt(1);
                }
                results.close();
                if (id == null) {
                    return null;
                }
                StatisticsDatabase.this.internalIncreaseConfigSerial(connection, sqlConnection);
                return new GlobalStatisticKeyImplementation(id, name, null, StatisticsDatabase.this.impl);
            }
        });
    }

    public void updateGlobalStatisticKey(final GlobalStatisticKeyImplementation impl) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.updateGlobalStatsKey);
                smt.setString(1, impl.getSerializedProperties());
                smt.setInt(2, impl.getId());
                smt.executeUpdate();
                StatisticsDatabase.this.internalIncreaseConfigSerial(connection, sqlConnection);
                return null;
            }
        });
    }

    protected void internalIncreaseConfigSerial(Connection connection, SQLConnection sqlConnection) throws SQLException {
        PreparedStatement smt = sqlConnection.getOrCreateStatement(this.increaseConfigValue);
        smt.setString(1, "serial");
        smt.executeUpdate();
    }

    public ConfigDTO loadConfig(final int oldSerial) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<ConfigDTO>(){

            @Override
            public ConfigDTO execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getConfigValue);
                smt.setString(1, "serial");
                ResultSet results = smt.executeQuery();
                int configSerial = 0;
                if (results.next()) {
                    configSerial = results.getInt("value");
                }
                results.close();
                if (configSerial <= oldSerial) {
                    return null;
                }
                ArrayList<GlobalStatisticKeyImplementation> globalStatskeys = new ArrayList<GlobalStatisticKeyImplementation>();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getAllGlobalStatsKeys);
                results = smt.executeQuery();
                while (results.next()) {
                    globalStatskeys.add(new GlobalStatisticKeyImplementation(results.getInt("id"), results.getString("name"), results.getString("properties"), StatisticsDatabase.this.impl));
                }
                results.close();
                ArrayList<StatisticKeyImplementation> statskeys = new ArrayList<StatisticKeyImplementation>();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getAllStatsKeys);
                results = smt.executeQuery();
                while (results.next()) {
                    statskeys.add(new StatisticKeyImplementation(results.getInt("id"), results.getString("name"), results.getString("properties"), StatisticsDatabase.this.impl));
                }
                results.close();
                ArrayList<AchivementKeyImplementation> achivkeys = new ArrayList<AchivementKeyImplementation>();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getAllAchivementKeys);
                results = smt.executeQuery();
                while (results.next()) {
                    achivkeys.add(new AchivementKeyImplementation(results.getInt("id"), results.getString("name"), results.getString("properties"), StatisticsDatabase.this.impl));
                }
                results.close();
                ArrayList<SettingKeyImplementation> settingkeys = new ArrayList<SettingKeyImplementation>();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getAllSettingKeys);
                results = smt.executeQuery();
                while (results.next()) {
                    settingkeys.add(new SettingKeyImplementation(results.getInt("id"), results.getString("name"), results.getString("properties"), StatisticsDatabase.this.impl));
                }
                results.close();
                return new ConfigDTO(configSerial, globalStatskeys, statskeys, achivkeys, settingkeys);
            }
        });
    }

    public int getOrCreatePlayerId(final UUID player) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Integer>(){

            @Override
            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getPlayerId);
                smt.setString(1, player.toString());
                ResultSet results = smt.executeQuery();
                Integer rv = null;
                if (results.next()) {
                    rv = results.getInt("id");
                }
                results.close();
                if (rv == null) {
                    smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.createPlayerId, 1);
                    smt.setString(1, player.toString());
                    smt.executeUpdate();
                    results = smt.getGeneratedKeys();
                    if (results.next()) {
                        rv = results.getInt(1);
                    }
                    results.close();
                }
                if (rv == null) {
                    throw new SQLException("Could not generate player id");
                }
                return rv;
            }
        });
    }

    public void increaseGlobalStatsValue(final GlobalStatisticKeyImplementation key, final int month, final int day, final int amount) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.changeGlobalStatsValue);
                smt.setInt(1, keyId);
                smt.setInt(2, -1);
                smt.setInt(3, amount);
                smt.setInt(4, amount);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(2, month);
                    smt.executeUpdate();
                }
                if (day >= 0 && key.isDailyStats()) {
                    smt.setInt(2, day);
                    smt.executeUpdate();
                }
                return null;
            }
        });
    }

    public void setGlobalStatsValue(final GlobalStatisticKeyImplementation key, final int month, final int day, final int value) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.setGlobalStatsValue);
                smt.setInt(1, keyId);
                smt.setInt(2, -1);
                smt.setInt(3, value);
                smt.setInt(4, value);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(2, month);
                    smt.executeUpdate();
                }
                if (day >= 0 && key.isDailyStats()) {
                    smt.setInt(2, day);
                    smt.executeUpdate();
                }
                return null;
            }
        });
    }

    public boolean maxGlobalStatsValue(final GlobalStatisticKeyImplementation key, final int month, final int day, final int value) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Boolean>(){

            @Override
            public Boolean execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getGlobalStatsValue);
                smt.setInt(1, keyId);
                smt.setInt(2, -1);
                ResultSet results = smt.executeQuery();
                Integer old = null;
                if (results.next()) {
                    old = results.getInt("score");
                }
                results.close();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.maxGlobalStatsValue);
                smt.setInt(1, keyId);
                smt.setInt(2, -1);
                smt.setInt(3, value);
                smt.setInt(4, value);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(2, month);
                    smt.executeUpdate();
                }
                if (day >= 0 && key.isDailyStats()) {
                    smt.setInt(2, day);
                    smt.executeUpdate();
                }
                return old == null || value > old;
            }
        });
    }

    public boolean minGlobalStatsValue(final GlobalStatisticKeyImplementation key, final int month, final int day, final int value) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Boolean>(){

            @Override
            public Boolean execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getGlobalStatsValue);
                smt.setInt(1, keyId);
                smt.setInt(2, -1);
                ResultSet results = smt.executeQuery();
                Integer old = null;
                if (results.next()) {
                    old = results.getInt("score");
                }
                results.close();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.minGlobalStatsValue);
                smt.setInt(1, keyId);
                smt.setInt(2, -1);
                smt.setInt(3, value);
                smt.setInt(4, value);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(2, month);
                    smt.executeUpdate();
                }
                if (day >= 0 && key.isDailyStats()) {
                    smt.setInt(2, day);
                    smt.executeUpdate();
                }
                return old == null || value < old;
            }
        });
    }

    public Integer getGlobalStatsValue(final GlobalStatisticKeyImplementation key, final int month) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Integer>(){

            @Override
            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getGlobalStatsValue);
                smt.setInt(1, keyId);
                smt.setInt(2, month);
                ResultSet results = smt.executeQuery();
                Integer rv = null;
                if (results.next()) {
                    rv = results.getInt("score");
                }
                results.close();
                return rv == null ? 0 : rv;
            }
        });
    }

    public void increaseScore(final int databaseId, final StatisticKeyImplementation key, final int month, final int day, final int amount) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.changeScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, -1);
                smt.setInt(4, amount);
                smt.setInt(5, amount);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(3, month);
                    smt.executeUpdate();
                }
                if (day >= 0 && key.isDailyStats()) {
                    smt.setInt(3, day);
                    smt.executeUpdate();
                }
                return null;
            }
        });
    }

    public void setScore(final int databaseId, final StatisticKeyImplementation key, final int month, final int day, final int value) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.setScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, -1);
                smt.setInt(4, value);
                smt.setInt(5, value);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(3, month);
                    smt.executeUpdate();
                }
                if (day >= 0 && key.isDailyStats()) {
                    smt.setInt(3, day);
                    smt.executeUpdate();
                }
                return null;
            }
        });
    }

    public boolean maxScore(final int databaseId, final StatisticKeyImplementation key, final int month, final int day, final int value) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Boolean>(){

            @Override
            public Boolean execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, -1);
                ResultSet results = smt.executeQuery();
                Integer old = null;
                if (results.next()) {
                    old = results.getInt("score");
                }
                results.close();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.maxScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, -1);
                smt.setInt(4, value);
                smt.setInt(5, value);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(3, month);
                    smt.executeUpdate();
                }
                if (day >= 0 && key.isDailyStats()) {
                    smt.setInt(3, day);
                    smt.executeUpdate();
                }
                return old == null || value > old;
            }
        });
    }

    public boolean minScore(final int databaseId, final StatisticKeyImplementation key, final int month, final int day, final int value) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Boolean>(){

            @Override
            public Boolean execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, -1);
                ResultSet results = smt.executeQuery();
                Integer old = null;
                if (results.next()) {
                    old = results.getInt("score");
                }
                results.close();
                smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.minScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, -1);
                smt.setInt(4, value);
                smt.setInt(5, value);
                smt.executeUpdate();
                if (month >= 0 && key.isMonthlyStats()) {
                    smt.setInt(3, month);
                    smt.executeUpdate();
                }
                if (day >= 0 && key.isDailyStats()) {
                    smt.setInt(3, day);
                    smt.executeUpdate();
                }
                return old == null || value < old;
            }
        });
    }

    public Integer getScore(final int databaseId, final StatisticKeyImplementation key, final int month) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Integer>(){

            @Override
            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getScore);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, month);
                ResultSet results = smt.executeQuery();
                Integer rv = null;
                if (results.next()) {
                    rv = results.getInt("score");
                }
                results.close();
                return rv;
            }
        });
    }

    public Integer getPositionMax(final int databaseId, final StatisticKeyImplementation key, final int month) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Integer>(){

            @Override
            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getPositionMax);
                smt.setInt(1, keyId);
                smt.setInt(2, month);
                smt.setInt(3, databaseId);
                smt.setInt(4, keyId);
                smt.setInt(5, month);
                ResultSet results = smt.executeQuery();
                Integer rv = null;
                if (results.next()) {
                    rv = results.getInt("count");
                }
                results.close();
                return (rv == null ? 0 : rv) + 1;
            }
        });
    }

    public Integer getPositionMin(final int databaseId, final StatisticKeyImplementation key, final int month) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Integer>(){

            @Override
            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getPositionMin);
                smt.setInt(1, keyId);
                smt.setInt(2, month);
                smt.setInt(3, databaseId);
                smt.setInt(4, keyId);
                smt.setInt(5, month);
                ResultSet results = smt.executeQuery();
                Integer rv = null;
                if (results.next()) {
                    rv = results.getInt("count");
                }
                results.close();
                return (rv == null ? 0 : rv) + 1;
            }
        });
    }

    public List<InternalPlayerWithScore> getTop(final StatisticKeyImplementation key, final int start, final int count, final Ordering order, final int month) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<List<InternalPlayerWithScore>>(){

            @Override
            public List<InternalPlayerWithScore> execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                PreparedStatement smt = sqlConnection.getOrCreateStatement(order == Ordering.DESCENDING ? StatisticsDatabase.this.getTopScoresDesc : StatisticsDatabase.this.getTopScoresAsc);
                smt.setInt(1, keyId);
                smt.setInt(2, month);
                smt.setInt(3, start);
                smt.setInt(4, count);
                ResultSet results = smt.executeQuery();
                ArrayList<InternalPlayerWithScore> rv = new ArrayList<InternalPlayerWithScore>();
                int position = 0;
                while (results.next()) {
                    UUID player = UUID.fromString(results.getString("uuid"));
                    int score = results.getInt("score");
                    rv.add(new InternalPlayerWithScore(player, score, ++position));
                }
                results.close();
                return rv;
            }
        });
    }

    public void deleteGamePlayers(final UUID serverid) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.deleteThisServersPlayers);
                smt.setString(1, serverid.toString());
                smt.executeUpdate();
                return null;
            }
        });
    }

    public void setGamePlayers(final UUID serverid, final String game, final int players) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.updateThisServerPlayers);
                smt.setString(1, serverid.toString());
                smt.setString(2, game);
                smt.setInt(3, players);
                smt.setInt(4, players);
                smt.executeUpdate();
                return null;
            }
        });
    }

    public HashMap<String, Integer> getGamePlayers(final UUID ignoreserverid) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<HashMap<String, Integer>>(){

            @Override
            public HashMap<String, Integer> execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getAllServersPlayers);
                smt.setString(1, ignoreserverid.toString());
                ResultSet rs = smt.executeQuery();
                HashMap<String, Integer> rv = new HashMap<String, Integer>();
                while (rs.next()) {
                    String game = rs.getString("game");
                    int players = rs.getInt("playersum");
                    rv.put(game, players);
                }
                return rv;
            }
        });
    }

    public AchivementKeyImplementation createAchivementKey(final String name) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<AchivementKeyImplementation>(){

            @Override
            public AchivementKeyImplementation execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.createAchivementKey, 1);
                smt.setString(1, name);
                smt.setString(2, "");
                smt.executeUpdate();
                Integer id = null;
                ResultSet results = smt.getGeneratedKeys();
                if (results.next()) {
                    id = results.getInt(1);
                }
                results.close();
                if (id == null) {
                    return null;
                }
                StatisticsDatabase.this.internalIncreaseConfigSerial(connection, sqlConnection);
                return new AchivementKeyImplementation(id, name, null, StatisticsDatabase.this.impl);
            }
        });
    }

    public void updateAchivementKey(final AchivementKeyImplementation impl) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.updateAchivementKey);
                smt.setString(1, impl.getSerializedProperties());
                smt.setInt(2, impl.getId());
                smt.executeUpdate();
                StatisticsDatabase.this.internalIncreaseConfigSerial(connection, sqlConnection);
                return null;
            }
        });
    }

    public Integer getAchivementLevel(final int databaseId, final AchivementKeyImplementation key) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Integer>(){

            @Override
            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                return StatisticsDatabase.this.internalGetLevel(databaseId, sqlConnection, keyId);
            }
        });
    }

    public Integer setAchivementLevel(final int databaseId, final AchivementKeyImplementation key, final int level, final boolean queryOld) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Integer>(){

            @Override
            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                Integer oldLevel = queryOld ? StatisticsDatabase.this.internalGetLevel(databaseId, sqlConnection, keyId) : null;
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.setAchivementLevel);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, level);
                smt.setInt(4, level);
                smt.executeUpdate();
                return oldLevel;
            }
        });
    }

    public Integer maxAchivementLevel(final int databaseId, final AchivementKeyImplementation key, final int level, final boolean queryOld) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Integer>(){

            @Override
            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                Integer oldLevel = queryOld ? StatisticsDatabase.this.internalGetLevel(databaseId, sqlConnection, keyId) : null;
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.maxAchivementLevel);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, level);
                smt.setInt(4, level);
                smt.executeUpdate();
                return oldLevel;
            }
        });
    }

    protected Integer internalGetLevel(int databaseId, SQLConnection sqlConnection, int keyId) throws SQLException {
        PreparedStatement smt = sqlConnection.getOrCreateStatement(this.getAchivementLevel);
        smt.setInt(1, databaseId);
        smt.setInt(2, keyId);
        ResultSet results = smt.executeQuery();
        Integer rv = null;
        if (results.next()) {
            rv = results.getInt("level");
        }
        results.close();
        return rv == null ? 0 : rv;
    }

    public SettingKeyImplementation createSettingKey(final String name) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<SettingKeyImplementation>(){

            @Override
            public SettingKeyImplementation execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.createSettingKey, 1);
                smt.setString(1, name);
                smt.setString(2, "");
                smt.executeUpdate();
                Integer id = null;
                ResultSet results = smt.getGeneratedKeys();
                if (results.next()) {
                    id = results.getInt(1);
                }
                results.close();
                if (id == null) {
                    return null;
                }
                StatisticsDatabase.this.internalIncreaseConfigSerial(connection, sqlConnection);
                return new SettingKeyImplementation(id, name, null, StatisticsDatabase.this.impl);
            }
        });
    }

    public void updateSettingKey(final SettingKeyImplementation impl) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.updateSettingKey);
                smt.setString(1, impl.getSerializedProperties());
                smt.setInt(2, impl.getId());
                smt.executeUpdate();
                StatisticsDatabase.this.internalIncreaseConfigSerial(connection, sqlConnection);
                return null;
            }
        });
    }

    public Integer getSettingValue(final int databaseId, final SettingKeyImplementation key) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Integer>(){

            @Override
            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                return StatisticsDatabase.this.internalGetSettingValue(databaseId, sqlConnection, keyId);
            }
        });
    }

    public Integer setSettingValue(final int databaseId, final SettingKeyImplementation key, final int value, final boolean queryOld) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<Integer>(){

            @Override
            public Integer execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                int keyId = key.getId();
                Integer oldLevel = queryOld ? StatisticsDatabase.this.internalGetSettingValue(databaseId, sqlConnection, keyId) : null;
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.setSettingValue);
                smt.setInt(1, databaseId);
                smt.setInt(2, keyId);
                smt.setInt(3, value);
                smt.setInt(4, value);
                smt.executeUpdate();
                return oldLevel;
            }
        });
    }

    protected Integer internalGetSettingValue(int databaseId, SQLConnection sqlConnection, int keyId) throws SQLException {
        PreparedStatement smt = sqlConnection.getOrCreateStatement(this.getSettingValue);
        smt.setInt(1, databaseId);
        smt.setInt(2, keyId);
        ResultSet results = smt.executeQuery();
        Integer rv = null;
        if (results.next()) {
            rv = results.getInt("value");
        }
        results.close();
        return rv == null ? 0 : rv;
    }

    public HashMap<SettingKeyImplementation, Integer> getSettingValues(final int databaseId, final Collection<SettingKeyImplementation> keys) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<HashMap<SettingKeyImplementation, Integer>>(){

            @Override
            public HashMap<SettingKeyImplementation, Integer> execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                HashMap<SettingKeyImplementation, Integer> result = new HashMap<SettingKeyImplementation, Integer>();
                HashMap<Integer, SettingKeyImplementation> tempKeyMap = new HashMap<Integer, SettingKeyImplementation>();
                for (SettingKeyImplementation key : keys) {
                    tempKeyMap.put(key.getId(), key);
                }
                PreparedStatement smt = sqlConnection.getOrCreateStatement(StatisticsDatabase.this.getSettingValuesPlayer);
                smt.setInt(1, databaseId);
                ResultSet results = smt.executeQuery();
                while (results.next()) {
                    SettingKeyImplementation key = (SettingKeyImplementation)tempKeyMap.get(results.getInt("settingid"));
                    int value = results.getInt("value");
                    if (key == null) continue;
                    result.put(key, value);
                }
                results.close();
                return result;
            }
        });
    }

    public class ConfigDTO {
        private final int configSerial;
        private final Collection<GlobalStatisticKeyImplementation> globalStatisticKeys;
        private final Collection<StatisticKeyImplementation> statisticKeys;
        private final Collection<AchivementKeyImplementation> achivementKeys;
        private final Collection<SettingKeyImplementation> settingKeys;

        public ConfigDTO(int configSerial, Collection<GlobalStatisticKeyImplementation> globalStatisticKeys, Collection<StatisticKeyImplementation> statisticKeys, Collection<AchivementKeyImplementation> achivementKeys, Collection<SettingKeyImplementation> settingKeys) {
            this.globalStatisticKeys = globalStatisticKeys;
            this.configSerial = configSerial;
            this.statisticKeys = statisticKeys;
            this.achivementKeys = achivementKeys;
            this.settingKeys = settingKeys;
        }

        public int getConfigSerial() {
            return this.configSerial;
        }

        public Collection<GlobalStatisticKeyImplementation> getGlobalStatisticKeys() {
            return this.globalStatisticKeys;
        }

        public Collection<StatisticKeyImplementation> getStatisticKeys() {
            return this.statisticKeys;
        }

        public Collection<AchivementKeyImplementation> getAchivementKeys() {
            return this.achivementKeys;
        }

        public Collection<SettingKeyImplementation> getSettingKeys() {
            return this.settingKeys;
        }
    }
}

