/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats.api;

import com.google.common.base.Preconditions;
import de.iani.cubesidestats.api.PlayerStatistics;
import de.iani.cubesidestats.api.StatisticKey;
import de.iani.cubesidestats.api.StatisticsQueryKey;
import de.iani.cubesidestats.api.TimeFrame;

public final class PlayerStatisticsQueryKey
implements StatisticsQueryKey {
    private final PlayerStatistics player;
    private final QueryType type;
    private final StatisticKey key;
    private final TimeFrame timeFrame;

    public PlayerStatisticsQueryKey(PlayerStatistics player, StatisticKey key, QueryType type) {
        this(player, key, type, TimeFrame.ALL_TIME);
    }

    public PlayerStatisticsQueryKey(PlayerStatistics player, StatisticKey key, QueryType type, TimeFrame timeFrame) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type");
        Preconditions.checkNotNull((Object)((Object)timeFrame), (Object)"timeFrame");
        this.player = player;
        this.key = key;
        this.type = type;
        this.timeFrame = timeFrame;
    }

    public PlayerStatistics getPlayer() {
        return this.player;
    }

    public StatisticKey getKey() {
        return this.key;
    }

    public QueryType getType() {
        return this.type;
    }

    public TimeFrame getTimeFrame() {
        return this.timeFrame;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != PlayerStatisticsQueryKey.class) {
            return false;
        }
        PlayerStatisticsQueryKey other = (PlayerStatisticsQueryKey)obj;
        return this.player.equals(other.player) && this.type == other.type && this.key == other.key && this.timeFrame == other.timeFrame;
    }

    public int hashCode() {
        return ((this.player.hashCode() * 23 + this.key.hashCode()) * 7 + this.timeFrame.hashCode()) * 23 + this.type.hashCode();
    }

    public static enum QueryType {
        SCORE,
        POSITION;

    }
}

