/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.AchivementKeyImplementation;
import de.iani.cubesidestats.CubesideStatistics;
import de.iani.cubesidestats.GamePlayerCountImplementation;
import de.iani.cubesidestats.PlayerListener;
import de.iani.cubesidestats.PlayerStatisticsImplementation;
import de.iani.cubesidestats.SQLConfig;
import de.iani.cubesidestats.SettingKeyImplementation;
import de.iani.cubesidestats.StatisticKeyImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.TimestampedValue;
import de.iani.cubesidestats.api.AchivementKey;
import de.iani.cubesidestats.api.CubesideStatisticsAPI;
import de.iani.cubesidestats.api.GamePlayerCount;
import de.iani.cubesidestats.api.PlayerStatistics;
import de.iani.cubesidestats.api.SettingKey;
import de.iani.cubesidestats.api.StatisticKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CubesideStatisticsImplementation
implements CubesideStatisticsAPI {
    private HashMap<String, StatisticKeyImplementation> statisticKeys;
    private HashMap<String, AchivementKeyImplementation> achivementKeys;
    private HashMap<String, SettingKeyImplementation> settingKeys;
    private HashMap<UUID, PlayerStatisticsImplementation> onlinePlayers;
    private HashMap<UUID, TimestampedValue<PlayerStatisticsImplementation>> offlinePlayers;
    private StatisticsDatabase database;
    private CubesideStatistics plugin;
    private WorkerThread workerThread;
    private int configSerial = -1;
    private static final int CONFIG_RELOAD_TICKS = 6000;
    private static final long MIN_CACHE_NANOS = 300000000000L;
    private final Calendar calender = Calendar.getInstance();
    private final UUID serverid;
    private final GamePlayerCountImplementation gamePlayerCount;

    public CubesideStatisticsImplementation(CubesideStatistics plugin) throws SQLException {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.serverid = this.loadOrCreateServerId();
        this.database = new StatisticsDatabase(this, new SQLConfig(plugin.getConfig().getConfigurationSection("database")));
        this.statisticKeys = new HashMap();
        this.achivementKeys = new HashMap();
        this.settingKeys = new HashMap();
        this.onlinePlayers = new HashMap();
        this.offlinePlayers = new HashMap();
        this.reloadConfigNow();
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                CubesideStatisticsImplementation.this.cleanupCache();
                CubesideStatisticsImplementation.this.reloadConfig();
            }
        }, 6000L, 6000L);
        plugin.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)plugin);
        this.workerThread = new WorkerThread();
        this.workerThread.start();
        this.gamePlayerCount = new GamePlayerCountImplementation(this);
    }

    private UUID loadOrCreateServerId() {
        File serveridFile = new File(this.plugin.getDataFolder().getParentFile().getParentFile(), "serverid");
        String serveridstring = null;
        if (serveridFile.isFile()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(serveridFile));
                serveridstring = reader.readLine();
                reader.close();
            }
            catch (IOException reader) {
                // empty catch block
            }
        }
        UUID localServerid = null;
        try {
            localServerid = serveridstring == null ? null : UUID.fromString(serveridstring);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (localServerid == null) {
            this.plugin.getLogger().info("Keine g\u00fcltige Server-ID vorhanden! Generiere neue ID!");
            localServerid = UUID.randomUUID();
            try {
                FileWriter writer = new FileWriter(serveridFile);
                writer.write(localServerid.toString());
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save server id file", e);
            }
        }
        return localServerid;
    }

    public void shutdown() {
        if (this.workerThread != null) {
            this.gamePlayerCount.clearLocalPlayers();
            this.workerThread.shutdown();
        }
    }

    public WorkerThread getWorkerThread() {
        return this.workerThread;
    }

    public CubesideStatistics getPlugin() {
        return this.plugin;
    }

    private void reloadConfig() {
        this.getWorkerThread().addWork(new WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                CubesideStatisticsImplementation.this.reloadConfigNow();
            }
        });
    }

    protected void reloadConfigNow() {
        try {
            final StatisticsDatabase.ConfigDTO config = this.database.loadConfig(this.configSerial);
            if (config == null) {
                return;
            }
            Runnable mainTheadLogic = new Runnable(){

                @Override
                public void run() {
                    if (config.getConfigSerial() <= CubesideStatisticsImplementation.this.configSerial) {
                        return;
                    }
                    CubesideStatisticsImplementation.this.configSerial = config.getConfigSerial();
                    Collection<StatisticKeyImplementation> newStatisticKeys = config.getStatisticKeys();
                    for (StatisticKeyImplementation statisticKeyImplementation : newStatisticKeys) {
                        StatisticKeyImplementation old = (StatisticKeyImplementation)CubesideStatisticsImplementation.this.statisticKeys.get(statisticKeyImplementation.getName());
                        if (old != null) {
                            old.copyPropertiesFrom(statisticKeyImplementation);
                            continue;
                        }
                        CubesideStatisticsImplementation.this.statisticKeys.put(statisticKeyImplementation.getName(), statisticKeyImplementation);
                    }
                    Collection<AchivementKeyImplementation> newAchivementKeys = config.getAchivementKeys();
                    for (AchivementKeyImplementation e : newAchivementKeys) {
                        AchivementKeyImplementation old = (AchivementKeyImplementation)CubesideStatisticsImplementation.this.achivementKeys.get(e.getName());
                        if (old != null) {
                            old.copyPropertiesFrom(e);
                            continue;
                        }
                        CubesideStatisticsImplementation.this.achivementKeys.put(e.getName(), e);
                    }
                    Collection<SettingKeyImplementation> collection = config.getSettingKeys();
                    for (SettingKeyImplementation e : collection) {
                        SettingKeyImplementation old = (SettingKeyImplementation)CubesideStatisticsImplementation.this.settingKeys.get(e.getName());
                        if (old != null) {
                            old.copyPropertiesFrom(e);
                            continue;
                        }
                        CubesideStatisticsImplementation.this.settingKeys.put(e.getName(), e);
                    }
                    CubesideStatisticsImplementation.this.plugin.getLogger().info("Reloaded config from the database");
                }
            };
            if (this.plugin.getServer().isPrimaryThread()) {
                mainTheadLogic.run();
            } else {
                this.getPlugin().getServer().getScheduler().runTask((Plugin)this.getPlugin(), mainTheadLogic);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Could not reload the config from the database", e);
        }
    }

    @Override
    public PlayerStatistics getStatistics(UUID owner) {
        PlayerStatisticsImplementation stats = this.onlinePlayers.get(owner);
        if (stats != null) {
            return stats;
        }
        TimestampedValue<PlayerStatisticsImplementation> timestampedStats = this.offlinePlayers.get(owner);
        if (timestampedStats != null) {
            return timestampedStats.get();
        }
        stats = new PlayerStatisticsImplementation(this, owner, null);
        this.offlinePlayers.put(owner, new TimestampedValue<PlayerStatisticsImplementation>(stats));
        return stats;
    }

    private void cleanupCache() {
        if (!this.offlinePlayers.isEmpty()) {
            long minTimestamp = System.nanoTime() - 300000000000L;
            Iterator<TimestampedValue<PlayerStatisticsImplementation>> it = this.offlinePlayers.values().iterator();
            while (it.hasNext()) {
                TimestampedValue<PlayerStatisticsImplementation> current = it.next();
                if (current.getTimestamp() >= minTimestamp) continue;
                it.remove();
            }
        }
    }

    @Override
    public StatisticKey getStatisticKey(String id) {
        return this.getStatisticKey(id, true);
    }

    @Override
    public StatisticKey getStatisticKey(String id, boolean create) {
        StatisticKeyImplementation existing = this.statisticKeys.get(id);
        if (existing == null && create) {
            this.reloadConfigNow();
            existing = this.statisticKeys.get(id);
            if (existing == null) {
                try {
                    existing = this.database.createStatisticKey(id);
                    this.statisticKeys.put(existing.getName(), existing);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not create statistics key", e);
                    throw new RuntimeException(e);
                }
            }
        }
        return existing;
    }

    @Override
    public boolean hasStatisticKey(String id) {
        return this.statisticKeys.containsKey(id);
    }

    @Override
    public Collection<? extends StatisticKey> getAllStatisticKeys() {
        return Collections.unmodifiableCollection(this.statisticKeys.values());
    }

    public void playerJoined(Player player) {
        TimestampedValue<PlayerStatisticsImplementation> old = this.offlinePlayers.remove(player.getUniqueId());
        this.onlinePlayers.put(player.getUniqueId(), old == null ? new PlayerStatisticsImplementation(this, player.getUniqueId(), this.settingKeys.values()) : old.get().reloadSettingsAsync(this.settingKeys.values()));
    }

    public void playerDisconnected(Player player) {
        PlayerStatisticsImplementation old = this.onlinePlayers.remove(player.getUniqueId());
        if (old != null) {
            this.offlinePlayers.put(player.getUniqueId(), new TimestampedValue<PlayerStatisticsImplementation>(old));
        }
    }

    public int getCurrentMonthKey() {
        this.calender.setTimeInMillis(System.currentTimeMillis());
        return this.calender.get(1) * 100 + this.calender.get(2) + 1;
    }

    public int getCurrentDayKey() {
        this.calender.setTimeInMillis(System.currentTimeMillis());
        return this.calender.get(1) * 1000 + this.calender.get(6);
    }

    public UUID getServerId() {
        return this.serverid;
    }

    @Override
    public GamePlayerCount getGamePlayerCount() {
        return this.gamePlayerCount;
    }

    @Override
    public AchivementKey getAchivementKey(String id) {
        return this.getAchivementKey(id, true);
    }

    @Override
    public AchivementKey getAchivementKey(String id, boolean create) {
        AchivementKeyImplementation existing = this.achivementKeys.get(id);
        if (existing == null && create) {
            this.reloadConfigNow();
            existing = this.achivementKeys.get(id);
            if (existing == null) {
                try {
                    existing = this.database.createAchivementKey(id);
                    this.achivementKeys.put(existing.getName(), existing);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not create statistics key", e);
                    throw new RuntimeException(e);
                }
            }
        }
        return existing;
    }

    @Override
    public Collection<? extends AchivementKey> getAllAchivementKeys() {
        return Collections.unmodifiableCollection(this.achivementKeys.values());
    }

    @Override
    public boolean hasAchivementKey(String id) {
        return this.achivementKeys.containsKey(id);
    }

    @Override
    public SettingKey getSettingKey(String id) {
        return this.getSettingKey(id, true);
    }

    @Override
    public SettingKey getSettingKey(String id, boolean create) {
        SettingKeyImplementation existing = this.settingKeys.get(id);
        if (existing == null && create) {
            this.reloadConfigNow();
            existing = this.settingKeys.get(id);
            if (existing == null) {
                try {
                    existing = this.database.createSettingKey(id);
                    this.settingKeys.put(existing.getName(), existing);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not create setting key", e);
                    throw new RuntimeException(e);
                }
            }
        }
        return existing;
    }

    @Override
    public boolean hasSettingKey(String id) {
        return this.settingKeys.containsKey(id);
    }

    @Override
    public Collection<? extends SettingKey> getAllSettingKeys() {
        return Collections.unmodifiableCollection(this.settingKeys.values());
    }

    public static interface WorkEntry {
        public void process(StatisticsDatabase var1);
    }

    public class WorkerThread
    extends Thread {
        private StatisticsDatabase database;
        private boolean stopping;
        private ArrayDeque<WorkEntry> work = new ArrayDeque();

        public WorkerThread() {
            this.database = CubesideStatisticsImplementation.this.database;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addWork(WorkEntry e) {
            ArrayDeque<WorkEntry> arrayDeque = this.work;
            synchronized (arrayDeque) {
                this.work.addLast(e);
                this.work.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            ArrayDeque<WorkEntry> arrayDeque = this.work;
            synchronized (arrayDeque) {
                this.stopping = true;
                this.work.notify();
            }
            boolean interrupt = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    interrupt = true;
                }
            }
            if (interrupt) {
                Thread.currentThread().interrupt();
            }
            if (this.database != null) {
                this.database.disconnect();
                this.database = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WorkEntry e;
                ArrayDeque<WorkEntry> arrayDeque = this.work;
                synchronized (arrayDeque) {
                    e = this.work.pollFirst();
                    if (e == null) {
                        if (this.stopping) {
                            return;
                        }
                        try {
                            this.work.wait();
                        }
                        catch (InterruptedException e1) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                if (e == null || this.database == null) continue;
                try {
                    e.process(this.database);
                    continue;
                }
                catch (Exception er) {
                    CubesideStatisticsImplementation.this.plugin.getLogger().log(Level.SEVERE, "Error in Statistics", er);
                    continue;
                }
                break;
            }
        }
    }
}

