/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import com.google.common.base.Preconditions;
import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.AchivementKey;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class AchivementKeyImplementation
implements AchivementKey {
    private final int id;
    private final String name;
    private final CubesideStatisticsImplementation stats;
    private String displayName;
    private int maxLevel;

    public AchivementKeyImplementation(int id, String name, String properties, CubesideStatisticsImplementation impl) {
        this.id = id;
        this.name = name;
        this.stats = impl;
        this.maxLevel = 1;
        YamlConfiguration conf = new YamlConfiguration();
        if (properties != null) {
            try {
                conf.loadFromString(properties);
            }
            catch (InvalidConfigurationException e) {
                impl.getPlugin().getLogger().log(Level.SEVERE, "Could not load properties for achivement key " + name + " (" + id + ")", e);
            }
        }
        this.displayName = conf.getString("displayName");
        this.maxLevel = Math.max(conf.getInt("maxLevel"), 1);
    }

    public String getSerializedProperties() {
        YamlConfiguration conf = new YamlConfiguration();
        conf.set("displayName", (Object)this.displayName);
        conf.set("maxLevel", (Object)this.maxLevel);
        return conf.saveToString();
    }

    private void save() {
        final AchivementKeyImplementation clone = new AchivementKeyImplementation(this.id, this.name, null, this.stats);
        clone.copyPropertiesFrom(this);
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    database.updateAchivementKey(clone);
                }
                catch (SQLException e) {
                    AchivementKeyImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not save achivement key " + AchivementKeyImplementation.this.name, e);
                }
            }
        });
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDisplayName(String name) {
        if (!Objects.equals(this.name, name)) {
            this.displayName = name;
            this.save();
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setMaxLevel(int level) {
        Preconditions.checkArgument((level >= 1 ? 1 : 0) != 0, (Object)"level must be 1 or more");
        if (this.maxLevel != level) {
            this.maxLevel = level;
            this.save();
        }
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void copyPropertiesFrom(AchivementKeyImplementation e) {
        this.displayName = e.displayName;
        this.maxLevel = e.maxLevel;
    }
}

