/*
 * Decompiled with CFR 0.152.
 */
package de.iani.cubesidestats;

import de.iani.cubesidestats.CubesideStatisticsImplementation;
import de.iani.cubesidestats.StatisticsDatabase;
import de.iani.cubesidestats.api.GamePlayerCount;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GamePlayerCountImplementation
implements GamePlayerCount {
    private final CubesideStatisticsImplementation stats;
    private final HashMap<String, Integer> localPlayers;
    private HashMap<String, Integer> globalPlayers;

    public GamePlayerCountImplementation(final CubesideStatisticsImplementation stats) {
        this.stats = stats;
        this.localPlayers = new HashMap();
        this.globalPlayers = new HashMap();
        this.clearLocalPlayers();
        stats.getPlugin().getServer().getScheduler().runTaskTimer((Plugin)stats.getPlugin(), new Runnable(){

            @Override
            public void run() {
                stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

                    @Override
                    public void process(StatisticsDatabase database) {
                        try {
                            final HashMap<String, Integer> globalPlayersNew = database.getGamePlayers(stats.getServerId());
                            new BukkitRunnable(){

                                public void run() {
                                    GamePlayerCountImplementation.this.globalPlayers = globalPlayersNew;
                                }
                            }.runTask((Plugin)stats.getPlugin());
                        }
                        catch (SQLException e) {
                            stats.getPlugin().getLogger().log(Level.SEVERE, "Could not get global player amount", e);
                        }
                    }
                });
            }
        }, 200L, 200L);
    }

    public void clearLocalPlayers() {
        this.localPlayers.clear();
        this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

            @Override
            public void process(StatisticsDatabase database) {
                try {
                    database.deleteGamePlayers(GamePlayerCountImplementation.this.stats.getServerId());
                }
                catch (SQLException e) {
                    GamePlayerCountImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not clear games playercounts", e);
                }
            }
        });
    }

    @Override
    public void addLocalPlayers(String game, int amount) {
        if (amount == 0) {
            return;
        }
        int newAmount = amount + this.getLocalPlayers(game);
        if (newAmount != 0) {
            this.localPlayers.put(game, newAmount);
        } else {
            this.localPlayers.remove(game);
        }
        this.updateDatabasePlayers(game, newAmount);
    }

    @Override
    public void subtractLocalPlayers(String game, int amount) {
        this.addLocalPlayers(game, -amount);
    }

    @Override
    public void setLocalPlayers(String game, int amount) {
        if (amount != 0) {
            this.localPlayers.put(game, amount);
        } else {
            this.localPlayers.remove(game);
        }
        this.updateDatabasePlayers(game, amount);
    }

    private void updateDatabasePlayers(final String game, final int newAmount) {
        this.stats.getPlugin().getServer().getScheduler().runTask((Plugin)this.stats.getPlugin(), new Runnable(){

            @Override
            public void run() {
                GamePlayerCountImplementation.this.stats.getWorkerThread().addWork(new CubesideStatisticsImplementation.WorkEntry(){

                    @Override
                    public void process(StatisticsDatabase database) {
                        try {
                            database.setGamePlayers(GamePlayerCountImplementation.this.stats.getServerId(), game, newAmount);
                        }
                        catch (SQLException e) {
                            GamePlayerCountImplementation.this.stats.getPlugin().getLogger().log(Level.SEVERE, "Could not set player amount " + game, e);
                        }
                    }
                });
            }
        });
    }

    @Override
    public int getLocalPlayers(String game) {
        Integer local = this.localPlayers.get(game);
        return local == null ? 0 : local;
    }

    private int getGlobalPlayers(String game) {
        Integer global = this.globalPlayers.get(game);
        return global == null ? 0 : global;
    }

    @Override
    public int getPlayers(String game) {
        return this.getLocalPlayers(game) + this.getGlobalPlayers(game);
    }
}

