/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings.libs.de.iani.cubesideutils;

import de.iani.settings.libs.de.iani.cubesideutils.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffects {
    private static final Map<PotionEffectType, Integer> typeToMax = new HashMap<PotionEffectType, Integer>();

    private PotionEffects() {
        throw new UnsupportedOperationException("No instance for you, Sir!");
    }

    private static void addEffectType(PotionEffectType type, int maxAmplifier) {
        typeToMax.put(type, maxAmplifier - 1);
    }

    public static int getMaxAmplifier(PotionEffectType type) {
        return typeToMax.get(type);
    }

    public static String toNiceString(PotionEffect effect) {
        String result = StringUtil.capitalizeFirstLetter(effect.getType().getName(), true);
        if (effect.getAmplifier() != 0 || PotionEffects.getMaxAmplifier(effect.getType()) != 0) {
            result = result + " " + StringUtil.toRomanNumber(effect.getAmplifier() + 1);
        }
        if (effect.isAmbient() || !effect.hasParticles() || !effect.hasIcon()) {
            result = result + " (";
            boolean first = true;
            if (effect.isAmbient()) {
                if (!first) {
                    result = result + ", ";
                }
                first = false;
                result = result + "ambient";
            }
            if (!effect.hasParticles()) {
                if (!first) {
                    result = result + ", ";
                }
                first = false;
                result = result + "no particles";
            }
            if (!effect.hasIcon()) {
                if (!first) {
                    result = result + ", ";
                }
                first = false;
                result = result + "no icon";
            }
            result = result + ")";
        }
        if (!effect.getType().isInstant()) {
            result = result + " for " + (effect.getDuration() == 0 ? "0 s" : StringUtil.formatTimespan(effect.getDuration() * 50, "d", "h", "m", "s", " ", " "));
        }
        return result;
    }

    static {
        PotionEffects.addEffectType(PotionEffectType.ABSORPTION, 4);
        PotionEffects.addEffectType(PotionEffectType.BLINDNESS, 1);
        PotionEffects.addEffectType(PotionEffectType.CONDUIT_POWER, 1);
        PotionEffects.addEffectType(PotionEffectType.CONFUSION, 1);
        PotionEffects.addEffectType(PotionEffectType.DAMAGE_RESISTANCE, 2);
        PotionEffects.addEffectType(PotionEffectType.DOLPHINS_GRACE, 1);
        PotionEffects.addEffectType(PotionEffectType.FAST_DIGGING, 2);
        PotionEffects.addEffectType(PotionEffectType.FIRE_RESISTANCE, 1);
        PotionEffects.addEffectType(PotionEffectType.GLOWING, 1);
        PotionEffects.addEffectType(PotionEffectType.HARM, 2);
        PotionEffects.addEffectType(PotionEffectType.HEAL, 2);
        PotionEffects.addEffectType(PotionEffectType.HEALTH_BOOST, 0);
        PotionEffects.addEffectType(PotionEffectType.HUNGER, 1);
        PotionEffects.addEffectType(PotionEffectType.INCREASE_DAMAGE, 2);
        PotionEffects.addEffectType(PotionEffectType.INVISIBILITY, 1);
        PotionEffects.addEffectType(PotionEffectType.JUMP, 2);
        PotionEffects.addEffectType(PotionEffectType.LEVITATION, 1);
        PotionEffects.addEffectType(PotionEffectType.LUCK, 0);
        PotionEffects.addEffectType(PotionEffectType.NIGHT_VISION, 1);
        PotionEffects.addEffectType(PotionEffectType.POISON, 2);
        PotionEffects.addEffectType(PotionEffectType.REGENERATION, 2);
        PotionEffects.addEffectType(PotionEffectType.SATURATION, 0);
        PotionEffects.addEffectType(PotionEffectType.SLOW, 4);
        PotionEffects.addEffectType(PotionEffectType.SLOW_DIGGING, 3);
        PotionEffects.addEffectType(PotionEffectType.SLOW_FALLING, 1);
        PotionEffects.addEffectType(PotionEffectType.SPEED, 2);
        PotionEffects.addEffectType(PotionEffectType.UNLUCK, 0);
        PotionEffects.addEffectType(PotionEffectType.WATER_BREATHING, 1);
        PotionEffects.addEffectType(PotionEffectType.WEAKNESS, 2);
        PotionEffects.addEffectType(PotionEffectType.WITHER, 2);
    }
}

