/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings;

import de.iani.settings.CubesideSettings;
import de.iani.settings.events.PlayerSettingShowCompassInSurvivalChangedEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class PlayerSettings {
    private final CubesideSettings plugin;
    private final UUID player;
    private YesNoNotInGames showPublicChat;
    private YesNoNotInGames showJoinAndQuitMessages;
    private boolean showPrivateMessages;
    private YesNoNotInGames showNewsticker;
    private YesNoNotInGames soundOnPrivateMessage;
    private YesNoNotInGames soundOnReference;
    private final ArrayList<String> aliasNames;
    private final List<String> aliasNamesUnmodifiable;
    private boolean isInMinigame;
    private boolean showCompassInSurvival;

    public PlayerSettings(CubesideSettings plugin, UUID player, String[] aliasNamesArray, YesNoNotInGames showPublicChat, YesNoNotInGames showJoinAndQuitMessages, boolean showPrivateMessages, YesNoNotInGames showNewsticker, YesNoNotInGames soundOnPrivateMessage, YesNoNotInGames soundOnReference, boolean showCompassInSurvival) {
        this.plugin = plugin;
        this.player = player;
        this.showPublicChat = showPublicChat;
        this.showJoinAndQuitMessages = showJoinAndQuitMessages;
        this.showPrivateMessages = showPrivateMessages;
        this.showNewsticker = showNewsticker;
        this.soundOnPrivateMessage = soundOnPrivateMessage;
        this.soundOnReference = soundOnReference;
        this.showCompassInSurvival = showCompassInSurvival;
        this.aliasNames = new ArrayList<Object>(Arrays.asList((Object[])aliasNamesArray.clone()));
        this.aliasNamesUnmodifiable = Collections.unmodifiableList(this.aliasNames);
    }

    public PlayerSettings(CubesideSettings plugin, UUID player) {
        this.plugin = plugin;
        this.player = player;
        this.showPublicChat = YesNoNotInGames.NotInGames;
        this.showJoinAndQuitMessages = YesNoNotInGames.NotInGames;
        this.showPrivateMessages = true;
        this.showNewsticker = YesNoNotInGames.NotInGames;
        this.soundOnPrivateMessage = YesNoNotInGames.Yes;
        this.soundOnReference = YesNoNotInGames.No;
        this.showCompassInSurvival = true;
        this.aliasNames = new ArrayList();
        this.aliasNamesUnmodifiable = Collections.unmodifiableList(this.aliasNames);
    }

    public UUID getPlayer() {
        return this.player;
    }

    public boolean getShowCompassInSurvival() {
        return this.showCompassInSurvival;
    }

    public void setShowCompassInSurvival(boolean value) {
        this.showCompassInSurvival = value;
        try {
            this.plugin.getSettingsDatabase().updateShowCompassInSurvival(this.player, value);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save setting updateShowCompassInSurvival", e);
        }
        Bukkit.getPluginManager().callEvent((Event)new PlayerSettingShowCompassInSurvivalChangedEvent(Bukkit.getPlayer((UUID)this.player), value));
    }

    public YesNoNotInGames getShowPublicChat() {
        return this.showPublicChat;
    }

    public void setShowPublicChat(YesNoNotInGames value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.showPublicChat = value;
        try {
            this.plugin.getSettingsDatabase().updateShowPublicChat(this.player, value);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save setting updateShowPublicChat", e);
        }
    }

    public YesNoNotInGames getShowJoinAndQuitMessages() {
        return this.showJoinAndQuitMessages;
    }

    public void setShowJoinAndQuitMessages(YesNoNotInGames value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.showJoinAndQuitMessages = value;
        try {
            this.plugin.getSettingsDatabase().updateShowJoinAndQuitMessages(this.player, value);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save setting updateShowJoinAndQuitMessages", e);
        }
    }

    public boolean getShowPrivateMessages() {
        return this.showPrivateMessages;
    }

    public void setShowPrivateMessages(boolean value) {
        this.showPrivateMessages = value;
        try {
            this.plugin.getSettingsDatabase().updateShowPrivateMessages(this.player, value);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save setting updateShowPrivateMessages", e);
        }
    }

    public YesNoNotInGames getShowNewsticker() {
        return this.showNewsticker;
    }

    public void setShowNewsticker(YesNoNotInGames value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.showNewsticker = value;
        try {
            this.plugin.getSettingsDatabase().updateShowNewsticker(this.player, value);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save setting updateShowNewsticker", e);
        }
    }

    public YesNoNotInGames getSoundOnPrivateMessage() {
        return this.soundOnPrivateMessage;
    }

    public void setSoundOnPrivateMessage(YesNoNotInGames value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.soundOnPrivateMessage = value;
        try {
            this.plugin.getSettingsDatabase().updateSoundOnPrivateMessage(this.player, value);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save setting updateSoundOnPrivateMessage", e);
        }
    }

    public YesNoNotInGames getSoundOnReference() {
        return this.soundOnReference;
    }

    public void setSoundOnReference(YesNoNotInGames value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.soundOnReference = value;
        try {
            this.plugin.getSettingsDatabase().updateSoundOnReference(this.player, value);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save setting updateSoundOnReference", e);
        }
    }

    public List<String> getAliasNames() {
        return this.aliasNamesUnmodifiable;
    }

    public void addAliasName(String name) {
        if (!this.aliasNames.contains(name = name.replace(",", "").toLowerCase())) {
            this.aliasNames.add(name);
            this.saveAliasNames();
        }
    }

    public void removeAliasName(String name) {
        if (this.aliasNames.remove(name = name.replace(",", "").toLowerCase())) {
            this.saveAliasNames();
        }
    }

    private void saveAliasNames() {
        try {
            StringBuilder sb = new StringBuilder(this.aliasNames.size() == 0 ? "" : this.aliasNames.get(0));
            for (int i = 1; i < this.aliasNames.size(); ++i) {
                sb.append(',').append(this.aliasNames.get(i));
            }
            this.plugin.getSettingsDatabase().updateAliasNames(this.player, sb.toString());
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save setting updateAliasNames", e);
        }
    }

    public boolean isInMinigame() {
        return this.isInMinigame;
    }

    public void setInMinigame(boolean isInMinigame) {
        this.isInMinigame = isInMinigame;
    }

    public static enum YesNoNotInGames {
        No,
        Yes,
        NotInGames;

        private static YesNoNotInGames[] values;

        public static YesNoNotInGames valueOf(int ordinal) {
            if (ordinal >= 0 && ordinal < values.length) {
                return values[ordinal];
            }
            return NotInGames;
        }

        public static YesNoNotInGames valueOf(boolean bool) {
            return bool ? Yes : No;
        }

        static {
            values = YesNoNotInGames.values();
        }
    }
}

