/*
 * Decompiled with CFR 0.152.
 */
package de.iani.settings;

import de.iani.settings.CubesideSettings;
import de.iani.settings.PlayerSettings;
import de.iani.settings.SQLConfig;
import de.iani.settings.sql.MySQLConnection;
import de.iani.settings.sql.SQLConnection;
import de.iani.settings.sql.SQLRunnable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

public class SettingsDatabase {
    private SQLConnection connection;
    private final CubesideSettings plugin;
    private final String getPlayerSettings;
    private final String updateSettingShowPublicChat;
    private final String updateShowJoinAndQuitMessages;
    private final String updateShowPrivateMessages;
    private final String updateSoundOnPrivateMessage;
    private final String updateSoundOnReference;
    private final String updateAliasNames;
    private final String updateShowNewsticker;
    private final String updateShowCompassInSurvival;

    public SettingsDatabase(CubesideSettings plugin, SQLConfig config) throws SQLException {
        this.plugin = plugin;
        this.connection = new MySQLConnection(config.getHost(), config.getDatabase(), config.getUser(), config.getPassword());
        String prefix = config.getTablePrefix();
        this.updateTables(prefix);
        this.getPlayerSettings = "SELECT showPublicChat, showJoinAndQuitMessages, showPrivateMessages, showCompassInSurvival, showNewsticker, soundOnPrivateMessage, soundOnReference, aliasNames FROM " + prefix + "_players WHERE uuid = ?";
        this.updateSettingShowPublicChat = "INSERT INTO " + prefix + "_players (uuid, showPublicChat) VALUE (?, ?) ON DUPLICATE KEY UPDATE showPublicChat = ?";
        this.updateShowJoinAndQuitMessages = "INSERT INTO " + prefix + "_players (uuid, showJoinAndQuitMessages) VALUE (?, ?) ON DUPLICATE KEY UPDATE showJoinAndQuitMessages = ?";
        this.updateShowPrivateMessages = "INSERT INTO " + prefix + "_players (uuid, showPrivateMessages) VALUE (?, ?) ON DUPLICATE KEY UPDATE showPrivateMessages = ?";
        this.updateSoundOnPrivateMessage = "INSERT INTO " + prefix + "_players (uuid, soundOnPrivateMessage) VALUE (?, ?) ON DUPLICATE KEY UPDATE soundOnPrivateMessage = ?";
        this.updateSoundOnReference = "INSERT INTO " + prefix + "_players (uuid, soundOnReference) VALUE (?, ?) ON DUPLICATE KEY UPDATE soundOnReference = ?";
        this.updateShowNewsticker = "INSERT INTO " + prefix + "_players (uuid, showNewsticker) VALUE (?, ?) ON DUPLICATE KEY UPDATE showNewsticker = ?";
        this.updateShowCompassInSurvival = "INSERT INTO " + prefix + "_players (uuid, showCompassInSurvival) VALUE (?, ?) ON DUPLICATE KEY UPDATE showCompassInSurvival = ?";
        this.updateAliasNames = "INSERT INTO " + prefix + "_players (uuid, aliasNames) VALUE (?, ?) ON DUPLICATE KEY UPDATE aliasNames = ?";
    }

    private void updateTables(final String prefix) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                Statement smt = connection.createStatement();
                if (!sqlConnection.hasTable(prefix + "_players")) {
                    smt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + prefix + "_players` ( `uuid` char(36) NOT NULL, `showPublicChat` tinyint(4) NOT NULL DEFAULT '2', `showJoinAndQuitMessages` tinyint(4) NOT NULL DEFAULT '2', `showPrivateMessages` tinyint(4) NOT NULL DEFAULT '1', `soundOnPrivateMessage` tinyint(4) NOT NULL DEFAULT '2' `soundOnReference` tinyint(4) NOT NULL DEFAULT '0' `aliasNames` VARCHAR(10000) NOT NULL DEFAULT '' PRIMARY KEY (`uuid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
                }
                if (!sqlConnection.hasColumn(prefix + "_players", "soundOnPrivateMessage")) {
                    smt.executeUpdate("ALTER TABLE `" + prefix + "_players` ADD `soundOnPrivateMessage` tinyint(4) NOT NULL DEFAULT '0'");
                    smt.executeUpdate("ALTER TABLE `" + prefix + "_players` ADD `soundOnReference` tinyint(4) NOT NULL DEFAULT '0'");
                }
                if (!sqlConnection.hasColumn(prefix + "_players", "aliasNames")) {
                    smt.executeUpdate("ALTER TABLE `" + prefix + "_players` ADD `aliasNames` VARCHAR(10000) NOT NULL DEFAULT ''");
                }
                if (!sqlConnection.hasColumn(prefix + "_players", "showNewsticker")) {
                    smt.executeUpdate("ALTER TABLE `" + prefix + "_players` ADD `showNewsticker` tinyint(4) NOT NULL DEFAULT '1' AFTER showPrivateMessages");
                }
                if (!sqlConnection.hasColumn(prefix + "_players", "showCompassInSurvival")) {
                    smt.executeUpdate("ALTER TABLE `" + prefix + "_players` ADD `showCompassInSurvival` tinyint(4) NOT NULL DEFAULT '1' AFTER showNewsticker");
                }
                return null;
            }
        });
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public PlayerSettings getPlayerSettings(final UUID player) throws SQLException {
        return this.connection.runCommands(new SQLRunnable<PlayerSettings>(){

            @Override
            public PlayerSettings execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PlayerSettings rv = null;
                PreparedStatement smt = sqlConnection.getOrCreateStatement(SettingsDatabase.this.getPlayerSettings);
                smt.setString(1, player.toString());
                ResultSet results = smt.executeQuery();
                if (results.next()) {
                    PlayerSettings.YesNoNotInGames showPublicChat = PlayerSettings.YesNoNotInGames.valueOf(results.getInt("showPublicChat"));
                    PlayerSettings.YesNoNotInGames showJoinAndQuitMessages = PlayerSettings.YesNoNotInGames.valueOf(results.getInt("showJoinAndQuitMessages"));
                    boolean showPrivateMessages = results.getBoolean("showPrivateMessages");
                    PlayerSettings.YesNoNotInGames showNewsticker = PlayerSettings.YesNoNotInGames.valueOf(results.getInt("showNewsticker"));
                    boolean showCompassInSurvival = results.getBoolean("showCompassInSurvival");
                    PlayerSettings.YesNoNotInGames soundOnPrivateMessage = PlayerSettings.YesNoNotInGames.valueOf(results.getInt("soundOnPrivateMessage"));
                    PlayerSettings.YesNoNotInGames soundOnReference = PlayerSettings.YesNoNotInGames.valueOf(results.getInt("soundOnReference"));
                    String aliasNames = results.getString("aliasNames");
                    String[] aliasNamesArray = new String[]{};
                    if (aliasNames != null && aliasNames.length() > 0) {
                        aliasNamesArray = aliasNames.split(",");
                    }
                    rv = new PlayerSettings(SettingsDatabase.this.plugin, player, aliasNamesArray, showPublicChat, showJoinAndQuitMessages, showPrivateMessages, showNewsticker, soundOnPrivateMessage, soundOnReference, showCompassInSurvival);
                } else {
                    rv = new PlayerSettings(SettingsDatabase.this.plugin, player);
                }
                results.close();
                return rv;
            }
        });
    }

    public void updateShowPublicChat(final UUID player, final PlayerSettings.YesNoNotInGames value) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(SettingsDatabase.this.updateSettingShowPublicChat);
                smt.setString(1, player.toString());
                smt.setInt(2, value.ordinal());
                smt.setInt(3, value.ordinal());
                smt.executeUpdate();
                return null;
            }
        });
    }

    public void updateShowJoinAndQuitMessages(final UUID player, final PlayerSettings.YesNoNotInGames value) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(SettingsDatabase.this.updateShowJoinAndQuitMessages);
                smt.setString(1, player.toString());
                smt.setInt(2, value.ordinal());
                smt.setInt(3, value.ordinal());
                smt.executeUpdate();
                return null;
            }
        });
    }

    public void updateShowPrivateMessages(final UUID player, final boolean value) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(SettingsDatabase.this.updateShowPrivateMessages);
                smt.setString(1, player.toString());
                smt.setInt(2, value ? 1 : 0);
                smt.setInt(3, value ? 1 : 0);
                smt.executeUpdate();
                return null;
            }
        });
    }

    public void updateShowNewsticker(final UUID player, final PlayerSettings.YesNoNotInGames value) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(SettingsDatabase.this.updateShowNewsticker);
                smt.setString(1, player.toString());
                smt.setInt(2, value.ordinal());
                smt.setInt(3, value.ordinal());
                smt.executeUpdate();
                return null;
            }
        });
    }

    public void updateSoundOnPrivateMessage(final UUID player, final PlayerSettings.YesNoNotInGames value) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(SettingsDatabase.this.updateSoundOnPrivateMessage);
                smt.setString(1, player.toString());
                smt.setInt(2, value.ordinal());
                smt.setInt(3, value.ordinal());
                smt.executeUpdate();
                return null;
            }
        });
    }

    public void updateSoundOnReference(final UUID player, final PlayerSettings.YesNoNotInGames value) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(SettingsDatabase.this.updateSoundOnReference);
                smt.setString(1, player.toString());
                smt.setInt(2, value.ordinal());
                smt.setInt(3, value.ordinal());
                smt.executeUpdate();
                return null;
            }
        });
    }

    public void updateShowCompassInSurvival(final UUID player, final boolean value) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(SettingsDatabase.this.updateShowCompassInSurvival);
                smt.setString(1, player.toString());
                smt.setInt(2, value ? 1 : 0);
                smt.setInt(3, value ? 1 : 0);
                smt.executeUpdate();
                return null;
            }
        });
    }

    public void updateAliasNames(final UUID player, final String value) throws SQLException {
        this.connection.runCommands(new SQLRunnable<Void>(){

            @Override
            public Void execute(Connection connection, SQLConnection sqlConnection) throws SQLException {
                PreparedStatement smt = sqlConnection.getOrCreateStatement(SettingsDatabase.this.updateAliasNames);
                smt.setString(1, player.toString());
                smt.setString(2, value);
                smt.setString(3, value);
                smt.executeUpdate();
                return null;
            }
        });
    }
}

