/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.paper1_21_9;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import com.mojang.datafixers.DSL;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.cubeside.nmsutils.NbtUtils;
import de.cubeside.nmsutils.nbt.CompoundTag;
import de.cubeside.nmsutils.nbt.ListTag;
import de.cubeside.nmsutils.paper1_21_9.CompoundTagImpl;
import de.cubeside.nmsutils.paper1_21_9.ListTagImpl;
import de.cubeside.nmsutils.paper1_21_9.NMSUtilsImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class NbtUtilsImpl
implements NbtUtils {
    private final NMSUtilsImpl nmsUtils;

    public NbtUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public CompoundTag createEmptyCompound() {
        return new CompoundTagImpl(new NBTTagCompound());
    }

    @Override
    public ListTag createEmptyList() {
        return new ListTagImpl(new NBTTagList());
    }

    @Override
    public CompoundTag parseBinary(byte[] in) {
        try {
            return new CompoundTagImpl(NBTCompressedStreamTools.a((DataInput)new DataInputStream(new ByteArrayInputStream(in))));
        }
        catch (IOException e) {
            throw new RuntimeException("invalid nbt");
        }
    }

    @Override
    public byte[] writeBinary(CompoundTag in) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.a((NBTTagCompound)((CompoundTagImpl)in).handle, (DataOutput)new DataOutputStream(os));
        }
        catch (IOException e) {
            throw new RuntimeException("could not serialize nbt");
        }
        return os.toByteArray();
    }

    @Override
    public CompoundTag parseString(String in) {
        try {
            return new CompoundTagImpl(GameProfileSerializer.a((String)in));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse snbt string", e);
        }
    }

    @Override
    public String writeString(CompoundTag in) {
        return GameProfileSerializer.a((NBTTagCompound)((CompoundTagImpl)in).handle);
    }

    @Override
    public int getCurrentDataVersion() {
        return SharedConstants.b().a().b();
    }

    private CompoundTag updateNbt(DSL.TypeReference type, CompoundTag in, int oldVersion) {
        int currentVersion = this.getCurrentDataVersion();
        if (oldVersion >= currentVersion || in == null) {
            return in;
        }
        Dynamic dyn = new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)((CompoundTagImpl)in).handle);
        NBTBase out = (NBTBase)DataConverterRegistry.a().update(type, dyn, oldVersion, currentVersion).getValue();
        if (out instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)out;
            return new CompoundTagImpl(compound);
        }
        throw new RuntimeException("Expected CompoundTag as result of update, but got " + out.getClass().getName() + " !");
    }

    private String updateName(DSL.TypeReference type, String in, int oldVersion) {
        int currentVersion = this.getCurrentDataVersion();
        if (oldVersion >= currentVersion || in == null) {
            return in;
        }
        NBTBase out = (NBTBase)DataConverterRegistry.a().update(type, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)NBTTagString.a((String)in)), oldVersion, currentVersion).getValue();
        if (out instanceof NBTTagString) {
            NBTTagString stringTag = (NBTTagString)out;
            return stringTag.k();
        }
        throw new RuntimeException("Expected StringTag as result of update, but got " + out.getClass().getName() + " !");
    }

    @Override
    public CompoundTag updateEntity(CompoundTag in, int oldVersion) {
        return this.updateNbt(DataConverterTypes.F, in, oldVersion);
    }

    @Override
    public CompoundTag updateItem(CompoundTag in, int oldVersion) {
        return this.updateNbt(DataConverterTypes.v, in, oldVersion);
    }

    @Override
    public CompoundTag updateBlockEntity(CompoundTag in, int oldVersion) {
        return this.updateNbt(DataConverterTypes.u, in, oldVersion);
    }

    @Override
    public String updateItemTypeName(String in, int oldVersion) {
        return this.updateName(DataConverterTypes.H, in, oldVersion);
    }

    @Override
    public String updateBlockTypeName(String in, int oldVersion) {
        return this.updateName(DataConverterTypes.G, in, oldVersion);
    }

    @Override
    public CompoundTag getItemStackNbt(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)net.minecraft.world.item.ItemStack.b.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a), (Object)CraftItemStack.asNMSCopy((ItemStack)stack)).getOrThrow();
        GameProfileSerializer.e((NBTTagCompound)compoundTag);
        return new CompoundTagImpl(compoundTag);
    }

    @Override
    public ItemStack createItemStack(CompoundTag tag) {
        NBTTagCompound compound = ((CompoundTagImpl)tag).handle;
        int dataVersion = compound.b("DataVersion", 0);
        compound = PlatformHooks.get().convertNBT(DataConverterTypes.v, DataConverterRegistry.a(), compound, dataVersion, this.getCurrentDataVersion());
        if (compound.b("id", "minecraft:air").equals("minecraft:air")) {
            return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.l);
        }
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a), (Object)compound).getOrThrow()));
    }

    @Override
    public CompoundTag getBlockEntityNbt(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        BlockPosition blockPosition = craftBlock.getPosition();
        TileEntity tileEntity = craftBlock.getHandle().c_(blockPosition);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag = tileEntity.b((HolderLookup.a)CraftRegistry.getMinecraftRegistry());
        return new CompoundTagImpl(tag);
    }

    @Override
    public void setBlockEntityNbt(Block block, CompoundTag tag) {
        CraftBlock craftBlock = (CraftBlock)block;
        BlockPosition blockPosition = craftBlock.getPosition();
        TileEntity tileEntity = craftBlock.getHandle().c_(blockPosition);
        if (tileEntity == null) {
            return;
        }
        NBTTagCompound nativeNbt = ((CompoundTagImpl)tag).handle;
        try (ProblemReporter.j scopedCollector = new ProblemReporter.j(tileEntity.v(), this.nmsUtils.getPlugin().getSLF4JLogger());){
            ValueInput valueInput = TagValueInput.a((ProblemReporter)scopedCollector, (HolderLookup.a)craftBlock.getHandle().L_(), (NBTTagCompound)nativeNbt);
            tileEntity.b(valueInput);
        }
    }
}

