/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.paper1_21_11;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import com.mojang.datafixers.DSL;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import de.cubeside.nmsutils.NbtUtils;
import de.cubeside.nmsutils.nbt.CompoundTag;
import de.cubeside.nmsutils.paper1_21_11.CompoundTagImpl;
import de.cubeside.nmsutils.paper1_21_11.ListTagImpl;
import de.cubeside.nmsutils.paper1_21_11.NMSUtilsImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public class NbtUtilsImpl
implements NbtUtils {
    private final NMSUtilsImpl nmsUtils;

    public NbtUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public CompoundTag createEmptyCompound() {
        return new CompoundTagImpl(new net.minecraft.nbt.CompoundTag());
    }

    @Override
    public de.cubeside.nmsutils.nbt.ListTag createEmptyList() {
        return new ListTagImpl(new ListTag());
    }

    @Override
    public CompoundTag parseBinary(byte[] in) {
        try {
            return new CompoundTagImpl(NbtIo.read((DataInput)new DataInputStream(new ByteArrayInputStream(in))));
        }
        catch (IOException e) {
            throw new RuntimeException("invalid nbt");
        }
    }

    @Override
    public byte[] writeBinary(CompoundTag in) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            NbtIo.write((net.minecraft.nbt.CompoundTag)((CompoundTagImpl)in).handle, (DataOutput)new DataOutputStream(os));
        }
        catch (IOException e) {
            throw new RuntimeException("could not serialize nbt");
        }
        return os.toByteArray();
    }

    @Override
    public CompoundTag parseString(String in) {
        try {
            return new CompoundTagImpl(net.minecraft.nbt.NbtUtils.snbtToStructure((String)in));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse snbt string", e);
        }
    }

    @Override
    public String writeString(CompoundTag in) {
        return net.minecraft.nbt.NbtUtils.structureToSnbt((net.minecraft.nbt.CompoundTag)((CompoundTagImpl)in).handle);
    }

    @Override
    public int getCurrentDataVersion() {
        return SharedConstants.getCurrentVersion().dataVersion().version();
    }

    private CompoundTag updateNbt(DSL.TypeReference type, CompoundTag in, int oldVersion) {
        int currentVersion = this.getCurrentDataVersion();
        if (oldVersion >= currentVersion || in == null) {
            return in;
        }
        Dynamic dyn = new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)((CompoundTagImpl)in).handle);
        Tag out = (Tag)DataFixers.getDataFixer().update(type, dyn, oldVersion, currentVersion).getValue();
        if (out instanceof net.minecraft.nbt.CompoundTag) {
            net.minecraft.nbt.CompoundTag compound = (net.minecraft.nbt.CompoundTag)out;
            return new CompoundTagImpl(compound);
        }
        throw new RuntimeException("Expected CompoundTag as result of update, but got " + out.getClass().getName() + " !");
    }

    private String updateName(DSL.TypeReference type, String in, int oldVersion) {
        int currentVersion = this.getCurrentDataVersion();
        if (oldVersion >= currentVersion || in == null) {
            return in;
        }
        Tag out = (Tag)DataFixers.getDataFixer().update(type, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)StringTag.valueOf((String)in)), oldVersion, currentVersion).getValue();
        if (out instanceof StringTag) {
            StringTag stringTag = (StringTag)out;
            return stringTag.value();
        }
        throw new RuntimeException("Expected StringTag as result of update, but got " + out.getClass().getName() + " !");
    }

    @Override
    public CompoundTag updateEntity(CompoundTag in, int oldVersion) {
        return this.updateNbt(References.ENTITY, in, oldVersion);
    }

    @Override
    public CompoundTag updateItem(CompoundTag in, int oldVersion) {
        return this.updateNbt(References.ITEM_STACK, in, oldVersion);
    }

    @Override
    public CompoundTag updateBlockEntity(CompoundTag in, int oldVersion) {
        return this.updateNbt(References.BLOCK_ENTITY, in, oldVersion);
    }

    @Override
    public String updateItemTypeName(String in, int oldVersion) {
        return this.updateName(References.ITEM_NAME, in, oldVersion);
    }

    @Override
    public String updateBlockTypeName(String in, int oldVersion) {
        return this.updateName(References.BLOCK_NAME, in, oldVersion);
    }

    @Override
    public CompoundTag getItemStackNbt(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        net.minecraft.nbt.CompoundTag compoundTag = (net.minecraft.nbt.CompoundTag)net.minecraft.world.item.ItemStack.CODEC.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)CraftItemStack.asNMSCopy((ItemStack)stack)).getOrThrow();
        net.minecraft.nbt.NbtUtils.addCurrentDataVersion((net.minecraft.nbt.CompoundTag)compoundTag);
        return new CompoundTagImpl(compoundTag);
    }

    @Override
    public ItemStack createItemStack(CompoundTag tag) {
        net.minecraft.nbt.CompoundTag compound = ((CompoundTagImpl)tag).handle;
        int dataVersion = compound.getIntOr("DataVersion", 0);
        compound = PlatformHooks.get().convertNBT(References.ITEM_STACK, DataFixers.getDataFixer(), compound, dataVersion, this.getCurrentDataVersion());
        if (compound.getStringOr("id", "minecraft:air").equals("minecraft:air")) {
            return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.EMPTY);
        }
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.CODEC.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound).getOrThrow()));
    }

    @Override
    public CompoundTag getBlockEntityNbt(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        BlockPos blockPosition = craftBlock.getPosition();
        BlockEntity tileEntity = craftBlock.getHandle().getBlockEntity(blockPosition);
        if (tileEntity == null) {
            return null;
        }
        net.minecraft.nbt.CompoundTag tag = new net.minecraft.nbt.CompoundTag();
        tag = tileEntity.saveWithFullMetadata((HolderLookup.Provider)CraftRegistry.getMinecraftRegistry());
        return new CompoundTagImpl(tag);
    }

    @Override
    public void setBlockEntityNbt(Block block, CompoundTag tag) {
        CraftBlock craftBlock = (CraftBlock)block;
        BlockPos blockPosition = craftBlock.getPosition();
        BlockEntity tileEntity = craftBlock.getHandle().getBlockEntity(blockPosition);
        if (tileEntity == null) {
            return;
        }
        net.minecraft.nbt.CompoundTag nativeNbt = ((CompoundTagImpl)tag).handle;
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(tileEntity.problemPath(), this.nmsUtils.getPlugin().getSLF4JLogger());){
            ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)craftBlock.getHandle().registryAccess(), (net.minecraft.nbt.CompoundTag)nativeNbt);
            tileEntity.loadWithComponents(valueInput);
        }
    }
}

