/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.paper1_21_4;

import de.cubeside.nmsutils.BlockUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.paper1_21_4.NMSUtilsImpl;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.TrialSpawner;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class BlockUtilsImpl
implements BlockUtils {
    private final NMSUtilsImpl nmsUtils;
    private Field vaultRewardedPlayersField;
    private Field trialSpawnerDataCooldownEndsAtField;

    public BlockUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    @Override
    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    @Override
    public boolean useBlock(org.bukkit.block.Block block, Player player) {
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        MovingObjectPositionBlock blockHitResult = new MovingObjectPositionBlock(craftBlock.getPosition().b(), EnumDirection.b, craftBlock.getPosition(), false);
        return craftBlock.getNMS().a((World)world.getHandle(), (EntityHuman)((CraftPlayer)player).getHandle(), blockHitResult).a();
    }

    @Override
    public Set<UUID> getVaultRewardedPlayers(org.bukkit.block.Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        TileEntity blockEntity = world.getHandle().c_(craftBlock.getPosition());
        if (!(blockEntity instanceof VaultBlockEntity)) {
            throw new IllegalArgumentException("This block is not a vault");
        }
        VaultBlockEntity vaultBlock = (VaultBlockEntity)blockEntity;
        VaultServerData serverData = vaultBlock.b();
        if (this.vaultRewardedPlayersField == null) {
            for (Field field : serverData.getClass().getDeclaredFields()) {
                if (!Set.class.isAssignableFrom(field.getType())) continue;
                this.vaultRewardedPlayersField = field;
                field.setAccessible(true);
            }
            if (this.vaultRewardedPlayersField == null) {
                throw new IllegalStateException("vaultRewardedPlayersField not found!");
            }
        }
        try {
            Set playersSet = (Set)this.vaultRewardedPlayersField.get(serverData);
            return Collections.unmodifiableSet(playersSet);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Could not access vault rewardedPlayers field", e);
        }
    }

    @Override
    public void setTrialSpawnerCooldown(org.bukkit.block.Block block, int ticks) {
        Field[] fieldArray;
        TrialSpawnerBlockEntity trialSpawnerBlock;
        CraftWorld world;
        block9: {
            block8: {
                CraftBlock craftBlock = (CraftBlock)block;
                world = (CraftWorld)block.getWorld();
                TileEntity blockEntity = world.getHandle().c_(craftBlock.getPosition());
                if (!(blockEntity instanceof TrialSpawnerBlockEntity)) break block8;
                trialSpawnerBlock = (TrialSpawnerBlockEntity)blockEntity;
                fieldArray = block.getBlockData();
                if (fieldArray instanceof TrialSpawner) break block9;
            }
            throw new IllegalArgumentException("This block is not a trial spawner");
        }
        TrialSpawner spawnerData = (TrialSpawner)fieldArray;
        if (this.trialSpawnerDataCooldownEndsAtField == null) {
            for (Field field : TrialSpawnerData.class.getDeclaredFields()) {
                if (!Long.TYPE.isAssignableFrom(field.getType())) continue;
                this.trialSpawnerDataCooldownEndsAtField = field;
                field.setAccessible(true);
                break;
            }
            if (this.trialSpawnerDataCooldownEndsAtField == null) {
                throw new IllegalStateException("trialSpawnerDataCooldownEndsAtField not found!");
            }
        }
        trialSpawnerBlock.b.f().a();
        long cooldownEnd = world.getHandle().ad() + (long)ticks;
        try {
            this.trialSpawnerDataCooldownEndsAtField.set(trialSpawnerBlock.b.f(), cooldownEnd);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Could not access trialSpawnerData cooldownEndsAt field", e);
        }
        spawnerData.setTrialSpawnerState(TrialSpawner.State.COOLDOWN);
        block.setBlockData((BlockData)spawnerData);
    }

    @Override
    public void setTrialSpawnerConfig(org.bukkit.block.Block block, NamespacedKey key) {
        CraftBlock craftBlock = (CraftBlock)block;
        CraftWorld world = (CraftWorld)block.getWorld();
        TileEntity blockEntity = world.getHandle().c_(craftBlock.getPosition());
        if (!(blockEntity instanceof TrialSpawnerBlockEntity)) {
            throw new IllegalArgumentException("This block is not a trial spawner");
        }
        TrialSpawnerBlockEntity trialSpawnerBlock = (TrialSpawnerBlockEntity)blockEntity;
        IRegistry trialSpawnerConfigRegistry = (IRegistry)MinecraftServer.getServer().ba().a(Registries.bd).get();
        MinecraftKey normal = MinecraftKey.a((String)key.namespace(), (String)(key.value() + "/normal"));
        MinecraftKey ominous = MinecraftKey.a((String)key.namespace(), (String)(key.value() + "/ominous"));
        Optional normalConfig = trialSpawnerConfigRegistry.c(normal);
        Optional ominousConfig = trialSpawnerConfigRegistry.c(ominous);
        if (normalConfig.isEmpty() || ominousConfig.isEmpty()) {
            throw new IllegalArgumentException("Config does not exist: " + String.valueOf(key));
        }
        trialSpawnerBlock.b.i = (Holder)normalConfig.get();
        trialSpawnerBlock.b.j = (Holder)ominousConfig.get();
    }

    @Override
    public Set<NamespacedKey> getTrialSpawnerConfigs() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        IRegistry trialSpawnerConfigRegistry = (IRegistry)MinecraftServer.getServer().ba().a(Registries.bd).get();
        for (MinecraftKey loc : trialSpawnerConfigRegistry.i()) {
            if (!loc.a().endsWith("/normal")) continue;
            String path = loc.a().substring(0, loc.a().length() - 7);
            result.add(new NamespacedKey(loc.b(), path));
        }
        return result;
    }

    @Override
    public int getNetworkBlockDataId(BlockData block) {
        return Block.j((IBlockData)((CraftBlockData)block).getState());
    }
}

