/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.nbt;

import de.cubeside.nmsutils.nbt.NumericTag;
import de.cubeside.nmsutils.nbt.Tag;
import de.cubeside.nmsutils.nbt.TagType;

public final class DoubleTag
extends Tag
implements NumericTag {
    private double value;

    public DoubleTag(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public int getValueAsInt() {
        return (int)this.value;
    }

    @Override
    public long getValueAsLong() {
        return (long)this.value;
    }

    @Override
    public double getValueAsDouble() {
        return this.value;
    }

    @Override
    public TagType getType() {
        return TagType.DOUBLE;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleTag)) return false;
        DoubleTag o = (DoubleTag)obj;
        if (Double.doubleToLongBits(this.value) != Double.doubleToLongBits(o.value)) return false;
        return true;
    }
}

