/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.nbt;

import com.google.common.base.Preconditions;
import de.cubeside.nmsutils.nbt.Tag;
import de.cubeside.nmsutils.nbt.TagType;
import java.util.Arrays;

public final class ByteArrayTag
extends Tag {
    private byte[] value;

    public ByteArrayTag(byte[] value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    @Override
    public TagType getType() {
        return TagType.BYTE_ARRAY;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ByteArrayTag)) return false;
        ByteArrayTag o = (ByteArrayTag)obj;
        if (!Arrays.equals(this.value, o.value)) return false;
        return true;
    }
}

