/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.bukkit.Bukkit;

public enum ReobfHelper {
    INSTANCE;

    public static final String MOJANG_PLUS_YARN_NAMESPACE = "mojang+yarn";
    public static final String SPIGOT_NAMESPACE = "spigot";
    private final Map<String, ClassMapping> mappingsByObfName;
    private final Map<String, ClassMapping> mappingsByMojangName;
    static final Map<String, ClassMapping> mappings;

    private ReobfHelper() {
        Set<ClassMapping> maps = ReobfHelper.loadMappingsIfPresent();
        if (maps != null) {
            this.mappingsByObfName = maps.stream().collect(Collectors.toUnmodifiableMap(ClassMapping::obfName, map -> map));
            this.mappingsByMojangName = maps.stream().collect(Collectors.toUnmodifiableMap(ClassMapping::mojangName, map -> map));
        } else {
            this.mappingsByObfName = null;
            this.mappingsByMojangName = null;
        }
    }

    public Map<String, ClassMapping> mappingsByObfName() {
        return this.mappingsByObfName;
    }

    public Map<String, ClassMapping> mappingsByMojangName() {
        return this.mappingsByMojangName;
    }

    public String reobfClassName(String fullyQualifiedMojangName) {
        if (this.mappingsByMojangName == null) {
            return fullyQualifiedMojangName;
        }
        ClassMapping map = this.mappingsByMojangName.get(fullyQualifiedMojangName);
        if (map == null) {
            return fullyQualifiedMojangName;
        }
        return map.obfName();
    }

    public String deobfClassName(String fullyQualifiedObfName) {
        if (this.mappingsByObfName == null) {
            return fullyQualifiedObfName;
        }
        ClassMapping map = this.mappingsByObfName.get(fullyQualifiedObfName);
        if (map == null) {
            return fullyQualifiedObfName;
        }
        return map.mojangName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<ClassMapping> loadMappingsIfPresent() {
        try (InputStream mappingsInputStream = Bukkit.class.getClassLoader().getResourceAsStream("META-INF/mappings/reobf.tiny");){
            if (mappingsInputStream == null) {
                Set<ClassMapping> set2 = null;
                return set2;
            }
            MemoryMappingTree tree = new MemoryMappingTree();
            MappingReader.read((Reader)new InputStreamReader(mappingsInputStream, StandardCharsets.UTF_8), (MappingFormat)MappingFormat.TINY_2, (MappingVisitor)tree);
            HashSet<ClassMapping> classes = new HashSet<ClassMapping>();
            StringPool pool = new StringPool();
            for (MappingTree.ClassMapping cls : tree.getClasses()) {
                HashMap<String, String> methods = new HashMap<String, String>();
                HashMap<String, String> fields = new HashMap<String, String>();
                for (MappingTree.MethodMapping methodMapping : cls.getMethods()) {
                    methods.put(pool.string(ReobfHelper.methodOrFieldKey(methodMapping.getName(MOJANG_PLUS_YARN_NAMESPACE), methodMapping.getDesc(MOJANG_PLUS_YARN_NAMESPACE))), pool.string(methodMapping.getName(SPIGOT_NAMESPACE)));
                }
                for (MappingTree.FieldMapping fieldsMapping : cls.getFields()) {
                    fields.put(pool.string(fieldsMapping.getName(MOJANG_PLUS_YARN_NAMESPACE)), pool.string(fieldsMapping.getName(SPIGOT_NAMESPACE)));
                }
                ClassMapping map = new ClassMapping(cls.getName(SPIGOT_NAMESPACE).replace('/', '.'), cls.getName(MOJANG_PLUS_YARN_NAMESPACE).replace('/', '.'), Map.copyOf(methods), Map.copyOf(fields));
                classes.add(map);
            }
            Set set = Set.copyOf(classes);
            return set;
        }
        catch (IOException ex) {
            System.err.println("Failed to load mappings for stacktrace deobfuscation.");
            ex.printStackTrace();
            return null;
        }
    }

    public static String methodOrFieldKey(String obfName, String obfDescriptor) {
        return obfName + obfDescriptor;
    }

    public static String getObfuscatedFieldName(Class<?> clazz, String field) {
        String fieldName;
        ClassMapping classMapping;
        if (mappings != null && (classMapping = mappings.get(clazz.getName())) != null && (fieldName = classMapping.fieldsByMojang().get(field)) != null) {
            return fieldName;
        }
        return field;
    }

    public static Field getFieldByMojangName(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(ReobfHelper.getObfuscatedFieldName(clazz, fieldName));
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mappings = INSTANCE.mappingsByObfName();
    }

    public record ClassMapping(String obfName, String mojangName, Map<String, String> methodsByMojang, Map<String, String> fieldsByMojang) {
    }

    private static final class StringPool {
        private final Map<String, String> pool = new HashMap<String, String>();

        private StringPool() {
        }

        public String string(String string) {
            return this.pool.computeIfAbsent(string, Function.identity());
        }
    }
}

