/*
 * Decompiled with CFR 0.152.
 */
package de.cubeside.nmsutils.v1_20_R1;

import com.destroystokyo.paper.entity.ai.VanillaGoal;
import de.cubeside.nmsutils.EntityUtils;
import de.cubeside.nmsutils.NMSUtils;
import de.cubeside.nmsutils.nbt.CompoundTag;
import de.cubeside.nmsutils.v1_20_R1.CompoundTagImpl;
import de.cubeside.nmsutils.v1_20_R1.NMSUtilsImpl;
import de.cubeside.nmsutils.v1_20_R1.PathfinderGoalLimitedRandomStrollLand;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftBat;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftCamel;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftVex;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftWolf;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Wolf;
import org.bukkit.util.Vector;

public class EntityUtilsImpl
implements EntityUtils {
    private final NMSUtilsImpl nmsUtils;

    public EntityUtilsImpl(NMSUtilsImpl nmsUtils) {
        this.nmsUtils = nmsUtils;
    }

    public NMSUtils getNMSUtils() {
        return this.nmsUtils;
    }

    public void clearAI(Entity entity) {
        if (entity instanceof Mob) {
            this.nmsUtils.getPlugin().getServer().getMobGoals().removeAllGoals((Mob)entity);
        }
    }

    public void addGoalFloat(Mob mob) {
        if (!Bukkit.getMobGoals().hasGoal(mob, VanillaGoal.FLOAT)) {
            bgb h = ((CraftMob)mob).getHandle();
            h.bO.a(1, (bmv)new bmp(h));
        }
    }

    public void addGoalLimitedStrollLand(Creature mob, double velocity, Function<Vector, Boolean> checkTargetFunction) {
        bgi h = ((CraftCreature)mob).getHandle();
        h.bO.a(7, (bmv)new PathfinderGoalLimitedRandomStrollLand(h, velocity, checkTargetFunction));
    }

    public void removeGoalLimitedStrollLand(Creature mob) {
        bgi h = ((CraftCreature)mob).getHandle();
        for (boj wrappedGoal : h.bO.b()) {
            bmv bmv2 = wrappedGoal.k();
            if (!(bmv2 instanceof PathfinderGoalLimitedRandomStrollLand)) continue;
            PathfinderGoalLimitedRandomStrollLand goal = (PathfinderGoalLimitedRandomStrollLand)bmv2;
            wrappedGoal.d();
            h.bO.a((bmv)goal);
            break;
        }
    }

    public int getShulkerOpenState(Entity shulker) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return 0;
            }
            CraftShulker cs = (CraftShulker)shulker;
            return cs.getHandle().gf();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get shulker open state", e);
            return 0;
        }
    }

    public void setShulkerOpenState(Entity shulker, int state) {
        try {
            if (shulker.getType() != EntityType.SHULKER) {
                return;
            }
            state = Math.max(0, Math.min(127, state));
            CraftShulker cs = (CraftShulker)shulker;
            cs.getHandle().b(state);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set shulker open state", e);
        }
    }

    public boolean isPiglinDancing(Entity piglin) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return false;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            return cs.getHandle().gg();
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not get piglin dancing state", e);
            return false;
        }
    }

    public void setPiglinDancing(Entity piglin, boolean dancing) {
        try {
            if (piglin.getType() != EntityType.PIGLIN) {
                return;
            }
            CraftPiglin cs = (CraftPiglin)piglin;
            cs.getHandle().x(dancing);
        }
        catch (Exception e) {
            this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Could not set piglin dancing state", e);
        }
    }

    public void sendEntityPositionUpdate(Entity entity) {
        bfj handle = ((CraftEntity)entity).getHandle();
        ahr.b ete = handle.tracker;
        if (ete != null) {
            ys positionPacket = new ys(handle);
            ete.f.stream().forEach(viewer -> viewer.a((uo)positionPacket));
        }
    }

    public void moveEntity(Entity e, double x, double y, double z) {
        bfj handle = ((CraftEntity)e).getHandle();
        handle.a(bgf.a, new eei(x, y, z));
    }

    public void moveEntity(Entity e, Vector v) {
        this.moveEntity(e, v.getX(), v.getY(), v.getZ());
    }

    public void setEntityHeadRotation(Entity e, float headRotation) {
        bfj handle = ((CraftEntity)e).getHandle();
        if (handle instanceof bfz) {
            ((bfz)handle).aX = headRotation;
        } else {
            handle.n(headRotation);
        }
    }

    public float getEntityHeadRotation(Entity e) {
        bfj handle = ((CraftEntity)e).getHandle();
        return handle.cm();
    }

    public void setEntityYaw(Entity e, float yaw) {
        bfj handle = ((CraftEntity)e).getHandle();
        handle.a_(yaw);
    }

    public float getEntityYaw(Entity e) {
        bfj handle = ((CraftEntity)e).getHandle();
        return handle.dy();
    }

    public void setEntityPitch(Entity e, float pitch) {
        bfj handle = ((CraftEntity)e).getHandle();
        handle.b_(pitch);
    }

    public float getEntityPitch(Entity e) {
        bfj handle = ((CraftEntity)e).getHandle();
        return handle.dA();
    }

    public void setEntityNavigationTarget(Entity entity, Location target, double speed) {
        if (entity instanceof Bat) {
            ((CraftBat)entity).getHandle().bT = new gu(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        } else if (entity instanceof Vex) {
            bwq entityVex = ((CraftVex)entity).getHandle();
            entityVex.G().a(target.getX(), target.getY(), target.getZ(), speed);
            if (entityVex.j() == null) {
                entityVex.E().a(target.getX(), target.getY(), target.getZ(), 180.0f, 20.0f);
            }
        } else if (entity instanceof CraftMob) {
            ((CraftMob)entity).getHandle().J().a(target.getX(), target.getY(), target.getZ(), speed);
        } else {
            throw new IllegalArgumentException("Cannot set the navigation target for this mob: " + (Serializable)((Object)(entity == null ? "null" : entity.getType())));
        }
    }

    public void setEntityLeftHanded(Entity ent, boolean left) {
        bfj nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof bgb) {
            bgb mob = (bgb)nmsEntity;
            mob.u(left);
        }
    }

    public boolean isEntityLeftHanded(Entity ent) {
        bfj nmsEntity = ((CraftEntity)ent).getHandle();
        if (nmsEntity instanceof bgb) {
            bgb mob = (bgb)nmsEntity;
            return mob.fR();
        }
        return false;
    }

    public boolean isEntityInvisible(Entity entity) {
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.cb();
    }

    public void setEntityInvisible(Entity entity, boolean invisible) {
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.j(invisible);
    }

    public boolean hasEntityNoClip(Entity entity) {
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        return nmsEntity.ae;
    }

    public void setEntityNoClip(Entity entity, boolean noClip) {
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.ae = noClip;
    }

    public boolean areChunkEntitiesLoaded(Chunk c) {
        return ((CraftWorld)c.getWorld()).getHandle().c(clt.c((int)c.getX(), (int)c.getZ()));
    }

    public void loadChunkEntities(Chunk c) {
        this.nmsUtils.getPlugin().getLogger().log(Level.SEVERE, "Call to unimplemented method", new RuntimeException());
    }

    public void setOnGround(Entity entity, boolean onGround) {
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.c(onGround);
    }

    public Entity getEntityById(World world, int id) {
        bfj entity = ((CraftWorld)world).getHandle().a(id);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void setPose(Entity entity, Pose pose) {
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.b(bgl.values()[pose.ordinal()]);
    }

    public void setWolfAngerTime(Wolf entity, int timeInTicks) {
        bso nmsEntity = ((CraftWolf)entity).getHandle();
        nmsEntity.a(timeInTicks);
    }

    public void setAggressive(Mob entity, boolean aggressive) {
        bgb nmsEntity = ((CraftMob)entity).getHandle();
        nmsEntity.v(aggressive);
    }

    public boolean isAggressive(Mob entity) {
        bgb nmsEntity = ((CraftMob)entity).getHandle();
        return nmsEntity.fS();
    }

    public boolean isCelebrating(Raider entity) {
        bzw nmsEntity = ((CraftRaider)entity).getHandle();
        return nmsEntity.gp();
    }

    public void setCelebrating(Raider entity, boolean celebrating) {
        bzw nmsEntity = ((CraftRaider)entity).getHandle();
        nmsEntity.A(celebrating);
    }

    public void setCamelLastPoseChange(Camel entity, long tick) {
        bsx nmsEntity = ((CraftCamel)entity).getHandle();
        nmsEntity.a(nmsEntity.dI().V() - tick);
    }

    public long getCamelLastPoseChange(Camel entity) {
        bsx nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.gm();
    }

    public boolean isCamelSitting(Camel entity) {
        bsx nmsEntity = ((CraftCamel)entity).getHandle();
        return nmsEntity.gg();
    }

    public CompoundTag getNbt(Entity entity) {
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        qr compoundTag = nmsEntity.f(new qr());
        return new CompoundTagImpl(compoundTag);
    }

    public void setNbt(Entity entity, CompoundTag nbt) {
        qr nativeNbt = ((CompoundTagImpl)nbt).handle;
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        UUID uuid = nmsEntity.ct();
        nmsEntity.g(nativeNbt);
        nmsEntity.a_(uuid);
    }

    public void mergeNbt(Entity entity, CompoundTag nbt) {
        qr newNbt;
        qr nativeNbt = ((CompoundTagImpl)nbt).handle;
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        qr oldNbt = nmsEntity.f(new qr());
        if (!oldNbt.equals((Object)(newNbt = oldNbt.h().a(nativeNbt)))) {
            UUID uuid = nmsEntity.ct();
            nmsEntity.g(newNbt);
            nmsEntity.a_(uuid);
        }
    }
}

